import { AnomalyDetectionModel, MiningSchema } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
export const ANOMALY_DETECTION_MODEL = `
elements.elements[(name = "AnomalyDetectionModel")] ~> $map(function($v, $i) {
  $merge([
    $anomalyDetectionModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_VERIFICATION},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function anomalyDetectionModelFactory() {
    return new AnomalyDetectionModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        functionName: "regression",
        algorithmType: "other",
    });
}
//# sourceMappingURL=AnomalyDetectionModel.js.map