import { DATA_DICTIONARY } from "./ui2json/DataDictionary";
import { HEADER } from "./ui2json/Header";
import { SCORE_CARD } from "./ui2json/Scorecard";
import { REGRESSION_MODEL } from "./ui2json/RegressionModel";
const MODELS = `$append(
  [],
  $append(
    ${SCORE_CARD},
    ${REGRESSION_MODEL}
  )
)`;
const PMML = `
"elements": [
  {
    "type": "element",
    "name": "PMML",
    "attributes": {
      "xmlns": "http://www.dmg.org/PMML-4_4",
      "version": "4.4"
    },
    "elements": $append(${HEADER}, $append(${DATA_DICTIONARY}, ${MODELS}))
  }
]`;
export const UI2JSON_TRANSFORMATION = `(
  $bootstrap := function($node) {
    { ${PMML} }
  };

  $ui2jsonPredicateFactory := function($node) {
    $node[(_type = "SimplePredicate")]
    ? 
      {
        "type": "element",
        "name": "SimplePredicate",
        "attributes": {
          "field": $node.field,
          "operator": $node.operator,
          "value": $node.value
        }
      }
    : 
    $node[(_type = "CompoundPredicate")] ? 
      {
        "type": "element",
        "name": "CompoundPredicate",
        "attributes": {
          "booleanOperator": $node.booleanOperator
        },
        "elements": $node.predicates ~> $map(function($v, $i) {
          $ui2jsonPredicateFactory($v)
        })
      }
    : 
    $node[(_type = "True")] ? 
      {
        "type": "element",
        "name": "True"
      }
    :
    $node[(_type = "False")] ? 
      {
        "type": "element",
        "name": "False"
      }
    :
      undefined
  };

  $bootstrap($$);

)`;
//# sourceMappingURL=UI2JSON.js.map