import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useState } from "react";
import _ from "lodash";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Toolbar, ToolbarContent, ToolbarFilter, ToolbarGroup, ToolbarItem, ToolbarToggleGroup, } from "@patternfly/react-core/dist/js/components/Toolbar";
import { InputGroup } from "@patternfly/react-core/dist/js/components/InputGroup";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { FilterIcon, SyncIcon } from "@patternfly/react-icons/dist/js/icons";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
var Category;
(function (Category) {
    Category["FORM_NAME"] = "Form name";
})(Category || (Category = {}));
const FormsListToolbar = ({ applyFilter, filterFormNames, setFilterFormNames, ouiaSafe, ouiaId, }) => {
    const [formNameInput, setFormNameInput] = useState("");
    const doResetFilter = () => {
        applyFilter({
            formNames: [],
        });
        setFilterFormNames([]);
    };
    const doRefresh = () => {
        applyFilter({
            formNames: [...filterFormNames],
        });
    };
    const onEnterClicked = (event) => {
        if (event.key === "Enter") {
            formNameInput.length > 0 && doApplyFilter();
        }
    };
    const onDeleteFilterGroup = (categoryName, value) => {
        const newFilterFormNames = [...filterFormNames];
        if (categoryName === Category.FORM_NAME) {
            _.remove(newFilterFormNames, (status) => {
                return status === value;
            });
            setFilterFormNames(newFilterFormNames);
            applyFilter({
                formNames: newFilterFormNames,
            });
        }
    };
    const doApplyFilter = () => {
        const newFormNames = [...filterFormNames];
        if (formNameInput && !newFormNames.includes(formNameInput)) {
            newFormNames.push(formNameInput);
            setFilterFormNames(newFormNames);
        }
        setFormNameInput("");
        applyFilter({
            formNames: newFormNames,
        });
    };
    const toggleGroupItems = (_jsx(React.Fragment, { children: _jsxs(ToolbarGroup, { variant: "filter-group", children: [_jsx(ToolbarFilter, { chips: filterFormNames, deleteChip: onDeleteFilterGroup, categoryName: Category.FORM_NAME, children: _jsx(InputGroup, { children: _jsx(TextInput, { name: "formName", id: "formName", type: "search", "aria-label": "form name", onChange: setFormNameInput, onKeyPress: onEnterClicked, placeholder: "Filter by Form name", value: formNameInput }) }) }, "input-form-name"), _jsx(ToolbarItem, { children: _jsx(Button, { id: "apply-filter", variant: "primary", onClick: doApplyFilter, children: "Apply Filter" }) })] }) }));
    const toolbarItems = (_jsxs(React.Fragment, { children: [_jsx(ToolbarToggleGroup, { toggleIcon: _jsx(FilterIcon, {}), breakpoint: "xl", children: toggleGroupItems }), _jsx(ToolbarGroup, { variant: "icon-button-group", children: _jsx(ToolbarItem, { children: _jsx(Tooltip, { content: "Refresh", children: _jsx(Button, { variant: "plain", onClick: doRefresh, id: "refresh", children: _jsx(SyncIcon, {}) }) }) }) })] }));
    return (_jsx(Toolbar, { id: "forms-list-with-filter", className: "pf-m-toggle-group-container", collapseListedFiltersBreakpoint: "xl", clearAllFilters: doResetFilter, clearFiltersButtonText: "Reset to default", ...componentOuiaProps(ouiaId, "forms-list-toolbar", ouiaSafe), children: _jsx(ToolbarContent, { children: toolbarItems }) }));
};
export default FormsListToolbar;
//# sourceMappingURL=FormsListToolbar.js.map