import { jsx as _jsx } from "react/jsx-runtime";
import React, { useImperativeHandle, useState } from "react";
import FormsList from "./components/FormsList/FormsList";
import FormsListEnvelopeViewDriver from "./FormsListEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const FormsListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    useImperativeHandle(forwardedRef, () => ({
        initialize: () => {
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(FormsList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new FormsListEnvelopeViewDriver(props.channelApi) }) }));
});
export default FormsListEnvelopeView;
//# sourceMappingURL=FormsListEnvelopeView.js.map