import { FormSubmitContext, FormSubmitResponse } from "../../../../api";
declare global {
    interface Window {
        Form: {
            openForm: (config: FormConfig) => EmbeddedFormApi;
        };
    }
}
export interface FormConfig {
    onOpen?: (args: InitArgs) => void;
    [key: string]: any;
}
export interface EmbeddedFormApi {
    beforeSubmit?: (context: FormSubmitContext) => void;
    afterSubmit?: (response: FormSubmitResponse) => void;
    getFormData?: () => any;
}
export interface InternalFormDisplayerApi extends EmbeddedFormApi {
    onOpen: (args: InitArgs) => void;
}
export declare class InternalFormDisplayerApiImpl implements InternalFormDisplayerApi {
    private readonly wrapped;
    private readonly onOpenCallback;
    constructor(api: EmbeddedFormApi, onOpenCallback: (data: any, ctx: any) => void);
    onOpen(args: InitArgs): void;
    afterSubmit(response: FormSubmitResponse): void;
    beforeSubmit(context: FormSubmitContext): void;
    getFormData(): any;
}
export type InitArgs = {
    data: any;
    context: Record<string, any>;
};
export declare enum SubmitResultType {
    SUCCESS = "success",
    ERROR = "error"
}
//# sourceMappingURL=InternalDisplayerApi.d.ts.map