"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeResourceContentServiceForWorkspaces = void 0;
var api_1 = require("@kie-tools-core/workspace/dist/api");
var vscode = require("vscode");
var __path = require("path");
var vscode_1 = require("vscode");
var isomorphic_git_1 = require("isomorphic-git");
var minimatch_1 = require("minimatch");
var VsCodeResourceContentServiceIsomorphicGitFs_1 = require("./VsCodeResourceContentServiceIsomorphicGitFs");
var paths_1 = require("../paths/paths");
var workspaceRoot_1 = require("./workspaceRoot");
var VsCodeResourceContentServiceForWorkspaces = (function () {
    function VsCodeResourceContentServiceForWorkspaces(args) {
        this.args = args;
        this.isomorphicGitFs = new VsCodeResourceContentServiceIsomorphicGitFs_1.ReadonlyIsomorphicGitFsForVsCodeWorkspaceFolders();
    }
    VsCodeResourceContentServiceForWorkspaces.prototype.list = function (pattern, opts) {
        return __awaiter(this, void 0, void 0, function () {
            var baseAbsoluteFsPath, normalizedPosixPathsRelativeToTheBasePath, minimatch, regexp_1, openFileDirectoryNormalizedPosixPathRelativeToTheWorkspaceRoot_1, matchingNormalizedPosixPathsRelativeToTheBasePath, error_1, relativePattern, files, normalizedPosixPathsRelativeToTheWorkspaceRoot;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!((_a = vscode.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length)) {
                            throw new Error("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: No workspaces found.");
                        }
                        baseAbsoluteFsPath = (opts === null || opts === void 0 ? void 0 : opts.type) === api_1.SearchType.ASSET_FOLDER
                            ? __path.join(this.args.workspaceRootAbsoluteFsPath, __path.dirname((0, workspaceRoot_1.getNormalizedPosixPathRelativeToWorkspaceRoot)(this.args.document)))
                            : this.args.workspaceRootAbsoluteFsPath;
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 5]);
                        console.debug("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: Trying to use isomorphic-git to read dir.");
                        return [4, (0, isomorphic_git_1.listFiles)({
                                fs: this.isomorphicGitFs,
                                dir: this.args.workspaceRootAbsoluteFsPath,
                            })];
                    case 2:
                        normalizedPosixPathsRelativeToTheBasePath = _b.sent();
                        console.debug("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: Success on using isomorphic-git!");
                        minimatch = new minimatch_1.Minimatch(pattern);
                        regexp_1 = minimatch.makeRe();
                        openFileDirectoryNormalizedPosixPathRelativeToTheWorkspaceRoot_1 = __path.dirname((0, workspaceRoot_1.getNormalizedPosixPathRelativeToWorkspaceRoot)(this.args.document));
                        matchingNormalizedPosixPathsRelativeToTheBasePath = normalizedPosixPathsRelativeToTheBasePath.filter(function (p) {
                            var matchesPattern = regexp_1.test("/" + p) ||
                                regexp_1.test(__path.posix.relative(openFileDirectoryNormalizedPosixPathRelativeToTheWorkspaceRoot_1, p));
                            var conformsToSearchType = !opts ||
                                opts.type === api_1.SearchType.TRAVERSAL ||
                                (opts.type === api_1.SearchType.ASSET_FOLDER &&
                                    __path
                                        .join(baseAbsoluteFsPath, (0, paths_1.toFsPath)(p))
                                        .startsWith(__path.join(baseAbsoluteFsPath, (0, paths_1.toFsPath)(openFileDirectoryNormalizedPosixPathRelativeToTheWorkspaceRoot_1))));
                            return matchesPattern && conformsToSearchType;
                        });
                        return [2, new api_1.ResourcesList(pattern, matchingNormalizedPosixPathsRelativeToTheBasePath)];
                    case 3:
                        error_1 = _b.sent();
                        console.debug("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: Failed to use isomorphic-git to read dir. Falling back to vscode's API.", error_1);
                        relativePattern = new vscode_1.RelativePattern(baseAbsoluteFsPath, pattern);
                        return [4, vscode.workspace.findFiles(relativePattern)];
                    case 4:
                        files = _b.sent();
                        normalizedPosixPathsRelativeToTheWorkspaceRoot = files.map(function (uri) {
                            return vscode.workspace.asRelativePath(uri, false);
                        });
                        return [2, new api_1.ResourcesList(pattern, normalizedPosixPathsRelativeToTheWorkspaceRoot)];
                    case 5: return [2];
                }
            });
        });
    };
    VsCodeResourceContentServiceForWorkspaces.prototype.get = function (normalizedPosixPathRelativeToTheWorkspaceRoot, opts) {
        return __awaiter(this, void 0, void 0, function () {
            var workspaceRootAbsoluteFsPath, normalizedFsPathRelativeToTheWorkspaceRoot, absoluteFsPath, content, e_1;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!((_a = vscode.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length)) {
                            throw new Error("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: No workspaces found.");
                        }
                        if (__path.isAbsolute(normalizedPosixPathRelativeToTheWorkspaceRoot)) {
                            throw new Error("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: Can't work with absolute paths. All paths must be relative to the workspace root.\nNormalized POSIX path relative to the workspace root: ".concat(normalizedPosixPathRelativeToTheWorkspaceRoot));
                        }
                        workspaceRootAbsoluteFsPath = vscode.workspace.workspaceFolders[0].uri.fsPath;
                        normalizedFsPathRelativeToTheWorkspaceRoot = (0, paths_1.toFsPath)(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        absoluteFsPath = __path.join(workspaceRootAbsoluteFsPath, normalizedFsPathRelativeToTheWorkspaceRoot);
                        if (__path.resolve(workspaceRootAbsoluteFsPath, normalizedFsPathRelativeToTheWorkspaceRoot) !== absoluteFsPath) {
                            throw new Error("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: Path relative to the workspace root trying to access files outside the workspace.\nAbsolute FS path: ".concat(absoluteFsPath, "\nResolved path: ").concat(__path.resolve(workspaceRootAbsoluteFsPath, normalizedFsPathRelativeToTheWorkspaceRoot), "\n"));
                        }
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        return [4, vscode.workspace.fs.readFile(vscode.Uri.file(absoluteFsPath))];
                    case 2:
                        content = _b.sent();
                        if ((opts === null || opts === void 0 ? void 0 : opts.type) === "binary") {
                            return [2, new api_1.ResourceContent(normalizedPosixPathRelativeToTheWorkspaceRoot, Buffer.from(content).toString("base64"), "binary")];
                        }
                        else {
                            return [2, new api_1.ResourceContent(normalizedPosixPathRelativeToTheWorkspaceRoot, Buffer.from(content).toString(), "text")];
                        }
                        return [3, 4];
                    case 3:
                        e_1 = _b.sent();
                        console.error("VS CODE RESOURCE CONTENT API IMPL FOR WORKSPACES: Error reading file ".concat(normalizedPosixPathRelativeToTheWorkspaceRoot, ". Returning undefined."), e_1);
                        return [2, new api_1.ResourceContent(normalizedPosixPathRelativeToTheWorkspaceRoot, undefined, opts === null || opts === void 0 ? void 0 : opts.type)];
                    case 4: return [2];
                }
            });
        });
    };
    return VsCodeResourceContentServiceForWorkspaces;
}());
exports.VsCodeResourceContentServiceForWorkspaces = VsCodeResourceContentServiceForWorkspaces;
//# sourceMappingURL=VsCodeResourceContentServiceForWorkspaces.js.map