import * as vscode from "vscode";
import { CancellationToken, CustomDocumentBackupContext, CustomDocumentOpenContext, CustomEditorProvider, Uri, WebviewPanel } from "vscode";
import { VsCodeKieEditorControllerFactory } from "./VsCodeKieEditorControllerFactory";
import { VsCodeKieEditorStore } from "./VsCodeKieEditorStore";
import { VsCodeKieEditorCustomDocument } from "./VsCodeKieEditorCustomDocument";
import { VsCodeI18n } from "./i18n";
import { I18n } from "@kie-tools-core/i18n/dist/core";
import { EditorEnvelopeLocator } from "@kie-tools-core/editor/dist/api";
import { VsCodeNotificationsChannelApiImpl } from "./notifications/VsCodeNotificationsChannelApiImpl";
export declare class VsCodeKieEditorsCustomEditorProvider implements CustomEditorProvider<VsCodeKieEditorCustomDocument> {
    private readonly context;
    private readonly viewType;
    private readonly editorStore;
    private readonly editorFactory;
    private readonly vsCodeI18n;
    private readonly vscodeNotifications;
    private readonly editorEnvelopeLocator;
    private readonly _onDidChangeCustomDocument;
    readonly onDidChangeCustomDocument: vscode.Event<vscode.CustomDocumentEditEvent<VsCodeKieEditorCustomDocument>>;
    constructor(context: vscode.ExtensionContext, viewType: string, editorStore: VsCodeKieEditorStore, editorFactory: VsCodeKieEditorControllerFactory, vsCodeI18n: I18n<VsCodeI18n>, vscodeNotifications: VsCodeNotificationsChannelApiImpl, editorEnvelopeLocator: EditorEnvelopeLocator);
    register(): vscode.Disposable;
    resolveCustomEditor(document: VsCodeKieEditorCustomDocument, webviewPanel: WebviewPanel, cancellation: CancellationToken): Promise<void>;
    openCustomDocument(uri: Uri, openContext: CustomDocumentOpenContext, cancellation: CancellationToken): Promise<VsCodeKieEditorCustomDocument>;
    saveCustomDocument(document: VsCodeKieEditorCustomDocument, cancellation: CancellationToken): Promise<void>;
    saveCustomDocumentAs(document: VsCodeKieEditorCustomDocument, dest: Uri, cancellation: CancellationToken): Promise<void>;
    revertCustomDocument(document: VsCodeKieEditorCustomDocument, cancellation: CancellationToken): Promise<void>;
    backupCustomDocument(document: VsCodeKieEditorCustomDocument, context: CustomDocumentBackupContext, cancellation: CancellationToken): Promise<vscode.CustomDocumentBackup>;
    private createStorageFolder;
    private setupListeners;
    private resolveBackupUri;
}
//# sourceMappingURL=VsCodeKieEditorsCustomEditorProvider.d.ts.map