import { EditorLanguageService, } from "@kie-tools/json-yaml-language-service/dist/channel";
import { YardLanguageServiceCodeCompletion, } from "./YardLanguageServiceCodeCompletion";
import { YardLanguageServiceCodeLenses } from "./YardLanguageServiceCodeLenses";
export class YardLanguageService {
    constructor(args) {
        this.args = args;
        this.els = new EditorLanguageService(this.args);
    }
    async getCompletionItems(args) {
        return this.els.getCompletionItems({
            ...args,
            completions,
        });
    }
    async getCodeLenses(args) {
        return this.els.getCodeLenses({
            ...args,
            codeLenses: YardLanguageServiceCodeLenses,
        });
    }
    async getDiagnostics(args) {
        return await this.els.getDiagnostics({
            ...args,
            getSchemaDiagnostics: args.getSchemaDiagnostics,
        });
    }
    async getSchemaDiagnostics(args) {
        return this.els.getSchemaDiagnostics(args);
    }
    dispose() {
        this.els.dispose();
    }
}
const completions = new Map([
    [null, YardLanguageServiceCodeCompletion.getEmptyFileCodeCompletions],
]);
//# sourceMappingURL=YardLanguageService.js.map