import { jsx as _jsx } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { useForm } from "uniforms";
function SubmitField({ disabled, inputRef, value, ...props }) {
    const { error, state } = useForm();
    return (_jsx(Button, { "data-testid": "submit-field", isDisabled: disabled === undefined ? !!(error || state.disabled) : disabled, type: "submit", ref: inputRef, variant: "primary", children: value }));
}
SubmitField.defaultProps = { value: "Submit" };
export default SubmitField;
//# sourceMappingURL=SubmitField.js.map