export const getTaskSchemaEndPoint = (task, user) => {
    let params = "";
    let endpoint = task.endpoint;
    if (task.completed) {
        endpoint = endpoint.slice(0, -(task.id.length + 1));
        endpoint = endpoint.replace(task.processInstanceId + "/", "");
    }
    else {
        params = `?${getTaskEndpointSecurityParams(user)}`;
    }
    return `${endpoint}/schema${params}`;
};
export const getTaskEndpointSecurityParams = (user) => {
    let groups = "";
    if (user.groups && user.groups.length > 0) {
        groups = `&group=${user.groups.join("&group=")}`;
    }
    return `user=${user.id}${groups}`;
};
export const resolveTaskPriority = (priority) => {
    switch (priority) {
        case "0":
            return "0 - High";
        case "5":
            return "5 - Medium";
        case "10":
            return "10 - Low";
    }
    return priority || "-";
};
export const trimTaskEndpoint = (userTask) => {
    if (userTask.endpoint) {
        const endpoint = userTask.endpoint;
        const pid = userTask.processInstanceId;
        return `${endpoint.substring(0, endpoint.indexOf(pid))}...`;
    }
    return "-";
};
export const getAllTaskStates = () => {
    if (window.KOGITO_TASK_STATES_LIST) {
        return window.KOGITO_TASK_STATES_LIST.split(",").map((state) => state.trim());
    }
    if (process.env.KOGITO_TASK_STATES_LIST) {
        return process.env.KOGITO_TASK_STATES_LIST.split(",").map((state) => state.trim());
    }
    return ["Ready", "Reserved", "Completed", "Aborted", "Skipped"];
};
export const getActiveTaskStates = () => {
    if (window.KOGITO_TASK_ACTIVE_STATES_LIST) {
        return window.KOGITO_TASK_ACTIVE_STATES_LIST.split(",").map((state) => state.trim());
    }
    if (process.env.KOGITO_TASK_ACTIVE_STATES_LIST) {
        return process.env.KOGITO_TASK_ACTIVE_STATES_LIST.split(",").map((state) => state.trim());
    }
    return ["Ready", "Reserved"];
};
//# sourceMappingURL=Utils.js.map