import { CodeGenElement, FormElement, FormInput } from "../../api";
import { CompiledTemplate } from "underscore";
import { ListItemProps } from "../rendering/ListFieldInput";
export interface CodeGenTemplate<Element extends CodeGenElement, Properties> {
    render: (props: Properties) => Element;
}
export interface FormElementTemplateProps<Type> {
    id: string;
    name: string;
    label: string;
    disabled: boolean;
    value: Type;
    itemProps: ListItemProps;
    type: string;
    placeholder?: string;
    autoComplete?: boolean;
    min?: string | number;
    max?: string | number;
    step?: number;
}
export interface FormElementTemplate<Element extends FormElement<any>, Properties extends FormElementTemplateProps<any>> {
    render: (props: Properties) => Element;
}
export declare abstract class AbstractFormGroupTemplate<Properties extends FormElementTemplateProps<any>> implements FormElementTemplate<FormInput, Properties> {
    readonly inputTemplate: CompiledTemplate;
    readonly setValueFromModelTemplate: CompiledTemplate;
    readonly writeValueToModelTemplate: CompiledTemplate;
    protected constructor(inputTemplate: CompiledTemplate, setValueFromModelTemplate: CompiledTemplate, writeValueToModelTemplate: CompiledTemplate);
    render(props: Properties): FormInput;
}
//# sourceMappingURL=AbstractFormGroupTemplate.d.ts.map