/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.drools.drl.parser.antlr4;

import java.util.LinkedList;
import java.util.List;

import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenStream;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.lang.DroolsSentence;

public abstract class DRLExpressions extends Parser {
    public DRLExpressions(TokenStream input) {
        super(input);
    }

    public abstract void setBuildDescr( boolean build );
    public abstract boolean isBuildDescr();

    public abstract void setLeftMostExpr( String value );
    public abstract String getLeftMostExpr();

    public abstract void setHasBindings( boolean value );
    public abstract boolean hasBindings();

    /*
     * This is the original method signature in drools/drools-drl/drools-drl-parser:
     *      public abstract BaseDescr conditionalOrExpression() throws RecognitionException;
     * I changed it here because the conditionalOrExpression() method generated by ANTLR 4 from the conditionalOrExpression rule
     * returns ConditionalOrExpressionContext, so it has a return type that's different from what was originally expected here.
     * The Descr object is of course inside that context (go to this method's impl to see).
     */
    public abstract BaseDescr conditionalOrExpressionDescr() throws RecognitionException;

    public abstract ParserHelper getHelper();
    public abstract boolean hasErrors();
    public abstract List<DroolsParserException> getErrors();
    public abstract List<String> getErrorMessages();
    public abstract void enableEditorInterface();
    public abstract void disableEditorInterface();
    public abstract LinkedList<DroolsSentence> getEditorInterface();
}
