/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.eventcollector;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.EventType;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

class EventPool {
    private static final Set<Class<Event<?>>> EVENT_TYPES = new HashSet();
    private final Event<?>[] events = new Event[EVENT_TYPES.size()];

    EventPool() {
        EVENT_TYPES.forEach(this::add);
    }

    <T extends Event<T>> T get(EventType eventType) {
        return (T)this.events[eventType.ordinal()];
    }

    private void add(Class<Event<?>> eventClass) {
        Event<?> event = eventClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.events[event.type().ordinal()] = event;
    }

    static {
        Reflections reflections = new Reflections(Event.class.getPackageName(), new Scanner[0]);
        for (Class eventClass : reflections.getSubTypesOf(Event.class)) {
            if (Modifier.isAbstract(eventClass.getModifiers())) continue;
            EVENT_TYPES.add(eventClass);
        }
    }
}

