/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.collection;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.collection.IntSet;
import org.jetbrains.annotations.NotNull;

public class BitSetIntSet
extends GridSerializableCollection<Integer>
implements IntSet {
    private static final long serialVersionUID = 0L;
    private final BitSet bitSet;
    private int size;

    public BitSetIntSet() {
        this.bitSet = new BitSet();
    }

    public BitSetIntSet(int initCap) {
        this.bitSet = new BitSet(initCap);
    }

    public BitSetIntSet(int initCap, Collection<Integer> coll) {
        this.bitSet = new BitSet(initCap);
        this.addAll((Collection<? extends Integer>)coll);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException("Null values are not supported!");
        }
        return this.contains((Integer)o);
    }

    @Override
    public boolean contains(int element) {
        if (element < 0) {
            return false;
        }
        return this.bitSet.get(element);
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int idx = -1;
            private int nextIdx = -1;

            @Override
            public boolean hasNext() {
                return this.nextIdx == this.idx ? (this.nextIdx = BitSetIntSet.this.bitSet.nextSetBit(this.idx + 1)) != -1 : this.nextIdx != -1;
            }

            @Override
            public Integer next() {
                if (this.nextIdx == this.idx) {
                    this.nextIdx = BitSetIntSet.this.bitSet.nextSetBit(this.idx + 1);
                }
                if (this.nextIdx == -1) {
                    throw new NoSuchElementException();
                }
                this.idx = this.nextIdx;
                return this.idx;
            }
        };
    }

    @Override
    public boolean add(Integer integer) {
        if (integer == null) {
            throw new IllegalArgumentException("Negative or null values are not supported!");
        }
        return this.add((int)integer);
    }

    @Override
    public boolean add(int element) {
        if (element < 0) {
            throw new IllegalArgumentException("Negative or null values are not supported!");
        }
        boolean alreadySet = this.bitSet.get(element);
        if (!alreadySet) {
            this.bitSet.set(element);
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        return this.remove((Integer)o);
    }

    @Override
    public boolean remove(int element) {
        if (element < 0) {
            return false;
        }
        boolean alreadySet = this.bitSet.get(element);
        if (alreadySet) {
            this.bitSet.clear(element);
            --this.size;
        }
        return alreadySet;
    }

    @Override
    public int[] toIntArray() {
        if (this.size == 0) {
            return IgniteUtils.EMPTY_INTS;
        }
        int[] arr = new int[this.size];
        int pos = -1;
        for (int i = 0; i < this.size; ++i) {
            arr[i] = pos = this.bitSet.nextSetBit(pos + 1);
        }
        return arr;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> c) {
        boolean atLeastOneAdded = false;
        for (Integer n : c) {
            if (!this.add(n)) continue;
            atLeastOneAdded = true;
        }
        return atLeastOneAdded;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean atLeastOneRemoved = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            atLeastOneRemoved = true;
        }
        return atLeastOneRemoved;
    }

    @Override
    public void clear() {
        this.bitSet.clear();
        this.size = 0;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.bitSet);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitSetIntSet o0 = (BitSetIntSet)o;
        return this.size == o0.size && this.bitSet.equals(o0.bitSet);
    }
}

