/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.management.SystemViewCommand;
import org.apache.ignite.internal.management.SystemViewTask;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheMetricsCommandArg;
import org.apache.ignite.internal.management.cache.CacheMetricsTask;

public class CacheMetricsCommand
implements ComputeCommand<CacheMetricsCommandArg, Map<String, Boolean>> {
    @Override
    public String description() {
        return "Manages user cache metrics collection: enables, disables it or shows status";
    }

    @Override
    public Class<CacheMetricsCommandArg> argClass() {
        return CacheMetricsCommandArg.class;
    }

    @Override
    public Class<CacheMetricsTask> taskClass() {
        return CacheMetricsTask.class;
    }

    @Override
    public void printResult(CacheMetricsCommandArg arg, Map<String, Boolean> res, Consumer<String> printer) {
        List<List<?>> values = res.entrySet().stream().map(e -> Arrays.asList((String)e.getKey(), (Boolean)e.getValue() != false ? "enabled" : "disabled")).collect(Collectors.toList());
        SystemViewCommand.printTable(Arrays.asList("Cache Name", "Metrics Status"), Arrays.asList(SystemViewTask.SimpleType.STRING, SystemViewTask.SimpleType.STRING), values, printer);
    }
}

