/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util.io;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;

public interface IgniteDataInput
extends DataInput {
    public void bytes(byte[] var1, int var2);

    public void inputStream(InputStream var1) throws IOException;

    public void reset() throws IOException;

    public void cleanup() throws IOException;

    public int read() throws IOException;

    public int read(byte[] var1) throws IOException;

    public int read(byte[] var1, int var2, int var3) throws IOException;

    public long readVarInt() throws IOException;

    default public int readVarIntAsInt() throws IOException {
        long val = this.readVarInt();
        if (val < Integer.MIN_VALUE || val > Integer.MAX_VALUE) {
            throw new IOException("The value is expected to fit into int range, but it doesn't: " + val);
        }
        return (int)val;
    }

    public byte[] readByteArray(int var1) throws IOException;

    public short[] readShortArray(int var1) throws IOException;

    public int[] readIntArray(int var1) throws IOException;

    public long[] readLongArray(int var1) throws IOException;

    public float[] readFloatArray(int var1) throws IOException;

    public double[] readDoubleArray(int var1) throws IOException;

    public boolean[] readBooleanArray(int var1) throws IOException;

    public char[] readCharArray(int var1) throws IOException;

    public BigInteger readBigInteger() throws IOException;

    public BigDecimal readBigDecimal() throws IOException;

    public LocalTime readLocalTime() throws IOException;

    public LocalDate readLocalDate() throws IOException;

    public LocalDateTime readLocalDateTime() throws IOException;

    public Instant readInstant() throws IOException;

    public Duration readDuration() throws IOException;

    public Period readPeriod() throws IOException;

    public UUID readUuid() throws IOException;

    public BitSet readBitSet() throws IOException;

    public int readFewBytes(byte[] var1, int var2, int var3) throws IOException;

    public byte[] readAllBytes() throws IOException;

    public void mark(int var1);

    public int available() throws IOException;

    public <T> T materializeFromNextBytes(int var1, Materializer<? extends T> var2) throws IOException;

    default public <T, C extends Collection<T>> C readCollection(IntFunction<C> collectionFunction, ObjectReader<T> elementReader) throws IOException {
        int size = this.readVarIntAsInt();
        Collection collection = (Collection)collectionFunction.apply(size);
        for (int i = 0; i < size; ++i) {
            collection.add(elementReader.read(this));
        }
        return (C)collection;
    }

    default public <K, C, V extends C, M extends Map<K, V>> M readMap(IntFunction<M> mapFunction, ObjectReader<K> keyReader, ObjectReader<V> valueReader) throws IOException {
        int size = this.readVarIntAsInt();
        Map map = (Map)mapFunction.apply(size);
        for (int i = 0; i < size; ++i) {
            K key = keyReader.read(this);
            V value = valueReader.read(this);
            map.put(key, value);
        }
        return (M)map;
    }

    @FunctionalInterface
    public static interface ObjectReader<T> {
        public T read(IgniteDataInput var1) throws IOException;
    }

    public static interface Materializer<T> {
        public T materialize(byte[] var1, int var2, int var3);
    }
}

