/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util;

import java.util.Collections;
import java.util.function.Function;
import org.apache.ignite3.internal.util.Cursor;

public class CursorUtils {
    private static final Cursor<?> EMPTY = Cursor.fromBareIterator(Collections.emptyIterator());

    public static <T> Cursor<T> emptyCursor() {
        return EMPTY;
    }

    public static <T, U> Cursor<U> map(Cursor<T> cursor, Function<T, U> mapper) {
        return new MapCursor<T, U>(cursor, mapper);
    }

    private static class MapCursor<T, U>
    implements Cursor<U> {
        private final Cursor<T> cursor;
        private final Function<T, U> mapper;

        MapCursor(Cursor<T> cursor, Function<T, U> mapper) {
            this.cursor = cursor;
            this.mapper = mapper;
        }

        @Override
        public void close() {
            this.cursor.close();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        public U next() {
            return this.mapper.apply(this.cursor.next());
        }
    }
}

