/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cluster.management.topology;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.ClusterState;
import org.apache.ignite3.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite3.internal.cluster.management.raft.ClusterStateStorageManager;
import org.apache.ignite3.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshotSerializer;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ClusterNodeImpl;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.jetbrains.annotations.Nullable;

public class LogicalTopologyImpl
implements LogicalTopology {
    private static final IgniteLogger LOG = Loggers.forClass(LogicalTopologyImpl.class);
    public static final byte[] LOGICAL_TOPOLOGY_KEY = "logical".getBytes(StandardCharsets.UTF_8);
    private final ClusterStateStorage storage;
    private final FailureProcessor failureProcessor;
    private final ClusterStateStorageManager clusterStateStorageManager;
    private final List<LogicalTopologyEventListener> listeners = new CopyOnWriteArrayList<LogicalTopologyEventListener>();
    @Nullable
    private volatile UUID clusterId;

    public LogicalTopologyImpl(ClusterStateStorage storage, FailureProcessor failureProcessor) {
        this.storage = storage;
        this.failureProcessor = failureProcessor;
        this.clusterStateStorageManager = new ClusterStateStorageManager(storage);
    }

    @Override
    public LogicalTopologySnapshot getLogicalTopology() {
        return this.readLogicalTopology();
    }

    private LogicalTopologySnapshot readLogicalTopology() {
        byte[] bytes = this.storage.get(LOGICAL_TOPOLOGY_KEY);
        return bytes == null ? LogicalTopologySnapshot.INITIAL : VersionedSerialization.fromBytes(bytes, LogicalTopologySnapshotSerializer.INSTANCE);
    }

    @Override
    public void onNodeValidated(LogicalNode node) {
        this.notifyListeners(listener -> listener.onNodeValidated(node), "onNodeValidated");
    }

    @Override
    public void onNodeInvalidated(LogicalNode node) {
        this.notifyListeners(listener -> listener.onNodeInvalidated(node), "onNodeInvalidated");
    }

    @Override
    public void putNode(LogicalNode nodeToPut) {
        LogicalTopologySnapshot snapshot = this.readLogicalTopology();
        Map mapByName = snapshot.nodes().stream().collect(Collectors.toMap(ClusterNodeImpl::name, Function.identity()));
        Runnable fireRemovalTask = null;
        LogicalNode oldNode = (LogicalNode)mapByName.remove(nodeToPut.name());
        if (oldNode != null) {
            if (oldNode.id().equals(nodeToPut.id())) {
                return;
            }
            snapshot = new LogicalTopologySnapshot(snapshot.version() + 1L, mapByName.values(), this.requiredClusterId());
            if (LOG.isInfoEnabled()) {
                LOG.info("Node removed from logical topology [node={}, topology={}]", nodeToPut, snapshot);
            }
            LogicalTopologySnapshot snapshotAfterRemoval = snapshot;
            fireRemovalTask = () -> this.fireNodeLeft(oldNode, snapshotAfterRemoval);
        }
        mapByName.put(nodeToPut.name(), nodeToPut);
        snapshot = new LogicalTopologySnapshot(snapshot.version() + 1L, mapByName.values(), this.requiredClusterId());
        if (LOG.isInfoEnabled()) {
            LOG.info("Node added to logical topology [node={}, topology={}]", nodeToPut, snapshot);
        }
        this.saveSnapshotToStorage(snapshot);
        if (fireRemovalTask != null) {
            fireRemovalTask.run();
        }
        this.fireNodeJoined(nodeToPut, snapshot);
    }

    private UUID requiredClusterId() {
        UUID localClusterId = this.clusterId;
        if (localClusterId != null) {
            return localClusterId;
        }
        ClusterState clusterState = this.clusterStateStorageManager.getClusterState();
        assert (clusterState != null) : "clusterState cannot be null when commands are already being executed by the CMG state machine";
        this.clusterId = localClusterId = clusterState.clusterTag().clusterId();
        return localClusterId;
    }

    private void saveSnapshotToStorage(LogicalTopologySnapshot newTopology) {
        this.storage.put(LOGICAL_TOPOLOGY_KEY, VersionedSerialization.toBytes(newTopology, LogicalTopologySnapshotSerializer.INSTANCE));
    }

    @Override
    public void removeNodes(Set<LogicalNode> nodesToRemove) {
        LogicalTopologySnapshot snapshot = this.readLogicalTopology();
        Map mapById = snapshot.nodes().stream().collect(Collectors.toMap(ClusterNodeImpl::id, Function.identity()));
        List sortedNodesToRemove = nodesToRemove.stream().sorted(Comparator.comparing(ClusterNodeImpl::id)).collect(Collectors.toList());
        ArrayList<Runnable> fireTasks = new ArrayList<Runnable>();
        for (LogicalNode nodeToRemove : sortedNodesToRemove) {
            LogicalNode removedNode = (LogicalNode)mapById.remove(nodeToRemove.id());
            if (removedNode == null) continue;
            snapshot = new LogicalTopologySnapshot(snapshot.version() + 1L, mapById.values(), this.requiredClusterId());
            if (LOG.isInfoEnabled()) {
                LOG.info("Node removed from logical topology [node={}, topology={}]", removedNode, snapshot);
            }
            LogicalTopologySnapshot finalSnapshot = snapshot;
            fireTasks.add(() -> this.fireNodeLeft(nodeToRemove, finalSnapshot));
        }
        this.saveSnapshotToStorage(snapshot);
        fireTasks.forEach(Runnable::run);
    }

    @Override
    public boolean isNodeInLogicalTopology(LogicalNode needle) {
        return this.readLogicalTopology().nodes().stream().anyMatch(node -> node.id().equals(needle.id()));
    }

    private void fireNodeJoined(LogicalNode appearedNode, LogicalTopologySnapshot snapshot) {
        this.notifyListeners(listener -> listener.onNodeJoined(appearedNode, snapshot), "onNodeJoined");
    }

    private void fireNodeLeft(LogicalNode oldNode, LogicalTopologySnapshot snapshot) {
        this.notifyListeners(listener -> listener.onNodeLeft(oldNode, snapshot), "onNodeLeft");
    }

    @Override
    public void fireTopologyLeap() {
        LogicalTopologySnapshot logicalTopology = this.readLogicalTopology();
        this.notifyListeners(listener -> listener.onTopologyLeap(logicalTopology), "onTopologyLeap");
    }

    private void notifyListeners(Consumer<LogicalTopologyEventListener> action, String methodName) {
        for (LogicalTopologyEventListener listener : this.listeners) {
            try {
                action.accept(listener);
            }
            catch (Throwable e) {
                this.notifyFailureHandlerAndRethrowIfError(e, String.format("Failure while notifying %s() listener %s", methodName, listener));
            }
        }
    }

    private void notifyFailureHandlerAndRethrowIfError(Throwable e, String logMessage) {
        if (!ExceptionUtils.hasCause(e, NodeStoppingException.class)) {
            this.failureProcessor.process(new FailureContext(e, logMessage));
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
    }

    @Override
    public void addEventListener(LogicalTopologyEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(LogicalTopologyEventListener listener) {
        this.listeners.remove(listener);
    }
}

