/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.handlers;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.partition.replicator.ReplicationRaftCommandApplicator;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateMinimumActiveTxBeginTimeCommand;
import org.apache.ignite.internal.partition.replicator.network.replication.UpdateMinimumActiveTxBeginTimeReplicaRequest;
import org.apache.ignite.internal.raft.Command;

public class MinimumActiveTxTimeReplicaRequestHandler {
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private final ReplicationRaftCommandApplicator commandApplicator;
    private final ClockService clockService;

    public MinimumActiveTxTimeReplicaRequestHandler(ClockService clockService, ReplicationRaftCommandApplicator commandApplicator) {
        this.clockService = clockService;
        this.commandApplicator = commandApplicator;
    }

    public CompletableFuture<?> handle(UpdateMinimumActiveTxBeginTimeReplicaRequest request) {
        UpdateMinimumActiveTxBeginTimeCommand cmd = PARTITION_REPLICATION_MESSAGES_FACTORY.updateMinimumActiveTxBeginTimeCommand().timestamp(request.timestamp()).initiatorTime(this.clockService.now()).build();
        return this.commandApplicator.applyCommandWithExceptionHandling((Command)cmd);
    }
}

