/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.compression;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.common.ComponentLoader;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.compression.CompressorProvider;
import io.opentelemetry.exporter.internal.compression.GzipCompressor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class CompressorUtil {
    private static final Map<String, Compressor> compressorRegistry = CompressorUtil.buildCompressorRegistry(ComponentLoader.forClassLoader((ClassLoader)CompressorUtil.class.getClassLoader()));

    private CompressorUtil() {
    }

    @Nullable
    public static Compressor validateAndResolveCompressor(String compressionMethod) {
        return CompressorUtil.validateAndResolveCompressor(compressionMethod, null);
    }

    @Nullable
    public static Compressor validateAndResolveCompressor(String compressionMethod, @Nullable ComponentLoader componentLoader) {
        Map<String, Compressor> registry = componentLoader == null ? compressorRegistry : CompressorUtil.buildCompressorRegistry(componentLoader);
        Set<String> supportedEncodings = registry.keySet();
        Compressor compressor = registry.get(compressionMethod);
        Utils.checkArgument(("none".equals(compressionMethod) || compressor != null ? 1 : 0) != 0, (String)("Unsupported compressionMethod. Compression method must be \"none\" or one of: " + supportedEncodings.stream().collect(Collectors.joining(",", "[", "]"))));
        return compressor;
    }

    private static Map<String, Compressor> buildCompressorRegistry(ComponentLoader componentLoader) {
        HashMap<String, Compressor> compressors = new HashMap<String, Compressor>();
        for (CompressorProvider spi : componentLoader.load(CompressorProvider.class)) {
            Compressor compressor = spi.getInstance();
            compressors.put(compressor.getEncoding(), compressor);
        }
        compressors.put(GzipCompressor.getInstance().getEncoding(), GzipCompressor.getInstance());
        return compressors;
    }
}

