/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.ClassInfoLoader;
import com.facebook.presto.bytecode.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassInfo {
    private final ClassInfoLoader loader;
    private final ParameterizedType type;
    private final int access;
    private final ParameterizedType superClass;
    private final List<ParameterizedType> interfaces;
    private final List<MethodNode> methods;

    public ClassInfo(ClassInfoLoader loader, ClassNode classNode) {
        this(loader, ParameterizedType.typeFromPathName(classNode.name), classNode.access, classNode.superName == null ? null : ParameterizedType.typeFromPathName(classNode.superName), classNode.interfaces.stream().map(ParameterizedType::typeFromPathName).collect(Collectors.toList()), classNode.methods);
    }

    public ClassInfo(ClassInfoLoader loader, Class<?> aClass) {
        this(loader, ParameterizedType.type(aClass), aClass.getModifiers(), aClass.getSuperclass() == null ? null : ParameterizedType.type(aClass.getSuperclass()), Arrays.stream(aClass.getInterfaces()).map(ParameterizedType::type).collect(Collectors.toList()), null);
    }

    public ClassInfo(ClassInfoLoader loader, ParameterizedType type, int access, ParameterizedType superClass, Collection<ParameterizedType> interfaces, Collection<MethodNode> methods) {
        Objects.requireNonNull(loader, "loader is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(interfaces, "interfaces is null");
        this.loader = loader;
        this.type = type;
        this.access = access;
        this.superClass = superClass;
        this.interfaces = List.copyOf(interfaces);
        this.methods = methods != null ? List.copyOf(methods) : null;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.access;
    }

    public ClassInfo getSuperclass() {
        if (this.superClass == null) {
            return null;
        }
        return this.loader.loadClassInfo(this.superClass);
    }

    public List<ClassInfo> getInterfaces() {
        if (this.interfaces == null) {
            return List.of();
        }
        return this.interfaces.stream().map(this.loader::loadClassInfo).collect(Collectors.toList());
    }

    public List<MethodNode> getMethods() {
        BytecodeUtils.checkState(this.methods != null, "Methods were not loaded for type %s", this.type);
        return this.methods;
    }

    boolean isInterface() {
        return (this.getModifiers() & 0x200) > 0;
    }

    private boolean implementsInterface(ClassInfo that) {
        for (ClassInfo classInfo = this; classInfo != null; classInfo = classInfo.getSuperclass()) {
            for (ClassInfo anInterface : classInfo.getInterfaces()) {
                if (!anInterface.type.equals(that.type) && !anInterface.implementsInterface(that)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSubclassOf(ClassInfo that) {
        for (ClassInfo classInfo = this; classInfo != null; classInfo = classInfo.getSuperclass()) {
            if (classInfo.getSuperclass() == null || !classInfo.getSuperclass().type.equals(that.type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(ClassInfo that) {
        if (this == that) {
            return true;
        }
        if (that.isSubclassOf(this)) {
            return true;
        }
        if (that.implementsInterface(this)) {
            return true;
        }
        return that.isInterface() && this.getType().equals(ParameterizedType.type(Object.class));
    }

    public String toString() {
        return this.type.toString();
    }
}

