/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.util.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class CatalogTableSchemaVersions
implements MarshallableEntry {
    private final int base;
    private final TableVersion[] versions;

    public CatalogTableSchemaVersions(TableVersion ... versions) {
        this(1, versions);
    }

    CatalogTableSchemaVersions(int base, TableVersion ... versions) {
        this.base = base;
        this.versions = versions;
    }

    public int earliestVersion() {
        return this.base;
    }

    public int latestVersion() {
        return this.base + this.versions.length - 1;
    }

    TableVersion[] versions() {
        return this.versions;
    }

    @Nullable
    public TableVersion get(int version) {
        if (version < this.base || version >= this.base + this.versions.length) {
            return null;
        }
        return this.versions[version - this.base];
    }

    public CatalogTableSchemaVersions append(TableVersion tableVersion, int version) {
        assert (version == this.latestVersion() + 1);
        return new CatalogTableSchemaVersions(this.base, (TableVersion[])ArrayUtils.concat((Object[])this.versions, (Object[])new TableVersion[]{tableVersion}));
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_TABLE_SCHEMA_VERSIONS.id();
    }

    public static class TableVersion
    implements MarshallableEntry {
        private final List<CatalogTableColumnDescriptor> columns;

        public TableVersion(List<CatalogTableColumnDescriptor> columns) {
            this.columns = columns;
        }

        public List<CatalogTableColumnDescriptor> columns() {
            return Collections.unmodifiableList(this.columns);
        }

        @Override
        public int typeId() {
            return MarshallableEntryType.DESCRIPTOR_TABLE_VERSION.id();
        }
    }
}

