/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class IgniteMath {
    private static final BigDecimal UPPER_LONG_BIG_DECIMAL = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    private static final BigDecimal LOWER_LONG_BIG_DECIMAL = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);
    private static final Double UPPER_LONG_DOUBLE = 9.223372036854776E18;
    private static final Double LOWER_LONG_DOUBLE = -9.223372036854776E18;
    private static final Float UPPER_LONG_FLOAT = Float.valueOf(9.223372E18f);
    private static final Float LOWER_LONG_FLOAT = Float.valueOf(-9.223372E18f);
    private static final BigDecimal UPPER_DOUBLE_BIG_DECIMAL = new BigDecimal(String.valueOf(Double.MAX_VALUE));
    private static final BigDecimal LOWER_DOUBLE_BIG_DECIMAL = UPPER_DOUBLE_BIG_DECIMAL.negate();
    private static final BigDecimal UPPER_FLOAT_BIG_DECIMAL = new BigDecimal(String.valueOf(Float.MAX_VALUE));
    private static final BigDecimal LOWER_FLOAT_BIG_DECIMAL = UPPER_FLOAT_BIG_DECIMAL.negate();
    private static final double UPPER_FLOAT_DOUBLE = Double.parseDouble("3.4028235E38");
    private static final double LOWER_FLOAT_DOUBLE = Double.parseDouble("-3.4028235E38");
    public static final RoundingMode ROUNDING_MODE = IgniteTypeSystem.INSTANCE.roundingMode();

    public static long addExact(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.BIGINT);
        }
        return r;
    }

    public static int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.INTEGER);
        }
        return r;
    }

    public static short addExact(short x, short y) {
        int r = x + y;
        if (r != (short)r) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.SMALLINT);
        }
        return (short)r;
    }

    public static byte addExact(byte x, byte y) {
        int r = x + y;
        if (r != (byte)r) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.TINYINT);
        }
        return (byte)r;
    }

    public static long negateExact(long x) {
        long res = -x;
        if (x != 0L && x == res) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.BIGINT);
        }
        return res;
    }

    public static int negateExact(int x) {
        int res = -x;
        if (x != 0 && x == res) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.INTEGER);
        }
        return res;
    }

    public static short negateExact(short x) {
        short res = -x;
        if (res > Short.MAX_VALUE) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.SMALLINT);
        }
        return res;
    }

    public static byte negateExact(byte x) {
        byte res = -x;
        if (res > 127) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.TINYINT);
        }
        return res;
    }

    public static long subtractExact(long x, long y) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.BIGINT);
        }
        return r;
    }

    public static int subtractExact(int x, int y) {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.INTEGER);
        }
        return r;
    }

    public static short subtractExact(short x, short y) {
        int r = x - y;
        if (r != (short)r) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.SMALLINT);
        }
        return (short)r;
    }

    public static byte subtractExact(byte x, byte y) {
        int r = x - y;
        if (r != (byte)r) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.TINYINT);
        }
        return (byte)r;
    }

    public static long multiplyExact(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.BIGINT);
        }
        return r;
    }

    public static int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.INTEGER);
        }
        return (int)r;
    }

    public static short multiplyExact(short x, short y) {
        int r = x * y;
        if (r != (short)r) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.SMALLINT);
        }
        return (short)r;
    }

    public static byte multiplyExact(byte x, byte y) {
        int r = x * y;
        if (r != (byte)r) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.TINYINT);
        }
        return (byte)r;
    }

    public static long divideExact(long x, long y) {
        if (y == -1L) {
            return IgniteMath.negateExact(x);
        }
        if (y == 0L) {
            IgniteMath.throwDivisionByZero();
        }
        return x / y;
    }

    public static int divideExact(int x, int y) {
        if (y == -1) {
            return IgniteMath.negateExact(x);
        }
        if (y == 0) {
            IgniteMath.throwDivisionByZero();
        }
        return x / y;
    }

    public static short divideExact(short x, short y) {
        if (y == -1) {
            return IgniteMath.negateExact(x);
        }
        if (y == 0) {
            IgniteMath.throwDivisionByZero();
        }
        return (short)(x / y);
    }

    public static byte divideExact(byte x, byte y) {
        if (y == -1) {
            return IgniteMath.negateExact(x);
        }
        if (y == 0) {
            IgniteMath.throwDivisionByZero();
        }
        return (byte)(x / y);
    }

    @Nullable
    public static BigDecimal decimalDivide(@Nullable BigDecimal x, @Nullable BigDecimal y, int p, int s) {
        if (x == null || y == null) {
            return null;
        }
        return x.divide(y, s, ROUNDING_MODE);
    }

    private static void throwDivisionByZero() {
        throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Division by zero");
    }

    public static long convertToLongExact(Number x) {
        IgniteMath.checkNumberLongBounds(SqlTypeName.BIGINT, x);
        return x.longValue();
    }

    public static long convertToLongExact(double x) {
        if (x >= UPPER_LONG_DOUBLE || x <= LOWER_LONG_DOUBLE) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.BIGINT);
        }
        return (long)x;
    }

    public static long convertToLongExact(String x) {
        try {
            BigDecimal decimal = new BigDecimal(x.strip());
            return IgniteMath.convertToLongExact(decimal);
        }
        catch (NumberFormatException ex1) {
            throw IgniteMath.invalidInputStringForTypeException(SqlTypeName.BIGINT, x);
        }
    }

    public static int convertToIntExact(long x) {
        if ((long)((int)x) != x) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.INTEGER);
        }
        return (int)x;
    }

    public static int convertToIntExact(double x) {
        if (x >= 2.147483648E9 || x <= -2.147483649E9) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.INTEGER);
        }
        return (int)x;
    }

    public static int convertToIntExact(float x) {
        if (x >= 2.1474836E9f || x <= -2.1474836E9f) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.INTEGER);
        }
        return (int)x;
    }

    public static int convertToIntExact(Number x) {
        IgniteMath.checkNumberLongBounds(SqlTypeName.INTEGER, x);
        return IgniteMath.convertToIntExact(x.longValue());
    }

    public static int convertToIntExact(String x) {
        try {
            BigDecimal decimal = new BigDecimal(x.strip());
            return IgniteMath.convertToIntExact(decimal);
        }
        catch (NumberFormatException ex1) {
            throw IgniteMath.invalidInputStringForTypeException(SqlTypeName.INTEGER, x);
        }
    }

    public static short convertToShortExact(long x) {
        if ((long)((short)x) != x) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.SMALLINT);
        }
        return (short)x;
    }

    public static short convertToShortExact(Number x) {
        IgniteMath.checkNumberLongBounds(SqlTypeName.SMALLINT, x);
        return IgniteMath.convertToShortExact(x.longValue());
    }

    public static short convertToShortExact(double x) {
        if (x >= 32768.0 || x <= -32769.0) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.SMALLINT);
        }
        return (short)x;
    }

    public static short convertToShortExact(String x) {
        try {
            BigDecimal decimal = new BigDecimal(x.strip());
            return IgniteMath.convertToShortExact(decimal);
        }
        catch (NumberFormatException ex1) {
            throw IgniteMath.invalidInputStringForTypeException(SqlTypeName.SMALLINT, x);
        }
    }

    public static byte convertToByteExact(double x) {
        if (x >= 128.0 || x <= -129.0) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.TINYINT);
        }
        return (byte)x;
    }

    public static byte convertToByteExact(Number x) {
        IgniteMath.checkNumberLongBounds(SqlTypeName.TINYINT, x);
        return IgniteMath.convertToByteExact(x.longValue());
    }

    public static byte convertToByteExact(long x) {
        if ((long)((byte)x) != x) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.TINYINT);
        }
        return (byte)x;
    }

    public static byte convertToByteExact(String x) {
        try {
            BigDecimal decimal = new BigDecimal(x.strip());
            return IgniteMath.convertToByteExact(decimal);
        }
        catch (NumberFormatException ex1) {
            throw IgniteMath.invalidInputStringForTypeException(SqlTypeName.TINYINT, x);
        }
    }

    public static float convertToFloatExact(Number x) {
        if (x instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)x;
            if (value.compareTo(UPPER_FLOAT_BIG_DECIMAL) > 0) {
                throw IgniteMath.outOfRangeForTypeException(SqlTypeName.REAL);
            }
            if (value.compareTo(LOWER_FLOAT_BIG_DECIMAL) < 0) {
                throw IgniteMath.outOfRangeForTypeException(SqlTypeName.REAL);
            }
            return value.floatValue();
        }
        double v = x.doubleValue();
        if (!Double.isFinite(v)) {
            return x.floatValue();
        }
        if (v > UPPER_FLOAT_DOUBLE || v < LOWER_FLOAT_DOUBLE) {
            throw IgniteMath.outOfRangeForTypeException(SqlTypeName.REAL);
        }
        return x.floatValue();
    }

    public static double convertToDoubleExact(Number x) {
        if (x instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)x;
            if (value.compareTo(UPPER_DOUBLE_BIG_DECIMAL) > 0) {
                throw IgniteMath.outOfRangeForTypeException(SqlTypeName.DOUBLE);
            }
            if (value.compareTo(LOWER_DOUBLE_BIG_DECIMAL) < 0) {
                throw IgniteMath.outOfRangeForTypeException(SqlTypeName.DOUBLE);
            }
            return value.doubleValue();
        }
        return x.doubleValue();
    }

    private static void checkNumberLongBounds(SqlTypeName type, Number x) {
        if (x instanceof BigDecimal) {
            if (((BigDecimal)x).compareTo(UPPER_LONG_BIG_DECIMAL) < 0 && ((BigDecimal)x).compareTo(LOWER_LONG_BIG_DECIMAL) > 0) {
                return;
            }
        } else if (x instanceof Double) {
            if (((Double)x).compareTo(UPPER_LONG_DOUBLE) < 0 && ((Double)x).compareTo(LOWER_LONG_DOUBLE) > 0) {
                return;
            }
        } else if (x instanceof Float) {
            if (((Float)x).compareTo(UPPER_LONG_FLOAT) < 0 && ((Float)x).compareTo(LOWER_LONG_FLOAT) > 0) {
                return;
            }
        } else {
            return;
        }
        throw IgniteMath.outOfRangeForTypeException(type);
    }

    private static RuntimeException outOfRangeForTypeException(SqlTypeName type) {
        return new SqlException(ErrorGroups.Sql.RUNTIME_ERR, type.getName() + " out of range");
    }

    private static RuntimeException invalidInputStringForTypeException(SqlTypeName type, String value) {
        return new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Invalid input string for type " + type.getName() + ": \"" + value + "\"");
    }
}

