/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.row;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.sql.engine.exec.row.BaseTypeSpec;
import org.apache.ignite.internal.sql.engine.exec.row.TypeSpec;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeType;

public final class RowSchema {
    private final List<TypeSpec> fields;

    private RowSchema(List<TypeSpec> types) {
        this.fields = types;
    }

    public List<TypeSpec> fields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowSchema rowSchema = (RowSchema)o;
        return Objects.equals(this.fields, rowSchema.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return S.toString(RowSchema.class, (Object)this, (String)"fields", this.fields);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RowSchema map(RowSchema schema, int[] mapping) {
        assert (mapping != null && mapping.length > 0);
        List<TypeSpec> fields = schema.fields();
        Builder builder = RowSchema.builder();
        for (int i : mapping) {
            TypeSpec typeSpec = fields.get(i);
            builder.addField(typeSpec);
        }
        return builder.build();
    }

    public static RowSchema concat(RowSchema left, RowSchema right) {
        Builder builder = RowSchema.builder();
        for (TypeSpec typeSpec : left.fields()) {
            builder.addField(typeSpec);
        }
        for (TypeSpec typeSpec : right.fields()) {
            builder.addField(typeSpec);
        }
        return builder.build();
    }

    public static class Builder {
        private final List<TypeSpec> types = new ArrayList<TypeSpec>();

        private Builder() {
        }

        public Builder addField(TypeSpec typeSpec) {
            this.types.add(typeSpec);
            return this;
        }

        public Builder addField(NativeType nativeType) {
            return this.addField(nativeType, false);
        }

        public Builder addField(NativeType nativeType, boolean nullable) {
            this.types.add(new BaseTypeSpec(nativeType, nullable));
            return this;
        }

        public RowSchema build() {
            return new RowSchema(this.types);
        }
    }
}

