/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.graal;

import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class AutomaticFeatureUtils {
    public static void initializeAtBuildTime(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(xva$0 -> RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{xva$0}));
    }

    public static void initializeAtBuildTime(Feature.BeforeAnalysisAccess access, String ... classNames) {
        for (String className : classNames) {
            AutomaticFeatureUtils.initializeAtBuildTime(access, className);
        }
    }

    public static void initializeAtRunTime(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(xva$0 -> RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{xva$0}));
    }

    public static void initializeAtRunTime(Feature.BeforeAnalysisAccess access, String ... classNames) {
        for (String className : classNames) {
            AutomaticFeatureUtils.initializeAtRunTime(access, className);
        }
    }

    public static void initializePackagesAtBuildTime(String ... packages) {
        RuntimeClassInitialization.initializeAtBuildTime((String[])packages);
    }

    public static void initializePackagesAtRunTime(String ... packages) {
        RuntimeClassInitialization.initializeAtRunTime((String[])packages);
    }

    public static void registerConstructorsForRuntimeReflection(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerConstructorsForRuntimeReflection);
    }

    public static void registerClassForRuntimeReflection(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerForRuntimeReflection);
    }

    public static void registerClassForRuntimeReflectiveInstantiation(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerForReflectiveInstantiation);
    }

    public static void registerClassForRuntimeReflectionAndReflectiveInstantiation(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerForRuntimeReflectionAndReflectiveInstantiation);
    }

    public static void registerMethodsForRuntimeReflection(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerMethodsForRuntimeReflection);
    }

    public static void registerFieldsForRuntimeReflection(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerFieldsForRuntimeReflection);
    }

    public static void addProxyClass(Feature.BeforeAnalysisAccess access, String ... interfaces) {
        ArrayList<Class> classList = new ArrayList<Class>();
        for (String anInterface : interfaces) {
            Class clazz = access.findClassByName(anInterface);
            if (clazz == null) continue;
            classList.add(clazz);
        }
        if (classList.size() == interfaces.length) {
            ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).addProxyClass(classList.toArray(new Class[interfaces.length]));
        }
    }

    public static void addResourcePatterns(String ... patterns) {
        ResourcesRegistry resourcesRegistry;
        if (ArrayUtils.isNotEmpty(patterns) && (resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class)) != null) {
            for (String resource : patterns) {
                resourcesRegistry.addResources(resource);
            }
        }
    }

    public static void addResourceBundles(String ... bundles) {
        ResourcesRegistry resourcesRegistry;
        if (ArrayUtils.isNotEmpty(bundles) && (resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class)) != null) {
            for (String resource : bundles) {
                resourcesRegistry.addResourceBundles(resource);
            }
        }
    }

    public static void registerAllForRuntimeReflectionAndReflectiveInstantiation(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerAllForRuntimeReflectionAndReflectiveInstantiation);
    }

    public static void registerAllForRuntimeReflection(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerAllForRuntimeReflection);
    }

    public static void registerFieldsAndMethodsWithReflectiveAccess(Feature.BeforeAnalysisAccess access, String className) {
        AutomaticFeatureUtils.findClass(access, className).ifPresent(AutomaticFeatureUtils::registerFieldsAndMethodsWithReflectiveAccess);
    }

    private static void registerAllForRuntimeReflectionAndReflectiveInstantiation(Class<?> clazz) {
        AutomaticFeatureUtils.registerForRuntimeReflection(clazz);
        AutomaticFeatureUtils.registerForReflectiveInstantiation(clazz);
        AutomaticFeatureUtils.registerFieldsForRuntimeReflection(clazz);
        AutomaticFeatureUtils.registerMethodsForRuntimeReflection(clazz);
        AutomaticFeatureUtils.registerConstructorsForRuntimeReflection(clazz);
    }

    private static void registerAllForRuntimeReflection(Class<?> clazz) {
        AutomaticFeatureUtils.registerForRuntimeReflection(clazz);
        AutomaticFeatureUtils.registerFieldsForRuntimeReflection(clazz);
        AutomaticFeatureUtils.registerMethodsForRuntimeReflection(clazz);
        AutomaticFeatureUtils.registerConstructorsForRuntimeReflection(clazz);
    }

    private static void registerFieldsAndMethodsWithReflectiveAccess(Class<?> clazz) {
        AutomaticFeatureUtils.registerForRuntimeReflectionAndReflectiveInstantiation(clazz);
        AutomaticFeatureUtils.registerMethodsForRuntimeReflection(clazz);
        AutomaticFeatureUtils.registerFieldsForRuntimeReflection(clazz);
    }

    private static void registerForRuntimeReflection(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
    }

    private static void registerForReflectiveInstantiation(Class<?> clazz) {
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
    }

    private static void registerForRuntimeReflectionAndReflectiveInstantiation(Class<?> clazz) {
        RuntimeReflection.register((Class[])new Class[]{clazz});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{clazz});
    }

    private static void registerMethodsForRuntimeReflection(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            RuntimeReflection.register((Executable[])new Executable[]{method});
        }
    }

    private static void registerFieldsForRuntimeReflection(Class<?> clazz) {
        for (Field field : clazz.getFields()) {
            RuntimeReflection.register((Field[])new Field[]{field});
        }
    }

    private static void registerConstructorsForRuntimeReflection(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            RuntimeReflection.register((Executable[])new Executable[]{constructor});
        }
    }

    private static Optional<Class<?>> findClass(Feature.BeforeAnalysisAccess access, String className) {
        return Optional.ofNullable(access.findClassByName(className));
    }
}

