/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.marshaller.MarshallerColumn;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

public class ValidationUtils {
    public static void validateColumnType(MarshallerColumn col, Class<?> cls) {
        if (!ValidationUtils.isColumnCompatible(col.type(), cls)) {
            throw new ClassCastException("Column's type mismatch [column=" + col.name() + ", expectedType=" + String.valueOf((Object)col.type()) + ", actualType=" + String.valueOf(cls) + "]");
        }
    }

    private static boolean isColumnCompatible(BinaryMode colType, Class<?> cls) {
        switch (colType) {
            case P_BOOLEAN: 
            case BOOLEAN: {
                return cls == Boolean.TYPE || cls == Boolean.class;
            }
            case P_BYTE: 
            case BYTE: {
                return cls == Byte.TYPE || cls == Byte.class;
            }
            case P_SHORT: 
            case SHORT: {
                return cls == Short.TYPE || cls == Short.class;
            }
            case P_INT: 
            case INT: {
                return cls == Integer.TYPE || cls == Integer.class;
            }
            case P_LONG: 
            case LONG: {
                return cls == Long.TYPE || cls == Long.class;
            }
            case P_FLOAT: 
            case FLOAT: {
                return cls == Float.TYPE || cls == Float.class;
            }
            case P_DOUBLE: 
            case DOUBLE: {
                return cls == Double.TYPE || cls == Double.class;
            }
            case STRING: {
                return cls == String.class;
            }
            case UUID: {
                return cls == UUID.class;
            }
            case BYTE_ARR: {
                return cls == byte[].class;
            }
            case DECIMAL: {
                return cls == BigDecimal.class;
            }
            case DATE: {
                return cls == LocalDate.class;
            }
            case TIME: {
                return cls == LocalTime.class;
            }
            case DATETIME: {
                return cls == LocalDateTime.class;
            }
            case TIMESTAMP: {
                return cls == Instant.class;
            }
        }
        return false;
    }

    public static void validateNullableValue(@Nullable Object val, Class<?> valueType) {
        if (val == null && !Mapper.nativelySupported(valueType)) {
            String message = "null value cannot be used when a value is not mapped to a simple type";
            throw new NullPointerException(message);
        }
    }

    public static void validateNullableOperation(Class<?> valueType, String methodName) {
        if (!Mapper.nativelySupported(valueType)) {
            String message = IgniteStringFormatter.format((String)"{} cannot be used when a value is not mapped to a simple type", (Object[])new Object[]{methodName});
            throw new UnsupportedOperationException(message);
        }
    }

    private ValidationUtils() {
    }
}

