/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.connect;

import io.micronaut.http.HttpStatus;
import jakarta.inject.Singleton;
import javax.net.ssl.SSLException;
import org.apache.ignite.internal.cli.call.connect.AuthConfig;
import org.apache.ignite.internal.cli.call.connect.ConnectCall;
import org.apache.ignite.internal.cli.call.connect.ConnectCallInput;
import org.apache.ignite.internal.cli.call.connect.ConnectSuccessCall;
import org.apache.ignite.internal.cli.call.connect.ConnectionChecker;
import org.apache.ignite.internal.cli.call.connect.SslConfig;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.flow.Flowable;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.rest.client.invoker.ApiException;

@Singleton
public class ConnectWizardCall
implements Call<ConnectCallInput, String> {
    private final ConnectCall connectCall;
    private final ConnectSuccessCall connectSuccessCall;
    private final ConnectionChecker connectionChecker;
    private final ConfigManagerProvider configManagerProvider;

    public ConnectWizardCall(ConnectCall connectCall, ConnectionChecker connectionChecker, ConnectSuccessCall connectSuccessCall, ConfigManagerProvider configManagerProvider) {
        this.connectCall = connectCall;
        this.connectionChecker = connectionChecker;
        this.connectSuccessCall = connectSuccessCall;
        this.configManagerProvider = configManagerProvider;
    }

    @Override
    public CallOutput<String> execute(ConnectCallInput input) {
        CallOutput<String> output = this.connectCall.execute(input);
        if (output.hasError()) {
            return this.processErrorOutput(input, output);
        }
        return output;
    }

    private CallOutput<String> processErrorOutput(ConnectCallInput input, CallOutput<String> output) {
        if (output.errorCause().getCause() instanceof ApiException) {
            ApiException cause = (ApiException)output.errorCause().getCause();
            Throwable apiCause = cause.getCause();
            if (apiCause instanceof SSLException) {
                return this.configureSsl(input, output);
            }
            if (cause.getCode() == HttpStatus.UNAUTHORIZED.getCode()) {
                return this.configureAuth(input, output);
            }
        }
        return output;
    }

    private CallOutput<String> configureSsl(ConnectCallInput input, CallOutput<String> output) {
        Flowable<SslConfig> result = ConnectToClusterQuestion.askQuestionOnSslError().start(Flowable.empty());
        if (result.hasResult()) {
            try {
                SessionInfo sessionInfo = this.connectionChecker.checkConnection(input, result.value());
                this.connectionChecker.saveSettings(input, result.value());
                ConnectToClusterQuestion.askQuestionToStoreCredentials(this.configManagerProvider.get(), input.username(), input.password());
                return this.connectSuccessCall.execute(sessionInfo, input.checkClusterInit());
            }
            catch (ApiException exception) {
                Throwable apiCause = exception.getCause();
                if (apiCause instanceof SSLException) {
                    return DefaultCallOutput.failure(new IgniteCliApiException(exception, input.url()));
                }
                this.connectionChecker.saveSettings(input, result.value());
                return this.configureAuth(input, output);
            }
            catch (IgniteCliApiException cliApiException) {
                return DefaultCallOutput.failure(cliApiException);
            }
        }
        return output;
    }

    private CallOutput<String> configureAuth(ConnectCallInput input, CallOutput<String> output) {
        Flowable<AuthConfig> result = ConnectToClusterQuestion.askQuestionOnAuthError().start(Flowable.empty());
        if (result.hasResult()) {
            String username = result.value().username();
            String password = result.value().password();
            ConnectCallInput connectCallInput = ConnectCallInput.builder().url(input.url()).username(username).password(password).build();
            try {
                SessionInfo sessionInfo = this.connectionChecker.checkConnection(connectCallInput);
                this.connectionChecker.saveSettings(connectCallInput, null);
                ConnectToClusterQuestion.askQuestionToStoreCredentials(this.configManagerProvider.get(), username, password);
                return this.connectSuccessCall.execute(sessionInfo, input.checkClusterInit());
            }
            catch (ApiException e) {
                return DefaultCallOutput.failure(new IgniteCliApiException(e, input.url()));
            }
        }
        return output;
    }
}

