/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.compute.PrimaryReplicaNextWorkerSelector;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.replicator.PartitionGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.jetbrains.annotations.Nullable;

class NextColocatedWorkerSelector<K>
extends PrimaryReplicaNextWorkerSelector {
    private final NodeProperties nodeProperties;
    @Nullable
    private final K key;
    @Nullable
    private final Mapper<K> keyMapper;
    @Nullable
    private final Tuple tuple;
    private final TableViewInternal table;

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, NodeProperties nodeProperties, TableViewInternal table, K key, Mapper<K> keyMapper) {
        this(placementDriver, topologyService, clock, nodeProperties, table, key, keyMapper, null);
    }

    NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, NodeProperties nodeProperties, TableViewInternal table, Tuple tuple) {
        this(placementDriver, topologyService, clock, nodeProperties, table, null, null, tuple);
    }

    private NextColocatedWorkerSelector(PlacementDriver placementDriver, TopologyService topologyService, HybridClock clock, NodeProperties nodeProperties, TableViewInternal table, @Nullable K key, @Nullable Mapper<K> keyMapper, @Nullable Tuple tuple) {
        super(placementDriver, topologyService, clock);
        this.nodeProperties = nodeProperties;
        this.table = table;
        this.key = key;
        this.keyMapper = keyMapper;
        this.tuple = tuple;
    }

    @Override
    protected PartitionGroupId partitionGroupId() {
        if (this.key != null && this.keyMapper != null) {
            if (this.nodeProperties.colocationEnabled()) {
                return new ZonePartitionId(this.table.zoneId(), this.table.partitionId(this.key, this.keyMapper));
            }
            return new TablePartitionId(this.table.tableId(), this.table.partitionId(this.key, this.keyMapper));
        }
        if (this.nodeProperties.colocationEnabled()) {
            return new ZonePartitionId(this.table.zoneId(), this.table.partitionId(this.tuple));
        }
        return new TablePartitionId(this.table.tableId(), this.table.partitionId(this.tuple));
    }
}

