/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ArrayLengthRecordField
implements Types.RecordField {
    private final String fieldName;
    private final Class clazz;

    public ArrayLengthRecordField(String fieldName, Class clazz) {
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        this.clazz = Objects.requireNonNull(clazz, "clazz");
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public Type getType() {
        return Integer.TYPE;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public Object get(@Nullable Object o) {
        return Array.getLength(Objects.requireNonNull(o, "o"));
    }

    @Override
    public Type getDeclaringClass() {
        return this.clazz;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayLengthRecordField that = (ArrayLengthRecordField)o;
        return this.clazz.equals(that.clazz) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.clazz);
    }
}

