/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.replicator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.StartBuildingIndexEventParameters;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.lang.IgniteTriFunction;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.TimedBinaryRow;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateMinimumActiveTxBeginTimeCommand;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommand;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BuildIndexReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ChangePeersAndLearnersAsyncReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.GetEstimatedSizeRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyMultiRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultiRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultiRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSwapRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.partition.replicator.network.replication.ScanCloseReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.UpdateMinimumActiveTxBeginTimeReplicaRequest;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.ExecutorInclinedRaftCommandRunner;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.service.LeaderWithTerm;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.raft.service.RaftGroupService;
import org.apache.ignite.internal.replicator.CommandApplicationResult;
import org.apache.ignite.internal.replicator.ReplicaResult;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.exception.ReplicationException;
import org.apache.ignite.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite.internal.replicator.exception.UnsupportedReplicaRequestException;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.PrimaryReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReadOnlyDirectReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.replicator.message.SchemaVersionAwareReplicaRequest;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowUpgrader;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleComparator;
import org.apache.ignite.internal.schema.BinaryTuplePrefix;
import org.apache.ignite.internal.schema.NullBinaryRow;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.index.IndexRow;
import org.apache.ignite.internal.storage.index.IndexRowImpl;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.table.RowIdGenerator;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.table.distributed.SortedIndexLocker;
import org.apache.ignite.internal.table.distributed.StorageUpdateHandler;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.table.distributed.TableUtils;
import org.apache.ignite.internal.table.distributed.index.IndexMeta;
import org.apache.ignite.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite.internal.table.distributed.raft.UnexpectedTransactionStateException;
import org.apache.ignite.internal.table.distributed.replicator.CompatValidationResult;
import org.apache.ignite.internal.table.distributed.replicator.CursorResource;
import org.apache.ignite.internal.table.distributed.replicator.IncompatibleSchemaVersionException;
import org.apache.ignite.internal.table.distributed.replicator.IndexBuilderTxRwOperationTracker;
import org.apache.ignite.internal.table.distributed.replicator.RemoteResourceIds;
import org.apache.ignite.internal.table.distributed.replicator.ReplicatorUtils;
import org.apache.ignite.internal.table.distributed.replicator.SchemaCompatibilityValidator;
import org.apache.ignite.internal.table.distributed.replicator.StaleTransactionOperationException;
import org.apache.ignite.internal.table.distributed.replicator.TransactionStateResolver;
import org.apache.ignite.internal.table.distributed.schema.ValidationSchemasSource;
import org.apache.ignite.internal.tx.IncompatibleSchemaAbortException;
import org.apache.ignite.internal.tx.Lock;
import org.apache.ignite.internal.tx.LockKey;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.LockMode;
import org.apache.ignite.internal.tx.MismatchingTransactionOutcomeInternalException;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.TxStateMetaFinishing;
import org.apache.ignite.internal.tx.UpdateCommandResult;
import org.apache.ignite.internal.tx.impl.FullyQualifiedResourceId;
import org.apache.ignite.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite.internal.tx.message.TxCleanupRecoveryRequest;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxRecoveryMessage;
import org.apache.ignite.internal.tx.message.TxStateCommitPartitionRequest;
import org.apache.ignite.internal.tx.message.VacuumTxStateReplicaRequest;
import org.apache.ignite.internal.tx.message.VacuumTxStatesCommand;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicaRequest;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicatedInfo;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.CursorUtils;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.Lazy;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class PartitionReplicaListener
implements ReplicaListener {
    private static final Object INTERNAL_DOC_PLACEHOLDER = null;
    private static final IgniteLogger LOG = Loggers.forClass(PartitionReplicaListener.class);
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private final TablePartitionId replicationGroupId;
    private final Lazy<TableSchemaAwareIndexStorage> pkIndexStorage;
    private final Supplier<Map<Integer, TableSchemaAwareIndexStorage>> secondaryIndexStorages;
    private final MvPartitionStorage mvDataStorage;
    private final RaftCommandRunner raftCommandRunner;
    private final TxManager txManager;
    private final LockManager lockManager;
    private final StorageUpdateHandler storageUpdateHandler;
    private final RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry;
    private final TxStateStorage txStateStorage;
    private final ClockService clockService;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTime;
    private final TransactionStateResolver transactionStateResolver;
    private final Executor scanRequestExecutor;
    private final Supplier<Map<Integer, IndexLocker>> indexesLockers;
    private final ConcurrentMap<UUID, TxCleanupReadyFutureList> txCleanupReadyFutures = new ConcurrentHashMap<UUID, TxCleanupReadyFutureList>();
    private final ConcurrentHashMap<RowId, CompletableFuture<?>> rowCleanupMap = new ConcurrentHashMap();
    private final SchemaCompatibilityValidator schemaCompatValidator;
    private final ClusterNode localNode;
    private final SchemaSyncService schemaSyncService;
    private final CatalogService catalogService;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final PlacementDriver placementDriver;
    private final ClusterNodeResolver clusterNodeResolver;
    private final IndexBuilderTxRwOperationTracker txRwOperationTracker = new IndexBuilderTxRwOperationTracker();
    private final EventListener<CatalogEventParameters> indexBuildingCatalogEventListener = this::onIndexBuilding;
    private final SchemaRegistry schemaRegistry;
    private final IndexMetaStorage indexMetaStorage;
    private final LowWatermark lowWatermark;
    private static final boolean SKIP_UPDATES = IgniteSystemProperties.getBoolean((String)"IGNITE_SKIP_STORAGE_UPDATE_IN_BENCHMARK");

    public PartitionReplicaListener(MvPartitionStorage mvDataStorage, RaftCommandRunner raftCommandRunner, TxManager txManager, LockManager lockManager, Executor scanRequestExecutor, int partId, int tableId, Supplier<Map<Integer, IndexLocker>> indexesLockers, Lazy<TableSchemaAwareIndexStorage> pkIndexStorage, Supplier<Map<Integer, TableSchemaAwareIndexStorage>> secondaryIndexStorages, ClockService clockService, PendingComparableValuesTracker<HybridTimestamp, Void> safeTime, TxStateStorage txStateStorage, TransactionStateResolver transactionStateResolver, StorageUpdateHandler storageUpdateHandler, ValidationSchemasSource validationSchemasSource, ClusterNode localNode, SchemaSyncService schemaSyncService, CatalogService catalogService, PlacementDriver placementDriver, ClusterNodeResolver clusterNodeResolver, RemotelyTriggeredResourceRegistry remotelyTriggeredResourceRegistry, SchemaRegistry schemaRegistry, IndexMetaStorage indexMetaStorage, LowWatermark lowWatermark) {
        this.mvDataStorage = mvDataStorage;
        this.raftCommandRunner = raftCommandRunner;
        this.txManager = txManager;
        this.lockManager = lockManager;
        this.scanRequestExecutor = scanRequestExecutor;
        this.indexesLockers = indexesLockers;
        this.pkIndexStorage = pkIndexStorage;
        this.secondaryIndexStorages = secondaryIndexStorages;
        this.clockService = clockService;
        this.safeTime = safeTime;
        this.txStateStorage = txStateStorage;
        this.transactionStateResolver = transactionStateResolver;
        this.storageUpdateHandler = storageUpdateHandler;
        this.localNode = localNode;
        this.schemaSyncService = schemaSyncService;
        this.catalogService = catalogService;
        this.placementDriver = placementDriver;
        this.clusterNodeResolver = clusterNodeResolver;
        this.remotelyTriggeredResourceRegistry = remotelyTriggeredResourceRegistry;
        this.schemaRegistry = schemaRegistry;
        this.indexMetaStorage = indexMetaStorage;
        this.lowWatermark = lowWatermark;
        this.replicationGroupId = new TablePartitionId(tableId, partId);
        this.schemaCompatValidator = new SchemaCompatibilityValidator(validationSchemasSource, catalogService, schemaSyncService);
        this.prepareIndexBuilderTxRwOperationTracker();
    }

    private void runPersistentStorageScan() {
        int committedCount = 0;
        int abortedCount = 0;
        try (Cursor txs = this.txStateStorage.scan();){
            for (IgniteBiTuple tx : txs) {
                UUID txId = (UUID)tx.getKey();
                TxMeta txMeta = (TxMeta)tx.getValue();
                assert (!txMeta.enlistedPartitions().isEmpty());
                assert (TxState.isFinalState((TxState)txMeta.txState())) : "Unexpected state [txId=" + String.valueOf(txId) + ", state=" + String.valueOf(txMeta.txState()) + "].";
                if (txMeta.txState() == TxState.COMMITTED) {
                    ++committedCount;
                } else {
                    ++abortedCount;
                }
                this.txManager.cleanup(this.replicationGroupId, txMeta.enlistedPartitions(), txMeta.txState() == TxState.COMMITTED, txMeta.commitTimestamp(), txId).exceptionally(throwable -> {
                    LOG.warn("Failed to cleanup transaction [txId={}].", throwable, new Object[]{txId});
                    return null;
                });
            }
        }
        catch (IgniteInternalException e) {
            LOG.warn("Failed to scan transaction state storage [commitPartition={}].", (Throwable)e, new Object[]{this.replicationGroupId});
        }
        LOG.debug("Persistent storage scan finished [committed={}, aborted={}].", new Object[]{committedCount, abortedCount});
    }

    public CompletableFuture<ReplicaResult> invoke(ReplicaRequest request, UUID senderId) {
        return ((CompletableFuture)this.ensureReplicaIsPrimary(request).thenCompose(res -> this.processRequest(request, (Boolean)res.get1(), senderId, (Long)res.get2()))).thenApply(res -> {
            if (res instanceof ReplicaResult) {
                return (ReplicaResult)res;
            }
            return new ReplicaResult(res, null);
        });
    }

    public RaftCommandRunner raftClient() {
        if (this.raftCommandRunner instanceof ExecutorInclinedRaftCommandRunner) {
            return ((ExecutorInclinedRaftCommandRunner)this.raftCommandRunner).decoratedCommandRunner();
        }
        return this.raftCommandRunner;
    }

    private CompletableFuture<?> processRequest(ReplicaRequest request, @Nullable Boolean isPrimary, UUID senderId, @Nullable Long leaseStartTime) {
        ReadWriteReplicaRequest req;
        boolean hasSchemaVersion = request instanceof SchemaVersionAwareReplicaRequest;
        if (hasSchemaVersion) assert (((SchemaVersionAwareReplicaRequest)request).schemaVersion() > 0) : "No schema version passed?";
        if (request instanceof ReadWriteReplicaRequest && !(req = (ReadWriteReplicaRequest)request).full()) {
            this.txManager.updateTxMeta(req.transactionId(), old -> new TxStateMeta(TxState.PENDING, req.coordinatorId(), req.commitPartitionId().asTablePartitionId(), null));
        }
        if (request instanceof TxRecoveryMessage) {
            return this.processTxRecoveryMessage((TxRecoveryMessage)request, senderId);
        }
        if (request instanceof TxCleanupRecoveryRequest) {
            return this.processCleanupRecoveryMessage((TxCleanupRecoveryRequest)request);
        }
        if (request instanceof GetEstimatedSizeRequest) {
            return this.processGetEstimatedSizeRequest();
        }
        if (request instanceof ChangePeersAndLearnersAsyncReplicaRequest) {
            return this.processChangePeersAndLearnersReplicaRequest((ChangePeersAndLearnersAsyncReplicaRequest)request);
        }
        @Nullable HybridTimestamp opTs = this.getTxOpTimestamp(request);
        HybridTimestamp opTsIfDirectRo = request instanceof ReadOnlyDirectReplicaRequest ? opTs : null;
        @Nullable HybridTimestamp txTs = PartitionReplicaListener.getTxStartTimestamp(request);
        if (txTs == null) {
            txTs = opTsIfDirectRo;
        }
        assert (opTs == null || txTs == null || opTs.compareTo(txTs) >= 0) : "Tx started at " + String.valueOf(txTs) + ", but opTs precedes it: " + String.valueOf(opTs) + "; request " + String.valueOf(request);
        if (opTs == null) {
            assert (opTsIfDirectRo == null);
            return this.processOperationRequestWithTxOperationManagementLogic(senderId, request, isPrimary, null, leaseStartTime);
        }
        assert (txTs != null && opTs.compareTo(txTs) >= 0) : "Invalid request timestamps";
        @Nullable HybridTimestamp finalTxTs = txTs;
        Runnable validateClo = () -> {
            this.schemaCompatValidator.failIfTableDoesNotExistAt(opTs, this.tableId());
            if (hasSchemaVersion) {
                SchemaVersionAwareReplicaRequest versionAwareRequest = (SchemaVersionAwareReplicaRequest)request;
                this.schemaCompatValidator.failIfRequestSchemaDiffersFromTxTs(finalTxTs, versionAwareRequest.schemaVersion(), this.tableId());
            }
        };
        return ((CompletableFuture)this.schemaSyncService.waitForMetadataCompleteness(opTs).thenRun(validateClo)).thenCompose(ignored -> this.processOperationRequestWithTxOperationManagementLogic(senderId, request, isPrimary, opTsIfDirectRo, leaseStartTime));
    }

    private CompletableFuture<Long> processGetEstimatedSizeRequest() {
        return CompletableFuture.completedFuture(this.mvDataStorage.estimatedSize());
    }

    private CompletableFuture<Void> processCleanupRecoveryMessage(TxCleanupRecoveryRequest request) {
        this.runPersistentStorageScan();
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> processTxRecoveryMessage(TxRecoveryMessage request, UUID senderId) {
        UUID txId = request.txId();
        TxMeta txMeta = this.txStateStorage.get(txId);
        if (txMeta != null && TxState.isFinalState((TxState)txMeta.txState())) {
            return this.runCleanupOnNode(this.replicationGroupId, txId, senderId);
        }
        LOG.info("Orphan transaction has to be aborted [tx={}, meta={}].", new Object[]{txId, txMeta});
        return this.triggerTxRecovery(txId, senderId);
    }

    private CompletableFuture<Void> processChangePeersAndLearnersReplicaRequest(ChangePeersAndLearnersAsyncReplicaRequest request) {
        TablePartitionId replicaGrpId = (TablePartitionId)request.groupId().asReplicationGroupId();
        RaftGroupService raftClient = this.raftCommandRunner instanceof RaftGroupService ? (RaftGroupService)this.raftCommandRunner : (RaftGroupService)((ExecutorInclinedRaftCommandRunner)this.raftCommandRunner).decoratedCommandRunner();
        return ((CompletableFuture)raftClient.refreshAndGetLeaderWithTerm().exceptionally(throwable -> {
            if ((throwable = ExceptionUtils.unwrapCause((Throwable)throwable)) instanceof TimeoutException) {
                LOG.info("Node couldn't get the leader within timeout so the changing peers is skipped [grp={}].", new Object[]{replicaGrpId});
                return LeaderWithTerm.NO_LEADER;
            }
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to get a leader for the RAFT replication group [get=" + String.valueOf(replicaGrpId) + "].", throwable);
        })).thenCompose(leaderWithTerm -> {
            if (leaderWithTerm.isEmpty() || !this.isTokenStillValidPrimary(request.enlistmentConsistencyToken())) {
                return CompletableFutures.nullCompletedFuture();
            }
            LOG.debug("Current node={} is the leader of partition raft group={}. Initiate rebalance process for partition={}, table={}", new Object[]{leaderWithTerm.leader(), replicaGrpId, replicaGrpId.partitionId(), replicaGrpId.tableId()});
            return raftClient.changePeersAndLearnersAsync(PartitionReplicaListener.peersConfigurationFromMessage(request), leaderWithTerm.term());
        });
    }

    private boolean isTokenStillValidPrimary(long suspectedEnlistmentConsistencyToken) {
        HybridTimestamp currentTime = this.clockService.current();
        ReplicaMeta meta = this.placementDriver.getCurrentPrimaryReplica((ReplicationGroupId)this.replicationGroupId, currentTime);
        return meta != null && this.isLocalPeer(meta.getLeaseholderId()) && this.clockService.before(currentTime, meta.getExpirationTime()) && suspectedEnlistmentConsistencyToken == meta.getStartTime().longValue();
    }

    private static PeersAndLearners peersConfigurationFromMessage(ChangePeersAndLearnersAsyncReplicaRequest request) {
        Assignments pendingAssignments = Assignments.fromBytes((byte[])request.pendingAssignments());
        return PeersAndLearners.fromAssignments((Collection)pendingAssignments.nodes());
    }

    private CompletableFuture<Void> runCleanupOnNode(TablePartitionId commitPartitionId, UUID txId, UUID nodeId) {
        String nodeConsistentId = this.clusterNodeResolver.getConsistentIdById(nodeId);
        return nodeConsistentId == null ? CompletableFutures.nullCompletedFuture() : this.txManager.cleanup(commitPartitionId, nodeConsistentId, txId);
    }

    private CompletableFuture<Void> triggerTxRecovery(UUID txId, UUID senderId) {
        return this.txManager.finish(HybridTimestampTracker.emptyTracker(), this.replicationGroupId, false, Map.of(this.replicationGroupId, new IgniteBiTuple((Object)this.clusterNodeResolver.getById(senderId), (Object)0L)), txId).whenComplete((v, ex) -> this.runCleanupOnNode(this.replicationGroupId, txId, senderId));
    }

    @Nullable
    private HybridTimestamp getTxOpTimestamp(ReplicaRequest request) {
        Object opStartTs = request instanceof ReadWriteReplicaRequest ? this.clockService.current() : (request instanceof ReadOnlyReplicaRequest ? ((ReadOnlyReplicaRequest)request).readTimestamp() : (request instanceof ReadOnlyDirectReplicaRequest ? this.clockService.current() : null));
        return opStartTs;
    }

    @Nullable
    private static HybridTimestamp getTxStartTimestamp(ReplicaRequest request) {
        Object txStartTimestamp = request instanceof ReadWriteReplicaRequest ? ReplicatorUtils.beginRwTxTs((ReadWriteReplicaRequest)request) : (request instanceof ReadOnlyReplicaRequest ? ((ReadOnlyReplicaRequest)request).readTimestamp() : null);
        return txStartTimestamp;
    }

    private CompletableFuture<?> processOperationRequest(UUID senderId, ReplicaRequest request, @Nullable Boolean isPrimary, @Nullable HybridTimestamp opStartTsIfDirectRo, @Nullable Long lst) {
        if (request instanceof ReadWriteSingleRowReplicaRequest) {
            ReadWriteSingleRowReplicaRequest req = (ReadWriteSingleRowReplicaRequest)request;
            OperationId opId = new OperationId(senderId, req.timestamp().longValue());
            return this.appendTxCommand(req.transactionId(), opId, req.requestType(), req.full(), () -> this.processSingleEntryAction(req, lst));
        }
        if (request instanceof ReadWriteSingleRowPkReplicaRequest) {
            ReadWriteSingleRowPkReplicaRequest req = (ReadWriteSingleRowPkReplicaRequest)request;
            OperationId opId = new OperationId(senderId, req.timestamp().longValue());
            return this.appendTxCommand(req.transactionId(), opId, req.requestType(), req.full(), () -> this.processSingleEntryAction(req, lst));
        }
        if (request instanceof ReadWriteMultiRowReplicaRequest) {
            ReadWriteMultiRowReplicaRequest req = (ReadWriteMultiRowReplicaRequest)request;
            OperationId opId = new OperationId(senderId, req.timestamp().longValue());
            return this.appendTxCommand(req.transactionId(), opId, req.requestType(), req.full(), () -> this.processMultiEntryAction(req, lst));
        }
        if (request instanceof ReadWriteMultiRowPkReplicaRequest) {
            ReadWriteMultiRowPkReplicaRequest req = (ReadWriteMultiRowPkReplicaRequest)request;
            OperationId opId = new OperationId(senderId, req.timestamp().longValue());
            return this.appendTxCommand(req.transactionId(), opId, req.requestType(), req.full(), () -> this.processMultiEntryAction(req, lst));
        }
        if (request instanceof ReadWriteSwapRowReplicaRequest) {
            ReadWriteSwapRowReplicaRequest req = (ReadWriteSwapRowReplicaRequest)request;
            OperationId opId = new OperationId(senderId, req.timestamp().longValue());
            return this.appendTxCommand(req.transactionId(), opId, req.requestType(), req.full(), () -> this.processTwoEntriesAction(req, lst));
        }
        if (request instanceof ReadWriteScanRetrieveBatchReplicaRequest) {
            ReadWriteScanRetrieveBatchReplicaRequest req = (ReadWriteScanRetrieveBatchReplicaRequest)request;
            this.txManager.updateTxMeta(req.transactionId(), old -> new TxStateMeta(TxState.PENDING, req.coordinatorId(), req.commitPartitionId().asTablePartitionId(), null));
            OperationId opId = new OperationId(senderId, req.timestamp().longValue());
            return ((CompletableFuture)this.appendTxCommand(req.transactionId(), opId, RequestType.RW_SCAN, false, () -> this.processScanRetrieveBatchAction(req)).thenCompose(rows -> {
                if (PartitionReplicaListener.allElementsAreNull(rows)) {
                    return CompletableFuture.completedFuture(rows);
                }
                return this.validateRwReadAgainstSchemaAfterTakingLocks(req.transactionId()).thenApply(ignored -> rows);
            })).whenComplete((rows, err) -> {
                if (req.full() && (err != null || rows.size() < req.batchSize())) {
                    this.releaseTxLocks(req.transactionId());
                }
            });
        }
        if (request instanceof ScanCloseReplicaRequest) {
            this.processScanCloseAction((ScanCloseReplicaRequest)request);
            return CompletableFutures.nullCompletedFuture();
        }
        if (request instanceof TxFinishReplicaRequest) {
            return this.processTxFinishAction((TxFinishReplicaRequest)request);
        }
        if (request instanceof WriteIntentSwitchReplicaRequest) {
            return this.processWriteIntentSwitchAction((WriteIntentSwitchReplicaRequest)request);
        }
        if (request instanceof ReadOnlySingleRowPkReplicaRequest) {
            return this.processReadOnlySingleEntryAction((ReadOnlySingleRowPkReplicaRequest)request, isPrimary);
        }
        if (request instanceof ReadOnlyMultiRowPkReplicaRequest) {
            return this.processReadOnlyMultiEntryAction((ReadOnlyMultiRowPkReplicaRequest)request, isPrimary);
        }
        if (request instanceof ReadOnlyScanRetrieveBatchReplicaRequest) {
            return this.processReadOnlyScanRetrieveBatchAction((ReadOnlyScanRetrieveBatchReplicaRequest)request, isPrimary);
        }
        if (request instanceof ReplicaSafeTimeSyncRequest) {
            return this.processReplicaSafeTimeSyncRequest(isPrimary);
        }
        if (request instanceof BuildIndexReplicaRequest) {
            return this.processBuildIndexReplicaRequest((BuildIndexReplicaRequest)request);
        }
        if (request instanceof ReadOnlyDirectSingleRowReplicaRequest) {
            return this.processReadOnlyDirectSingleEntryAction((ReadOnlyDirectSingleRowReplicaRequest)request, opStartTsIfDirectRo);
        }
        if (request instanceof ReadOnlyDirectMultiRowReplicaRequest) {
            return this.processReadOnlyDirectMultiEntryAction((ReadOnlyDirectMultiRowReplicaRequest)request, opStartTsIfDirectRo);
        }
        if (request instanceof TxStateCommitPartitionRequest) {
            return this.processTxStateCommitPartitionRequest((TxStateCommitPartitionRequest)request);
        }
        if (request instanceof VacuumTxStateReplicaRequest) {
            return this.processVacuumTxStateReplicaRequest((VacuumTxStateReplicaRequest)request);
        }
        if (request instanceof UpdateMinimumActiveTxBeginTimeReplicaRequest) {
            return this.processMinimumActiveTxTimeReplicaRequest((UpdateMinimumActiveTxBeginTimeReplicaRequest)request);
        }
        throw new UnsupportedReplicaRequestException(request.getClass());
    }

    private CompletableFuture<TransactionMeta> processTxStateCommitPartitionRequest(TxStateCommitPartitionRequest request) {
        return this.placementDriver.getPrimaryReplica((ReplicationGroupId)this.replicationGroupId, this.clockService.now()).thenCompose(replicaMeta -> {
            if (replicaMeta == null || replicaMeta.getLeaseholder() == null) {
                return CompletableFuture.failedFuture((Throwable)new PrimaryReplicaMissException(this.localNode.name(), null, this.localNode.id(), null, null, null, null));
            }
            if (!this.isLocalPeer(replicaMeta.getLeaseholderId())) {
                return CompletableFuture.failedFuture((Throwable)new PrimaryReplicaMissException(this.localNode.name(), replicaMeta.getLeaseholder(), this.localNode.id(), replicaMeta.getLeaseholderId(), null, null, null));
            }
            UUID txId = request.txId();
            TxStateMeta txMeta = this.txManager.stateMeta(txId);
            if (txMeta != null && txMeta.txState() == TxState.FINISHING) {
                assert (txMeta instanceof TxStateMetaFinishing) : txMeta;
                return ((TxStateMetaFinishing)txMeta).txFinishFuture();
            }
            if (txMeta == null || !TxState.isFinalState((TxState)txMeta.txState())) {
                return this.triggerTxRecoveryOnTxStateResolutionIfNeeded(txId, txMeta);
            }
            return CompletableFuture.completedFuture(txMeta);
        });
    }

    private CompletableFuture<TransactionMeta> triggerTxRecoveryOnTxStateResolutionIfNeeded(UUID txId, @Nullable TxStateMeta txStateMeta) {
        assert (txStateMeta == null || txStateMeta.txState() == TxState.PENDING || txStateMeta.txState() == TxState.ABANDONED) : "Unexpected transaction state: " + String.valueOf(txStateMeta);
        TxMeta txMeta = this.txStateStorage.get(txId);
        if (txMeta == null) {
            if (txStateMeta == null || txStateMeta.txState() == TxState.ABANDONED || txStateMeta.txCoordinatorId() == null || this.clusterNodeResolver.getById(txStateMeta.txCoordinatorId()) == null) {
                return ((CompletableFuture)this.triggerTxRecovery(txId, this.localNode.id()).handle((v, ex) -> CompletableFuture.completedFuture(this.txManager.stateMeta(txId)))).thenCompose(v -> v);
            }
            assert (txStateMeta != null && txStateMeta.txState() == TxState.PENDING) : "Unexpected transaction state: " + String.valueOf(txStateMeta);
            return CompletableFuture.completedFuture(txStateMeta);
        }
        assert (TxState.isFinalState((TxState)txMeta.txState())) : "Unexpected transaction state: " + String.valueOf(txMeta);
        return CompletableFuture.completedFuture(txMeta);
    }

    private CompletableFuture<List<BinaryRow>> processReadOnlyScanRetrieveBatchAction(ReadOnlyScanRetrieveBatchReplicaRequest request, Boolean isPrimary) {
        CompletableFuture safeReadFuture;
        Objects.requireNonNull(isPrimary);
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        HybridTimestamp readTimestamp = request.readTimestamp();
        FullyQualifiedResourceId cursorId = RemoteResourceIds.cursorId(txId, request.scanId());
        CompletableFuture completableFuture = safeReadFuture = this.isPrimaryInTimestamp(isPrimary, readTimestamp) ? CompletableFutures.nullCompletedFuture() : this.safeTime.waitFor((Comparable)readTimestamp);
        if (request.indexToUse() != null) {
            TableSchemaAwareIndexStorage indexStorage = this.secondaryIndexStorages.get().get(request.indexToUse());
            if (indexStorage == null) {
                throw new AssertionError((Object)("Index not found: uuid=" + request.indexToUse()));
            }
            if (request.exactKey() != null) {
                assert (request.lowerBoundPrefix() == null && request.upperBoundPrefix() == null) : "Index lookup doesn't allow bounds.";
                return safeReadFuture.thenCompose(unused -> this.lookupIndex(request, indexStorage));
            }
            assert (indexStorage.storage() instanceof SortedIndexStorage);
            return safeReadFuture.thenCompose(unused -> this.scanSortedIndex(request, indexStorage));
        }
        return safeReadFuture.thenCompose(unused -> this.retrieveExactEntriesUntilCursorEmpty(txId, request.coordinatorId(), readTimestamp, cursorId, batchCount));
    }

    private CompletableFuture<List<BinaryRow>> retrieveExactEntriesUntilCursorEmpty(UUID txId, UUID txCoordinatorId, @Nullable HybridTimestamp readTimestamp, FullyQualifiedResourceId cursorId, int count) {
        PartitionTimestampCursor cursor = (PartitionTimestampCursor)((CursorResource)this.remotelyTriggeredResourceRegistry.register(cursorId, txCoordinatorId, () -> new CursorResource((Cursor<?>)this.mvDataStorage.scan(readTimestamp == null ? HybridTimestamp.MAX_VALUE : readTimestamp)))).cursor();
        ArrayList<CompletableFuture<TimedBinaryRow>> resolutionFuts = new ArrayList<CompletableFuture<TimedBinaryRow>>(count);
        while (resolutionFuts.size() < count && cursor.hasNext()) {
            BinaryRow committedRow;
            ReadResult readResult = (ReadResult)cursor.next();
            HybridTimestamp newestCommitTimestamp = readResult.newestCommitTimestamp();
            TimedBinaryRow candidate = newestCommitTimestamp == null || !readResult.isWriteIntent() ? null : ((committedRow = cursor.committed(newestCommitTimestamp)) == null ? null : new TimedBinaryRow(committedRow, newestCommitTimestamp));
            resolutionFuts.add(this.resolveReadResult(readResult, txId, readTimestamp, () -> candidate));
        }
        return CompletableFuture.allOf(resolutionFuts.toArray(new CompletableFuture[0])).thenCompose(unused -> {
            ArrayList<BinaryRow> rows = new ArrayList<BinaryRow>(count);
            for (CompletableFuture resolutionFut : resolutionFuts) {
                TimedBinaryRow resolvedReadResult = (TimedBinaryRow)resolutionFut.join();
                if (resolvedReadResult == null || resolvedReadResult.binaryRow() == null) continue;
                rows.add(resolvedReadResult.binaryRow());
            }
            if (rows.size() < count && cursor.hasNext()) {
                return this.retrieveExactEntriesUntilCursorEmpty(txId, txCoordinatorId, readTimestamp, cursorId, count - rows.size()).thenApply(binaryRows -> {
                    rows.addAll((Collection<BinaryRow>)binaryRows);
                    return rows;
                });
            }
            return CompletableFuture.completedFuture(this.closeCursorIfBatchNotFull(rows, count, cursorId));
        });
    }

    private CompletableFuture<List<BinaryRow>> retrieveExactEntriesUntilCursorEmpty(UUID txId, UUID txCoordinatorId, FullyQualifiedResourceId cursorId, int count) {
        return this.retrieveExactEntriesUntilCursorEmpty(txId, txCoordinatorId, null, cursorId, count).thenCompose(rows -> {
            if (CollectionUtils.nullOrEmpty((Collection)rows)) {
                return CompletableFutures.emptyListCompletedFuture();
            }
            CompletableFuture[] futs = new CompletableFuture[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                BinaryRow row = (BinaryRow)rows.get(i);
                futs[i] = this.validateBackwardCompatibility(row, txId).thenApply(unused -> row);
            }
            return CompletableFuture.allOf(futs).thenApply(unused -> rows);
        });
    }

    private CompletableFuture<Void> validateBackwardCompatibility(BinaryRow row, UUID txId) {
        return this.schemaCompatValidator.validateBackwards(row.schemaVersion(), this.tableId(), txId).thenAccept(validationResult -> {
            if (!validationResult.isSuccessful()) {
                throw new IncompatibleSchemaVersionException(String.format("Operation failed because it tried to access a row with newer schema version than transaction's [table=%s, txSchemaVersion=%d, rowSchemaVersion=%d]", validationResult.failedTableName(), validationResult.fromSchemaVersion(), validationResult.toSchemaVersion()));
            }
        });
    }

    private CompletableFuture<BinaryRow> processReadOnlySingleEntryAction(ReadOnlySingleRowPkReplicaRequest request, Boolean isPrimary) {
        BinaryTuple primaryKey = this.resolvePk(request.primaryKey());
        HybridTimestamp readTimestamp = request.readTimestamp();
        if (request.requestType() != RequestType.RO_GET) {
            throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
        }
        CompletableFuture safeReadFuture = this.isPrimaryInTimestamp(isPrimary, readTimestamp) ? CompletableFutures.nullCompletedFuture() : this.safeTime.waitFor((Comparable)request.readTimestamp());
        return safeReadFuture.thenCompose(unused -> this.resolveRowByPkForReadOnly(primaryKey, readTimestamp));
    }

    private boolean isPrimaryInTimestamp(Boolean isPrimary, HybridTimestamp timestamp) {
        return isPrimary != false && this.clockService.now().compareTo(timestamp) > 0;
    }

    private CompletableFuture<List<BinaryRow>> processReadOnlyMultiEntryAction(ReadOnlyMultiRowPkReplicaRequest request, Boolean isPrimary) {
        List<BinaryTuple> primaryKeys = this.resolvePks(request.primaryKeys());
        HybridTimestamp readTimestamp = request.readTimestamp();
        if (request.requestType() != RequestType.RO_GET_ALL) {
            throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
        }
        CompletableFuture safeReadFuture = this.isPrimaryInTimestamp(isPrimary, readTimestamp) ? CompletableFutures.nullCompletedFuture() : this.safeTime.waitFor((Comparable)request.readTimestamp());
        return safeReadFuture.thenCompose(unused -> {
            CompletableFuture[] resolutionFuts = new CompletableFuture[primaryKeys.size()];
            for (int i = 0; i < primaryKeys.size(); ++i) {
                resolutionFuts[i] = this.resolveRowByPkForReadOnly((BinaryTuple)primaryKeys.get(i), readTimestamp);
            }
            return CompletableFutures.allOfToList((CompletableFuture[])resolutionFuts);
        });
    }

    private CompletableFuture<Void> processReplicaSafeTimeSyncRequest(Boolean isPrimary) {
        Objects.requireNonNull(isPrimary);
        if (!isPrimary.booleanValue()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.applyCmdWithExceptionHandling((Command)REPLICA_MESSAGES_FACTORY.safeTimeSyncCommand().initiatorTime(this.clockService.now()).build()).thenApply(res -> null);
    }

    private void processScanCloseAction(ScanCloseReplicaRequest request) {
        UUID txId = request.transactionId();
        FullyQualifiedResourceId cursorId = RemoteResourceIds.cursorId(txId, request.scanId());
        try {
            this.remotelyTriggeredResourceRegistry.close(cursorId);
        }
        catch (IgniteException e) {
            throw this.wrapCursorCloseException(e);
        }
    }

    private <T> ArrayList<T> closeCursorIfBatchNotFull(ArrayList<T> rows, int batchSize, FullyQualifiedResourceId cursorId) {
        if (rows.size() < batchSize) {
            try {
                this.remotelyTriggeredResourceRegistry.close(cursorId);
            }
            catch (IgniteException e) {
                throw this.wrapCursorCloseException(e);
            }
        }
        return rows;
    }

    private ReplicationException wrapCursorCloseException(IgniteException e) {
        return new ReplicationException(ErrorGroups.Replicator.CURSOR_CLOSE_ERR, IgniteStringFormatter.format((String)"Close cursor exception [replicaGrpId={}, msg={}]", (Object[])new Object[]{this.replicationGroupId, e.getMessage()}), (Throwable)e);
    }

    private CompletableFuture<List<BinaryRow>> processScanRetrieveBatchAction(ReadWriteScanRetrieveBatchReplicaRequest request) {
        if (request.indexToUse() != null) {
            TableSchemaAwareIndexStorage indexStorage = this.secondaryIndexStorages.get().get(request.indexToUse());
            if (indexStorage == null) {
                throw new AssertionError((Object)("Index not found: uuid=" + request.indexToUse()));
            }
            if (request.exactKey() != null) {
                assert (request.lowerBoundPrefix() == null && request.upperBoundPrefix() == null) : "Index lookup doesn't allow bounds.";
                return this.lookupIndex(request, indexStorage.storage(), request.coordinatorId());
            }
            assert (indexStorage.storage() instanceof SortedIndexStorage);
            return this.scanSortedIndex(request, indexStorage);
        }
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        FullyQualifiedResourceId cursorId = RemoteResourceIds.cursorId(txId, request.scanId());
        return this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId), LockMode.S).thenCompose(tblLock -> this.retrieveExactEntriesUntilCursorEmpty(txId, request.coordinatorId(), cursorId, batchCount));
    }

    private CompletableFuture<List<BinaryRow>> lookupIndex(ReadOnlyScanRetrieveBatchReplicaRequest request, TableSchemaAwareIndexStorage schemaAwareIndexStorage) {
        IndexStorage indexStorage = schemaAwareIndexStorage.storage();
        FullyQualifiedResourceId cursorId = RemoteResourceIds.cursorId(request.transactionId(), request.scanId());
        BinaryTuple key = request.exactKey().asBinaryTuple();
        Object cursor = ((CursorResource)this.remotelyTriggeredResourceRegistry.register(cursorId, request.coordinatorId(), () -> new CursorResource(indexStorage.get(key)))).cursor();
        Cursor indexRowCursor = CursorUtils.map(cursor, rowId -> new IndexRowImpl(key, rowId));
        int batchCount = request.batchSize();
        ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
        HybridTimestamp readTimestamp = request.readTimestamp();
        return this.continueReadOnlyIndexScan(schemaAwareIndexStorage, (Cursor<IndexRow>)indexRowCursor, readTimestamp, batchCount, result, this.tableVersionByTs(readTimestamp)).thenApply(ignore -> this.closeCursorIfBatchNotFull(result, batchCount, cursorId));
    }

    private CompletableFuture<List<BinaryRow>> lookupIndex(ReadWriteScanRetrieveBatchReplicaRequest request, IndexStorage indexStorage, UUID txCoordinatorId) {
        UUID txId = request.transactionId();
        int batchCount = request.batchSize();
        FullyQualifiedResourceId cursorId = RemoteResourceIds.cursorId(txId, request.scanId());
        Integer indexId = request.indexToUse();
        BinaryTuple exactKey = request.exactKey().asBinaryTuple();
        return this.lockManager.acquire(txId, new LockKey((Object)indexId, (Object)exactKey.byteBuffer()), LockMode.S).thenCompose(indRowLock -> {
            Object cursor = ((CursorResource)this.remotelyTriggeredResourceRegistry.register(cursorId, txCoordinatorId, () -> new CursorResource(indexStorage.get(exactKey)))).cursor();
            ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
            return this.continueIndexLookup(txId, (Cursor<RowId>)cursor, batchCount, (List<BinaryRow>)result).thenApply(ignore -> this.closeCursorIfBatchNotFull(result, batchCount, cursorId));
        });
    }

    private CompletableFuture<List<BinaryRow>> scanSortedIndex(ReadWriteScanRetrieveBatchReplicaRequest request, TableSchemaAwareIndexStorage schemaAwareIndexStorage) {
        SortedIndexStorage indexStorage = (SortedIndexStorage)schemaAwareIndexStorage.storage();
        UUID txId = request.transactionId();
        FullyQualifiedResourceId cursorId = RemoteResourceIds.cursorId(txId, request.scanId());
        Integer indexId = request.indexToUse();
        BinaryTupleMessage lowerBoundMessage = request.lowerBoundPrefix();
        BinaryTupleMessage upperBoundMessage = request.upperBoundPrefix();
        BinaryTuplePrefix lowerBound = lowerBoundMessage == null ? null : lowerBoundMessage.asBinaryTuplePrefix();
        BinaryTuplePrefix upperBound = upperBoundMessage == null ? null : upperBoundMessage.asBinaryTuplePrefix();
        int flags = request.flags();
        BinaryTupleComparator comparator = StorageUtils.binaryTupleComparator((List)indexStorage.indexDescriptor().columns());
        Predicate<IndexRow> isUpperBoundAchieved = indexRow -> {
            if (indexRow == null) {
                return true;
            }
            if (upperBound == null) {
                return false;
            }
            ByteBuffer buffer = upperBound.byteBuffer();
            if ((flags & 2) != 0) {
                byte boundFlags = buffer.get(0);
                buffer.put(0, (byte)(boundFlags | 0x10));
            }
            return comparator.compare(indexRow.indexColumns().byteBuffer(), buffer) >= 0;
        };
        Object cursor = ((CursorResource)this.remotelyTriggeredResourceRegistry.register(cursorId, request.coordinatorId(), () -> new CursorResource((Cursor<?>)indexStorage.scan(lowerBound, null, flags)))).cursor();
        SortedIndexLocker indexLocker = (SortedIndexLocker)this.indexesLockers.get().get(indexId);
        int batchCount = request.batchSize();
        ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
        return this.continueIndexScan(txId, schemaAwareIndexStorage, indexLocker, (Cursor<IndexRow>)cursor, batchCount, (List<BinaryRow>)result, isUpperBoundAchieved, this.tableVersionByTs(TransactionIds.beginTimestamp((UUID)txId))).thenApply(ignore -> this.closeCursorIfBatchNotFull(result, batchCount, cursorId));
    }

    private CompletableFuture<List<BinaryRow>> scanSortedIndex(ReadOnlyScanRetrieveBatchReplicaRequest request, TableSchemaAwareIndexStorage schemaAwareIndexStorage) {
        SortedIndexStorage indexStorage = (SortedIndexStorage)schemaAwareIndexStorage.storage();
        FullyQualifiedResourceId cursorId = RemoteResourceIds.cursorId(request.transactionId(), request.scanId());
        BinaryTupleMessage lowerBoundMessage = request.lowerBoundPrefix();
        BinaryTupleMessage upperBoundMessage = request.upperBoundPrefix();
        BinaryTuplePrefix lowerBound = lowerBoundMessage == null ? null : lowerBoundMessage.asBinaryTuplePrefix();
        BinaryTuplePrefix upperBound = upperBoundMessage == null ? null : upperBoundMessage.asBinaryTuplePrefix();
        int flags = request.flags();
        Object cursor = ((CursorResource)this.remotelyTriggeredResourceRegistry.register(cursorId, request.coordinatorId(), () -> new CursorResource(indexStorage.readOnlyScan(lowerBound, upperBound, flags)))).cursor();
        int batchCount = request.batchSize();
        ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(batchCount);
        HybridTimestamp readTimestamp = request.readTimestamp();
        return this.continueReadOnlyIndexScan(schemaAwareIndexStorage, (Cursor<IndexRow>)cursor, readTimestamp, batchCount, (List<BinaryRow>)result, this.tableVersionByTs(readTimestamp)).thenApply(ignore -> this.closeCursorIfBatchNotFull(result, batchCount, cursorId));
    }

    private CompletableFuture<Void> continueReadOnlyIndexScan(TableSchemaAwareIndexStorage schemaAwareIndexStorage, Cursor<IndexRow> cursor, HybridTimestamp readTimestamp, int batchSize, List<BinaryRow> result, int tableVersion) {
        if (result.size() >= batchSize || !cursor.hasNext()) {
            return CompletableFutures.nullCompletedFuture();
        }
        IndexRow indexRow = (IndexRow)cursor.next();
        RowId rowId = indexRow.rowId();
        return this.resolvePlainReadResult(rowId, null, readTimestamp).thenComposeAsync(resolvedReadResult -> {
            BinaryRow binaryRow = this.upgrade(PartitionReplicaListener.binaryRow(resolvedReadResult), tableVersion);
            if (binaryRow != null && PartitionReplicaListener.indexRowMatches(indexRow, binaryRow, schemaAwareIndexStorage)) {
                result.add(binaryRow);
            }
            return this.continueReadOnlyIndexScan(schemaAwareIndexStorage, cursor, readTimestamp, batchSize, result, tableVersion);
        }, this.scanRequestExecutor);
    }

    private CompletableFuture<Void> continueIndexScan(UUID txId, TableSchemaAwareIndexStorage schemaAwareIndexStorage, SortedIndexLocker indexLocker, Cursor<IndexRow> indexCursor, int batchSize, List<BinaryRow> result, Predicate<IndexRow> isUpperBoundAchieved, int tableVersion) {
        if (result.size() == batchSize) {
            return CompletableFutures.nullCompletedFuture();
        }
        return indexLocker.locksForScan(txId, indexCursor).thenCompose(currentRow -> {
            if (isUpperBoundAchieved.test((IndexRow)currentRow)) {
                return CompletableFutures.nullCompletedFuture();
            }
            RowId rowId = currentRow.rowId();
            return this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.S).thenComposeAsync(rowLock -> this.resolvePlainReadResult(rowId, txId).thenCompose(resolvedReadResult -> {
                BinaryRow binaryRow = this.upgrade(PartitionReplicaListener.binaryRow(resolvedReadResult), tableVersion);
                if (binaryRow != null && PartitionReplicaListener.indexRowMatches(currentRow, binaryRow, schemaAwareIndexStorage)) {
                    result.add(resolvedReadResult.binaryRow());
                }
                return this.continueIndexScan(txId, schemaAwareIndexStorage, indexLocker, indexCursor, batchSize, result, isUpperBoundAchieved, tableVersion);
            }), this.scanRequestExecutor);
        });
    }

    private static boolean indexRowMatches(IndexRow indexRow, BinaryRow binaryRow, TableSchemaAwareIndexStorage schemaAwareIndexStorage) {
        BinaryTuple actualIndexRow = schemaAwareIndexStorage.indexRowResolver().extractColumns(binaryRow);
        return indexRow.indexColumns().byteBuffer().equals(actualIndexRow.byteBuffer());
    }

    private CompletableFuture<Void> continueIndexLookup(UUID txId, Cursor<RowId> indexCursor, int batchSize, List<BinaryRow> result) {
        if (result.size() >= batchSize || !indexCursor.hasNext()) {
            return CompletableFutures.nullCompletedFuture();
        }
        RowId rowId = (RowId)indexCursor.next();
        return this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.S).thenComposeAsync(rowLock -> this.resolvePlainReadResult(rowId, txId).thenCompose(resolvedReadResult -> {
            if (resolvedReadResult != null && resolvedReadResult.binaryRow() != null) {
                result.add(resolvedReadResult.binaryRow());
            }
            return this.continueIndexLookup(txId, indexCursor, batchSize, result);
        }), this.scanRequestExecutor);
    }

    private CompletableFuture<@Nullable TimedBinaryRow> resolvePlainReadResult(RowId rowId, @Nullable UUID txId, @Nullable HybridTimestamp timestamp) {
        ReadResult readResult = this.mvDataStorage.read(rowId, timestamp == null ? HybridTimestamp.MAX_VALUE : timestamp);
        return this.resolveReadResult(readResult, txId, timestamp, () -> {
            if (readResult.newestCommitTimestamp() == null) {
                return null;
            }
            ReadResult committedReadResult = this.mvDataStorage.read(rowId, readResult.newestCommitTimestamp());
            assert (!committedReadResult.isWriteIntent()) : "The result is not committed [rowId=" + String.valueOf(rowId) + ", timestamp=" + String.valueOf(readResult.newestCommitTimestamp()) + "]";
            return new TimedBinaryRow(committedReadResult.binaryRow(), committedReadResult.commitTimestamp());
        });
    }

    private CompletableFuture<@Nullable TimedBinaryRow> resolvePlainReadResult(RowId rowId, UUID txId) {
        return this.resolvePlainReadResult(rowId, txId, null).thenCompose(row -> {
            if (row == null || row.binaryRow() == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return this.validateBackwardCompatibility(row.binaryRow(), txId).thenApply(unused -> row);
        });
    }

    private CompletableFuture<TransactionResult> processTxFinishAction(TxFinishReplicaRequest request) {
        Map<TablePartitionId, String> enlistedGroups = PartitionReplicaListener.asTablePartitionIdStringMap(request.groups());
        UUID txId = request.txId();
        if (request.commit()) {
            HybridTimestamp commitTimestamp = request.commitTimestamp();
            return this.schemaCompatValidator.validateCommit(txId, enlistedGroups.keySet(), commitTimestamp).thenCompose(validationResult -> this.finishAndCleanup(enlistedGroups, validationResult.isSuccessful(), (HybridTimestamp)(validationResult.isSuccessful() ? commitTimestamp : null), txId).thenApply(txResult -> {
                PartitionReplicaListener.throwIfSchemaValidationOnCommitFailed(validationResult, txResult);
                return txResult;
            }));
        }
        return this.finishAndCleanup(enlistedGroups, false, null, txId);
    }

    private static void throwIfSchemaValidationOnCommitFailed(CompatValidationResult validationResult, TransactionResult txResult) {
        if (!validationResult.isSuccessful()) {
            if (validationResult.isTableDropped()) {
                throw new IncompatibleSchemaAbortException(IgniteStringFormatter.format((String)"Commit failed because a table was already dropped [table={}]", (Object[])new Object[]{validationResult.failedTableName()}), txResult);
            }
            throw new IncompatibleSchemaAbortException(IgniteStringFormatter.format((String)"Commit failed because schema is not forward-compatible [fromSchemaVersion={}, toSchemaVersion={}, table={}, details={}]", (Object[])new Object[]{validationResult.fromSchemaVersion(), validationResult.toSchemaVersion(), validationResult.failedTableName(), validationResult.details()}), txResult);
        }
    }

    private CompletableFuture<TransactionResult> finishAndCleanup(Map<TablePartitionId, String> enlistedPartitions, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId) {
        boolean transactionAlreadyFinished;
        TxMeta txMeta = this.txStateStorage.get(txId);
        boolean bl = transactionAlreadyFinished = txMeta != null && TxState.isFinalState((TxState)txMeta.txState());
        if (transactionAlreadyFinished) {
            if (commit != (txMeta.txState() == TxState.COMMITTED)) {
                LOG.error("Failed to finish a transaction that is already finished [txId={}, expectedState={}, actualState={}].", new Object[]{txId, commit ? TxState.COMMITTED : TxState.ABORTED, txMeta.txState()});
                throw new MismatchingTransactionOutcomeInternalException("Failed to change the outcome of a finished transaction [txId=" + String.valueOf(txId) + ", txState=" + String.valueOf(txMeta.txState()) + "].", new TransactionResult(txMeta.txState(), txMeta.commitTimestamp()));
            }
            return CompletableFuture.completedFuture(new TransactionResult(txMeta.txState(), txMeta.commitTimestamp()));
        }
        return this.finishTransaction(enlistedPartitions.keySet(), txId, commit, commitTimestamp).thenCompose(txResult -> this.txManager.cleanup(this.replicationGroupId, enlistedPartitions, commit, commitTimestamp, txId).thenApply(v -> txResult));
    }

    private CompletableFuture<TransactionResult> finishTransaction(Collection<TablePartitionId> partitionIds, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        assert (!commit || commitTimestamp != null) : "Cannot commit without the timestamp.";
        HybridTimestamp tsForCatalogVersion = commit ? commitTimestamp : this.clockService.now();
        return ((CompletableFuture)this.reliableCatalogVersionFor(tsForCatalogVersion).thenCompose(catalogVersion -> this.applyFinishCommand(txId, commit, commitTimestamp, (int)catalogVersion, PartitionReplicaListener.toPartitionIdMessage(partitionIds)))).handle((txOutcome, ex) -> {
            if (ex != null) {
                if (ex instanceof UnexpectedTransactionStateException) {
                    UnexpectedTransactionStateException utse = (UnexpectedTransactionStateException)((Object)((Object)ex));
                    TransactionResult result = utse.transactionResult();
                    this.markFinished(txId, result.transactionState(), result.commitTimestamp());
                    throw new MismatchingTransactionOutcomeInternalException(utse.getMessage(), utse.transactionResult());
                }
                throw new TransactionException(commit ? ErrorGroups.Transactions.TX_COMMIT_ERR : ErrorGroups.Transactions.TX_ROLLBACK_ERR, ex);
            }
            TransactionResult result = (TransactionResult)txOutcome;
            this.markFinished(txId, result.transactionState(), result.commitTimestamp());
            return result;
        });
    }

    private static List<TablePartitionIdMessage> toPartitionIdMessage(Collection<TablePartitionId> partitionIds) {
        ArrayList<TablePartitionIdMessage> list = new ArrayList<TablePartitionIdMessage>(partitionIds.size());
        for (TablePartitionId partitionId : partitionIds) {
            list.add(PartitionReplicaListener.tablePartitionId(partitionId));
        }
        return list;
    }

    private CompletableFuture<Object> applyFinishCommand(UUID transactionId, boolean commit, HybridTimestamp commitTimestamp, int catalogVersion, List<TablePartitionIdMessage> partitionIds) {
        HybridTimestamp now = this.clockService.now();
        FinishTxCommandBuilder finishTxCmdBldr = PARTITION_REPLICATION_MESSAGES_FACTORY.finishTxCommand().txId(transactionId).commit(commit).initiatorTime(now).requiredCatalogVersion(catalogVersion).partitionIds(partitionIds);
        if (commit) {
            finishTxCmdBldr.commitTimestamp(commitTimestamp);
        }
        return this.applyCmdWithExceptionHandling((Command)finishTxCmdBldr.build()).thenApply(ResultWrapper::getResult);
    }

    private CompletableFuture<ReplicaResult> processWriteIntentSwitchAction(WriteIntentSwitchReplicaRequest request) {
        this.markFinished(request.txId(), request.commit() ? TxState.COMMITTED : TxState.ABORTED, request.commitTimestamp());
        return this.awaitCleanupReadyFutures(request.txId(), request.commit()).thenCompose(res -> {
            if (res.hadUpdateFutures() || res.forceCleanup()) {
                HybridTimestamp commandTimestamp = this.clockService.now();
                return this.reliableCatalogVersionFor(commandTimestamp).thenApply(catalogVersion -> {
                    CompletableFuture<WriteIntentSwitchReplicatedInfo> commandReplicatedFuture = this.applyWriteIntentSwitchCommand(request.txId(), request.commit(), request.commitTimestamp(), (int)catalogVersion);
                    return new ReplicaResult(null, new CommandApplicationResult(null, commandReplicatedFuture));
                });
            }
            return CompletableFuture.completedFuture(new ReplicaResult((Object)new WriteIntentSwitchReplicatedInfo(request.txId(), this.replicationGroupId), null));
        });
    }

    private CompletableFuture<FuturesCleanupResult> awaitCleanupReadyFutures(UUID txId, boolean commit) {
        ArrayList txUpdateFutures = new ArrayList();
        ArrayList txReadFutures = new ArrayList();
        AtomicBoolean forceCleanup = new AtomicBoolean(true);
        this.txCleanupReadyFutures.compute(txId, (id, txOps) -> {
            if (txOps == null) {
                return null;
            }
            forceCleanup.set(txOps.futures.isEmpty());
            txOps.futures.forEach((opType, futures) -> {
                if (opType.isRwRead()) {
                    txReadFutures.addAll(futures.values());
                } else {
                    txUpdateFutures.addAll(futures.values());
                }
            });
            txOps.futures.clear();
            return null;
        });
        return ((CompletableFuture)PartitionReplicaListener.allOfFuturesExceptionIgnored(txUpdateFutures, commit, txId).thenCompose(v -> PartitionReplicaListener.allOfFuturesExceptionIgnored(txReadFutures, commit, txId))).thenApply(v -> new FuturesCleanupResult(!txReadFutures.isEmpty(), !txUpdateFutures.isEmpty(), forceCleanup.get()));
    }

    private CompletableFuture<WriteIntentSwitchReplicatedInfo> applyWriteIntentSwitchCommand(UUID transactionId, boolean commit, HybridTimestamp commitTimestamp, int catalogVersion) {
        WriteIntentSwitchCommand wiSwitchCmd = PARTITION_REPLICATION_MESSAGES_FACTORY.writeIntentSwitchCommand().txId(transactionId).commit(commit).commitTimestamp(commitTimestamp).initiatorTime(this.clockService.now()).requiredCatalogVersion(catalogVersion).build();
        this.storageUpdateHandler.switchWriteIntents(transactionId, commit, commitTimestamp, this.indexIdsAtRwTxBeginTs(transactionId));
        return ((CompletableFuture)this.applyCmdWithExceptionHandling((Command)wiSwitchCmd).exceptionally(e -> {
            LOG.warn("Failed to complete transaction cleanup command [txId=" + String.valueOf(transactionId) + "]", e);
            ExceptionUtils.sneakyThrow((Throwable)e);
            return null;
        })).thenApply(res -> new WriteIntentSwitchReplicatedInfo(transactionId, this.replicationGroupId));
    }

    private static CompletableFuture<Void> allOfFuturesExceptionIgnored(List<CompletableFuture<?>> txFutures, boolean commit, UUID txId) {
        return CompletableFuture.allOf(txFutures.toArray(new CompletableFuture[0])).exceptionally(e -> {
            assert (!commit) : "Transaction is committing, but an operation has completed with exception [txId=" + String.valueOf(txId) + ", err=" + e.getMessage() + "]";
            return null;
        });
    }

    private void releaseTxLocks(UUID txId) {
        this.lockManager.releaseAll(txId);
    }

    private <T> CompletableFuture<T> resolveRowByPk(BinaryTuple pk, UUID txId, IgniteTriFunction<@Nullable RowId, @Nullable BinaryRow, @Nullable HybridTimestamp, CompletableFuture<T>> action) {
        IndexLocker pkLocker = this.indexesLockers.get().get(((TableSchemaAwareIndexStorage)this.pkIndexStorage.get()).id());
        assert (pkLocker != null);
        CompletableFuture<Void> lockFut = pkLocker.locksForLookupByKey(txId, pk);
        Supplier<CompletableFuture> sup = () -> {
            boolean cursorClosureSetUp = false;
            Cursor<RowId> cursor = null;
            try {
                Cursor<RowId> finalCursor = cursor = this.getFromPkIndex(pk);
                CompletionStage resolvingFuture = this.continueResolvingByPk(cursor, txId, action).whenComplete((res, ex) -> finalCursor.close());
                cursorClosureSetUp = true;
                CompletionStage completionStage = resolvingFuture;
                return completionStage;
            }
            finally {
                if (!cursorClosureSetUp && cursor != null) {
                    cursor.close();
                }
            }
        };
        if (CompletableFutures.isCompletedSuccessfully(lockFut)) {
            return sup.get();
        }
        return lockFut.thenCompose(ignored -> (CompletionStage)sup.get());
    }

    private <T> CompletableFuture<T> continueResolvingByPk(Cursor<RowId> cursor, UUID txId, IgniteTriFunction<@Nullable RowId, @Nullable BinaryRow, @Nullable HybridTimestamp, CompletableFuture<T>> action) {
        if (!cursor.hasNext()) {
            return (CompletableFuture)action.apply(null, null, null);
        }
        RowId rowId = (RowId)cursor.next();
        return this.resolvePlainReadResult(rowId, txId).thenCompose(row -> {
            if (row != null && row.binaryRow() != null) {
                return (CompletionStage)action.apply((Object)rowId, (Object)row.binaryRow(), (Object)row.commitTimestamp());
            }
            return this.continueResolvingByPk(cursor, txId, action);
        });
    }

    private <T> CompletableFuture<T> appendTxCommand(UUID txId, OperationId opId, RequestType cmdType, boolean full, Supplier<CompletableFuture<T>> op) {
        if (full) {
            return op.get().whenComplete((v, th) -> this.releaseTxLocks(txId));
        }
        CompletableFuture cleanupReadyFut = new CompletableFuture();
        this.txCleanupReadyFutures.compute(txId, (id, txOps) -> {
            TxStateMeta txStateMeta = this.txManager.stateMeta(txId);
            if (txStateMeta == null || TxState.isFinalState((TxState)txStateMeta.txState()) || txStateMeta.txState() == TxState.FINISHING) {
                cleanupReadyFut.completeExceptionally(new Exception());
                return txOps;
            }
            if (txOps == null) {
                txOps = new TxCleanupReadyFutureList();
            }
            txOps.futures.computeIfAbsent(cmdType, type -> new HashMap()).put(opId, cleanupReadyFut);
            return txOps;
        });
        if (cleanupReadyFut.isCompletedExceptionally()) {
            TxStateMeta txStateMeta = this.txManager.stateMeta(txId);
            TxState txState = txStateMeta == null ? null : txStateMeta.txState();
            return CompletableFuture.failedFuture((Throwable)new TransactionException(ErrorGroups.Transactions.TX_ALREADY_FINISHED_ERR, "Transaction is already finished txId=[" + String.valueOf(txId) + ", txState=" + String.valueOf(txState) + "]."));
        }
        CompletableFuture<T> fut = op.get();
        fut.whenComplete((v, th) -> {
            if (th != null) {
                cleanupReadyFut.completeExceptionally((Throwable)th);
            } else if (v instanceof ReplicaResult) {
                ReplicaResult res = (ReplicaResult)v;
                if (res.applyResult().replicationFuture() != null) {
                    res.applyResult().replicationFuture().whenComplete((v0, th0) -> {
                        if (th0 != null) {
                            cleanupReadyFut.completeExceptionally((Throwable)th0);
                        } else {
                            cleanupReadyFut.complete(null);
                        }
                    });
                } else {
                    cleanupReadyFut.complete(null);
                }
            } else {
                cleanupReadyFut.complete(null);
            }
        });
        return fut;
    }

    private CompletableFuture<@Nullable BinaryRow> resolveRowByPkForReadOnly(BinaryTuple pk, HybridTimestamp ts) {
        try (Cursor<RowId> cursor = this.getFromPkIndex(pk);){
            CompletableFuture<BinaryRow> completableFuture;
            ArrayList<ReadResult> writeIntents = new ArrayList<ReadResult>();
            ArrayList<ReadResult> regularEntries = new ArrayList<ReadResult>();
            for (RowId rowId : cursor) {
                ReadResult readResult = this.mvDataStorage.read(rowId, ts);
                if (readResult.isWriteIntent()) {
                    writeIntents.add(readResult);
                    continue;
                }
                if (readResult.isEmpty()) continue;
                regularEntries.add(readResult);
            }
            if (writeIntents.isEmpty() && regularEntries.isEmpty()) {
                completableFuture = CompletableFutures.nullCompletedFuture();
                return completableFuture;
            }
            if (writeIntents.isEmpty()) {
                completableFuture = CompletableFuture.completedFuture(((ReadResult)regularEntries.get(0)).binaryRow());
                return completableFuture;
            }
            ReadResult writeIntent = (ReadResult)writeIntents.get(0);
            PartitionReplicaListener.checkWriteIntentsBelongSameTx(writeIntents);
            CompletableFuture completableFuture2 = IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.resolveWriteIntentReadability(writeIntent, ts).thenApply(writeIntentReadable -> (BinaryRow)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (writeIntentReadable.booleanValue()) {
                    return IgniteUtils.findAny((Collection)writeIntents, wi -> !wi.isEmpty()).map(ReadResult::binaryRow).orElse(null);
                }
                for (ReadResult wi2 : writeIntents) {
                    HybridTimestamp newestCommitTimestamp = wi2.newestCommitTimestamp();
                    if (newestCommitTimestamp == null) continue;
                    ReadResult committedReadResult = this.mvDataStorage.read(wi2.rowId(), newestCommitTimestamp);
                    assert (!committedReadResult.isWriteIntent()) : "The result is not committed [rowId=" + String.valueOf(wi2.rowId()) + ", timestamp=" + String.valueOf(newestCommitTimestamp) + "]";
                    return committedReadResult.binaryRow();
                }
                return IgniteUtils.findFirst((List)regularEntries).map(ReadResult::binaryRow).orElse(null);
            })));
            return completableFuture2;
        }
    }

    private static void checkWriteIntentsBelongSameTx(Collection<ReadResult> writeIntents) {
        ReadResult writeIntent = (ReadResult)IgniteUtils.findAny(writeIntents).orElseThrow();
        for (ReadResult wi : writeIntents) {
            assert (Objects.equals(wi.transactionId(), writeIntent.transactionId())) : "Unexpected write intent, tx1=" + String.valueOf(writeIntent.transactionId()) + ", tx2=" + String.valueOf(wi.transactionId());
            assert (Objects.equals(wi.commitTableId(), writeIntent.commitTableId())) : "Unexpected write intent, commitTableId1=" + writeIntent.commitTableId() + ", commitTableId2=" + wi.commitTableId();
            assert (wi.commitPartitionId() == writeIntent.commitPartitionId()) : "Unexpected write intent, commitPartitionId1=" + writeIntent.commitPartitionId() + ", commitPartitionId2=" + wi.commitPartitionId();
        }
    }

    private static boolean equalValues(BinaryRow row, BinaryRow row2) {
        return row.tupleSlice().compareTo(row2.tupleSlice()) == 0;
    }

    private CompletableFuture<List<BinaryRow>> processReadOnlyDirectMultiEntryAction(ReadOnlyDirectMultiRowReplicaRequest request, HybridTimestamp opStartTimestamp) {
        List<BinaryTuple> primaryKeys = this.resolvePks(request.primaryKeys());
        HybridTimestamp readTimestamp = opStartTimestamp;
        if (request.requestType() != RequestType.RO_GET_ALL) {
            throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
        }
        CompletableFuture[] resolutionFuts = new CompletableFuture[primaryKeys.size()];
        for (int i = 0; i < primaryKeys.size(); ++i) {
            resolutionFuts[i] = this.resolveRowByPkForReadOnly(primaryKeys.get(i), readTimestamp);
        }
        return CompletableFutures.allOfToList((CompletableFuture[])resolutionFuts);
    }

    private CompletableFuture<ReplicaResult> processMultiEntryAction(ReadWriteMultiRowReplicaRequest request, Long leaseStartTime) {
        UUID txId = request.transactionId();
        TablePartitionId commitPartitionId = request.commitPartitionId().asTablePartitionId();
        List searchRows = request.binaryRows();
        assert (commitPartitionId != null) : "Commit partition is null [type=" + String.valueOf(request.requestType()) + "]";
        switch (request.requestType()) {
            case RW_DELETE_EXACT_ALL: {
                CompletableFuture[] deleteExactLockFuts = new CompletableFuture[searchRows.size()];
                ConcurrentHashMap lastCommitTimes = new ConcurrentHashMap();
                for (int i = 0; i < searchRows.size(); ++i) {
                    BinaryRow searchRow = (BinaryRow)searchRows.get(i);
                    deleteExactLockFuts[i] = this.resolveRowByPk(this.extractPk(searchRow), txId, (rowId, row, lastCommitTime) -> {
                        if (rowId == null) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        if (lastCommitTime != null) {
                            lastCommitTimes.put(rowId.uuid(), lastCommitTime);
                        }
                        return this.takeLocksForDeleteExact(searchRow, (RowId)rowId, (BinaryRow)row, txId);
                    });
                }
                return CompletableFuture.allOf(deleteExactLockFuts).thenCompose(ignore -> {
                    HashMap<UUID, TimedBinaryRowMessage> rowIdsToDelete = new HashMap<UUID, TimedBinaryRowMessage>();
                    ArrayList<NullBinaryRow> result = new ArrayList<NullBinaryRow>();
                    ArrayList<RowId> rows = new ArrayList<RowId>();
                    for (int i = 0; i < searchRows.size(); ++i) {
                        RowId lockedRowId = (RowId)deleteExactLockFuts[i].join();
                        if (lockedRowId != null) {
                            rowIdsToDelete.put(lockedRowId.uuid(), PARTITION_REPLICATION_MESSAGES_FACTORY.timedBinaryRowMessage().timestamp((HybridTimestamp)lastCommitTimes.get(lockedRowId.uuid())).build());
                            result.add(new NullBinaryRow());
                            rows.add(lockedRowId);
                            continue;
                        }
                        result.add(null);
                    }
                    if (rowIdsToDelete.isEmpty()) {
                        return CompletableFuture.completedFuture(new ReplicaResult(result, null));
                    }
                    return ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup(rows, catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateAllCommand(request, (Map<UUID, TimedBinaryRowMessage>)rowIdsToDelete, (int)catalogVersion, leaseStartTime))).thenApply(res -> new ReplicaResult((Object)result, res));
                });
            }
            case RW_INSERT_ALL: {
                ArrayList<BinaryTuple> pks = new ArrayList<BinaryTuple>(searchRows.size());
                CompletableFuture[] pkReadLockFuts = new CompletableFuture[searchRows.size()];
                for (int i = 0; i < searchRows.size(); ++i) {
                    BinaryTuple pk = this.extractPk((BinaryRow)searchRows.get(i));
                    pks.add(pk);
                    pkReadLockFuts[i] = this.resolveRowByPk(pk, txId, (rowId, row, lastCommitTime) -> CompletableFuture.completedFuture(rowId));
                }
                return CompletableFuture.allOf(pkReadLockFuts).thenCompose(ignore -> {
                    ArrayList<NullBinaryRow> result = new ArrayList<NullBinaryRow>();
                    HashMap<RowId, BinaryRow> rowsToInsert = new HashMap<RowId, BinaryRow>();
                    HashSet<ByteBuffer> uniqueKeys = new HashSet<ByteBuffer>();
                    for (int i = 0; i < searchRows.size(); ++i) {
                        BinaryRow row = (BinaryRow)searchRows.get(i);
                        RowId lockedRow = (RowId)pkReadLockFuts[i].join();
                        if (lockedRow == null && uniqueKeys.add(((BinaryTuple)pks.get(i)).byteBuffer())) {
                            rowsToInsert.put(new RowId(this.partId(), RowIdGenerator.next()), row);
                            result.add(new NullBinaryRow());
                            continue;
                        }
                        result.add(null);
                    }
                    if (rowsToInsert.isEmpty()) {
                        return CompletableFuture.completedFuture(new ReplicaResult(result, null));
                    }
                    CompletableFuture[] insertLockFuts = new CompletableFuture[rowsToInsert.size()];
                    int idx = 0;
                    for (Map.Entry entry : rowsToInsert.entrySet()) {
                        insertLockFuts[idx++] = this.takeLocksForInsert((BinaryRow)entry.getValue(), (RowId)entry.getKey(), txId);
                    }
                    Map<UUID, TimedBinaryRowMessage> convertedMap = rowsToInsert.entrySet().stream().collect(Collectors.toMap(e -> ((RowId)e.getKey()).uuid(), e -> PARTITION_REPLICATION_MESSAGES_FACTORY.timedBinaryRowMessage().binaryRowMessage(PartitionReplicaListener.binaryRowMessage((BinaryRow)e.getValue())).build()));
                    return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(insertLockFuts).thenCompose(ignored -> this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()))).thenCompose(catalogVersion -> this.applyUpdateAllCommand(request, convertedMap, (int)catalogVersion, leaseStartTime))).thenApply(res -> {
                        for (CompletableFuture insertLockFut : insertLockFuts) {
                            ((Collection)((IgniteBiTuple)insertLockFut.join()).get2()).forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        }
                        return new ReplicaResult((Object)result, res);
                    });
                });
            }
            case RW_UPSERT_ALL: {
                boolean isDelete;
                BinaryRow searchRow;
                int i;
                CompletableFuture[] rowIdFuts = new CompletableFuture[searchRows.size()];
                BinaryTuple[] pks = new BinaryTuple[searchRows.size()];
                ConcurrentHashMap lastCommitTimes = new ConcurrentHashMap();
                BitSet deleted = request.deleted();
                HashMap<ByteBuffer, Integer> prevRowIdx = new HashMap<ByteBuffer, Integer>();
                for (i = 0; i < searchRows.size(); ++i) {
                    BinaryTuple pk;
                    searchRow = (BinaryRow)searchRows.get(i);
                    isDelete = deleted != null && deleted.get(i);
                    pks[i] = pk = isDelete ? this.resolvePk(searchRow.tupleSlice()) : this.extractPk(searchRow);
                    Integer prevRowIdx0 = prevRowIdx.put(pk.byteBuffer(), i);
                    if (prevRowIdx0 == null) continue;
                    rowIdFuts[prevRowIdx0.intValue()] = CompletableFutures.nullCompletedFuture();
                }
                for (i = 0; i < searchRows.size(); ++i) {
                    if (rowIdFuts[i] != null) continue;
                    searchRow = (BinaryRow)searchRows.get(i);
                    isDelete = deleted != null && deleted.get(i);
                    rowIdFuts[i] = this.resolveRowByPk(pks[i], txId, (rowId, row, lastCommitTime) -> {
                        if (isDelete && rowId == null) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        if (lastCommitTime != null) {
                            lastCommitTimes.put(rowId.uuid(), lastCommitTime);
                        }
                        if (isDelete) {
                            assert (row != null);
                            return this.takeLocksForDelete((BinaryRow)row, (RowId)rowId, txId).thenApply(id -> new IgniteBiTuple(id, null));
                        }
                        boolean insert = rowId == null;
                        RowId rowId0 = insert ? new RowId(this.partId(), RowIdGenerator.next()) : rowId;
                        return insert ? this.takeLocksForInsert(searchRow, rowId0, txId) : this.takeLocksForUpdate(searchRow, rowId0, txId);
                    });
                }
                return CompletableFuture.allOf(rowIdFuts).thenCompose(ignore -> {
                    HashMap rowsToUpdate = IgniteUtils.newHashMap((int)searchRows.size());
                    ArrayList<RowId> rows = new ArrayList<RowId>();
                    for (int i = 0; i < searchRows.size(); ++i) {
                        IgniteBiTuple locks = (IgniteBiTuple)rowIdFuts[i].join();
                        if (locks == null) continue;
                        RowId lockedRow = (RowId)locks.get1();
                        TimedBinaryRowMessageBuilder timedBinaryRowMessageBuilder = PARTITION_REPLICATION_MESSAGES_FACTORY.timedBinaryRowMessage().timestamp((HybridTimestamp)lastCommitTimes.get(lockedRow.uuid()));
                        if (deleted == null || !deleted.get(i)) {
                            timedBinaryRowMessageBuilder.binaryRowMessage(PartitionReplicaListener.binaryRowMessage((BinaryRow)searchRows.get(i)));
                        }
                        rowsToUpdate.put(lockedRow.uuid(), timedBinaryRowMessageBuilder.build());
                        rows.add(lockedRow);
                    }
                    if (rowsToUpdate.isEmpty()) {
                        return CompletableFuture.completedFuture(new ReplicaResult(null, null));
                    }
                    return ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup(rows, catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateAllCommand(request, rowsToUpdate, (int)catalogVersion, leaseStartTime))).thenApply(res -> {
                        for (CompletableFuture rowIdFut : rowIdFuts) {
                            Collection locks;
                            IgniteBiTuple futRes = (IgniteBiTuple)rowIdFut.join();
                            Collection collection = locks = futRes == null ? null : (Collection)futRes.get2();
                            if (locks == null) continue;
                            locks.forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        }
                        return new ReplicaResult(null, res);
                    });
                });
            }
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown multi request [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private CompletableFuture<?> processMultiEntryAction(ReadWriteMultiRowPkReplicaRequest request, Long leaseStartTime) {
        UUID txId = request.transactionId();
        TablePartitionId committedPartitionId = request.commitPartitionId().asTablePartitionId();
        List<BinaryTuple> primaryKeys = this.resolvePks(request.primaryKeys());
        assert (committedPartitionId != null || request.requestType() == RequestType.RW_GET_ALL) : "Commit partition is null [type=" + String.valueOf(request.requestType()) + "]";
        switch (request.requestType()) {
            case RW_GET_ALL: {
                CompletableFuture[] rowFuts = new CompletableFuture[primaryKeys.size()];
                for (int i = 0; i < primaryKeys.size(); ++i) {
                    rowFuts[i] = this.resolveRowByPk(primaryKeys.get(i), txId, (rowId, row, lastCommitTime) -> {
                        if (rowId == null) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        return this.takeLocksForGet((RowId)rowId, txId).thenApply(ignored -> row);
                    });
                }
                return CompletableFuture.allOf(rowFuts).thenCompose(ignored -> {
                    ArrayList<BinaryRow> result = new ArrayList<BinaryRow>(primaryKeys.size());
                    for (CompletableFuture rowFut : rowFuts) {
                        result.add((BinaryRow)rowFut.join());
                    }
                    if (PartitionReplicaListener.allElementsAreNull(result)) {
                        return CompletableFuture.completedFuture(result);
                    }
                    return this.validateRwReadAgainstSchemaAfterTakingLocks(txId).thenApply(unused -> new ReplicaResult((Object)result, null));
                });
            }
            case RW_DELETE_ALL: {
                CompletableFuture[] rowIdLockFuts = new CompletableFuture[primaryKeys.size()];
                ConcurrentHashMap lastCommitTimes = new ConcurrentHashMap();
                for (int i = 0; i < primaryKeys.size(); ++i) {
                    rowIdLockFuts[i] = this.resolveRowByPk(primaryKeys.get(i), txId, (rowId, row, lastCommitTime) -> {
                        if (rowId == null) {
                            return CompletableFutures.nullCompletedFuture();
                        }
                        if (lastCommitTime != null) {
                            lastCommitTimes.put(rowId.uuid(), lastCommitTime);
                        }
                        return this.takeLocksForDelete((BinaryRow)row, (RowId)rowId, txId);
                    });
                }
                return CompletableFuture.allOf(rowIdLockFuts).thenCompose(ignore -> {
                    HashMap<UUID, TimedBinaryRowMessage> rowIdsToDelete = new HashMap<UUID, TimedBinaryRowMessage>();
                    ArrayList<NullBinaryRow> result = new ArrayList<NullBinaryRow>();
                    ArrayList<RowId> rows = new ArrayList<RowId>();
                    for (CompletableFuture lockFut : rowIdLockFuts) {
                        RowId lockedRowId = (RowId)lockFut.join();
                        if (lockedRowId != null) {
                            rowIdsToDelete.put(lockedRowId.uuid(), PARTITION_REPLICATION_MESSAGES_FACTORY.timedBinaryRowMessage().timestamp((HybridTimestamp)lastCommitTimes.get(lockedRowId.uuid())).build());
                            rows.add(lockedRowId);
                            result.add(new NullBinaryRow());
                            continue;
                        }
                        result.add(null);
                    }
                    if (rowIdsToDelete.isEmpty()) {
                        return CompletableFuture.completedFuture(new ReplicaResult(result, null));
                    }
                    return ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup(rows, catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateAllCommand((Map<UUID, TimedBinaryRowMessage>)rowIdsToDelete, request.commitPartitionId(), request.transactionId(), request.full(), request.coordinatorId(), (int)catalogVersion, request.skipDelayedAck(), leaseStartTime))).thenApply(res -> new ReplicaResult((Object)result, res));
                });
            }
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown multi request [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private static <T> boolean allElementsAreNull(List<T> list) {
        for (T element : list) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    private CompletableFuture<ResultWrapper<Object>> applyCmdWithExceptionHandling(Command cmd) {
        CompletableFuture resultFuture = new CompletableFuture();
        this.raftCommandRunner.run(cmd).whenComplete((res, ex) -> {
            if (ex != null) {
                resultFuture.completeExceptionally((Throwable)ex);
            } else {
                resultFuture.complete(new ResultWrapper<Object>(cmd, res));
            }
        });
        return resultFuture.exceptionally(throwable -> {
            if (throwable instanceof TimeoutException) {
                throw new ReplicationTimeoutException((ReplicationGroupId)this.replicationGroupId);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ReplicationException((ReplicationGroupId)this.replicationGroupId, throwable);
        });
    }

    private CompletableFuture<CommandApplicationResult> applyUpdateCommand(TablePartitionId tablePartId, UUID rowUuid, @Nullable BinaryRow row, @Nullable HybridTimestamp lastCommitTimestamp, UUID txId, boolean full, UUID txCoordinatorId, int catalogVersion, Long leaseStartTime) {
        assert (leaseStartTime != null) : IgniteStringFormatter.format((String)"Lease start time is null for UpdateCommand [txId={}].", (Object[])new Object[]{txId});
        UpdateCommand cmd = PartitionReplicaListener.updateCommand(tablePartId, rowUuid, row, lastCommitTimestamp, txId, full, txCoordinatorId, this.clockService.current(), catalogVersion, full ? leaseStartTime : null);
        if (!cmd.full()) {
            if (!SKIP_UPDATES) {
                this.storageUpdateHandler.handleUpdate(cmd.txId(), cmd.rowUuid(), cmd.tablePartitionId().asTablePartitionId(), cmd.rowToUpdate(), true, null, null, null, this.indexIdsAtRwTxBeginTs(txId));
            }
            CompletionStage repFut = this.applyCmdWithExceptionHandling((Command)cmd).thenApply(res -> cmd.txId());
            return CompletableFuture.completedFuture(new CommandApplicationResult(null, (CompletableFuture)repFut));
        }
        return this.applyCmdWithExceptionHandling((Command)cmd).thenCompose(res -> {
            HybridTimestamp safeTs;
            UpdateCommandResult updateCommandResult = (UpdateCommandResult)res.getResult();
            if (updateCommandResult != null && !updateCommandResult.isPrimaryReplicaMatch()) {
                throw new PrimaryReplicaMissException(txId, cmd.leaseStartTime(), updateCommandResult.currentLeaseStartTime());
            }
            if (updateCommandResult != null && updateCommandResult.isPrimaryInPeersAndLearners()) {
                HybridTimestamp safeTs2 = HybridTimestamp.hybridTimestamp((long)updateCommandResult.safeTimestamp());
                return this.safeTime.waitFor((Comparable)safeTs2).thenApply(ignored -> new CommandApplicationResult(safeTs2, null));
            }
            HybridTimestamp hybridTimestamp = safeTs = updateCommandResult == null ? null : HybridTimestamp.hybridTimestamp((long)updateCommandResult.safeTimestamp());
            if (!SKIP_UPDATES) {
                this.storageUpdateHandler.handleUpdate(cmd.txId(), cmd.rowUuid(), cmd.tablePartitionId().asTablePartitionId(), cmd.rowToUpdate(), false, null, safeTs, null, this.indexIdsAtRwTxBeginTs(txId));
            }
            return CompletableFuture.completedFuture(new CommandApplicationResult(safeTs, null));
        });
    }

    private CompletableFuture<CommandApplicationResult> applyUpdateCommand(ReadWriteSingleRowReplicaRequest request, UUID rowUuid, @Nullable BinaryRow row, @Nullable HybridTimestamp lastCommitTimestamp, int catalogVersion, Long leaseStartTime) {
        return this.applyUpdateCommand(request.commitPartitionId().asTablePartitionId(), rowUuid, row, lastCommitTimestamp, request.transactionId(), request.full(), request.coordinatorId(), catalogVersion, leaseStartTime);
    }

    private CompletableFuture<CommandApplicationResult> applyUpdateAllCommand(Map<UUID, TimedBinaryRowMessage> rowsToUpdate, TablePartitionIdMessage commitPartitionId, UUID txId, boolean full, UUID txCoordinatorId, int catalogVersion, boolean skipDelayedAck, Long leaseStartTime) {
        assert (leaseStartTime != null) : IgniteStringFormatter.format((String)"Lease start time is null for UpdateAllCommand [txId={}].", (Object[])new Object[]{txId});
        UpdateAllCommand cmd = this.updateAllCommand(rowsToUpdate, commitPartitionId, txId, this.clockService.current(), full, txCoordinatorId, catalogVersion, full ? leaseStartTime : null);
        if (!cmd.full()) {
            if (skipDelayedAck) {
                this.storageUpdateHandler.handleUpdateAll(cmd.txId(), cmd.rowsToUpdate(), cmd.tablePartitionId().asTablePartitionId(), true, null, null, this.indexIdsAtRwTxBeginTs(txId));
                return this.applyCmdWithExceptionHandling((Command)cmd).thenApply(res -> null);
            }
            this.storageUpdateHandler.handleUpdateAll(cmd.txId(), cmd.rowsToUpdate(), cmd.tablePartitionId().asTablePartitionId(), true, null, null, this.indexIdsAtRwTxBeginTs(txId));
            CompletionStage repFut = this.applyCmdWithExceptionHandling((Command)cmd).thenApply(res -> cmd.txId());
            return CompletableFuture.completedFuture(new CommandApplicationResult(null, (CompletableFuture)repFut));
        }
        return this.applyCmdWithExceptionHandling((Command)cmd).thenCompose(res -> {
            UpdateCommandResult updateCommandResult = (UpdateCommandResult)res.getResult();
            if (!updateCommandResult.isPrimaryReplicaMatch()) {
                throw new PrimaryReplicaMissException(cmd.txId(), cmd.leaseStartTime(), updateCommandResult.currentLeaseStartTime());
            }
            if (updateCommandResult.isPrimaryInPeersAndLearners()) {
                HybridTimestamp safeTs = HybridTimestamp.hybridTimestamp((long)updateCommandResult.safeTimestamp());
                return this.safeTime.waitFor((Comparable)safeTs).thenApply(ignored -> new CommandApplicationResult(safeTs, null));
            }
            HybridTimestamp safeTs = HybridTimestamp.hybridTimestamp((long)updateCommandResult.safeTimestamp());
            this.storageUpdateHandler.handleUpdateAll(cmd.txId(), cmd.rowsToUpdate(), cmd.tablePartitionId().asTablePartitionId(), false, null, safeTs, this.indexIdsAtRwTxBeginTs(txId));
            return CompletableFuture.completedFuture(new CommandApplicationResult(safeTs, null));
        });
    }

    private CompletableFuture<CommandApplicationResult> applyUpdateAllCommand(ReadWriteMultiRowReplicaRequest request, Map<UUID, TimedBinaryRowMessage> rowsToUpdate, int catalogVersion, Long leaseStartTime) {
        return this.applyUpdateAllCommand(rowsToUpdate, request.commitPartitionId(), request.transactionId(), request.full(), request.coordinatorId(), catalogVersion, request.skipDelayedAck(), leaseStartTime);
    }

    private CompletableFuture<BinaryRow> processReadOnlyDirectSingleEntryAction(ReadOnlyDirectSingleRowReplicaRequest request, HybridTimestamp opStartTimestamp) {
        BinaryTuple primaryKey = this.resolvePk(request.primaryKey());
        HybridTimestamp readTimestamp = opStartTimestamp;
        if (request.requestType() != RequestType.RO_GET) {
            throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
        }
        return this.resolveRowByPkForReadOnly(primaryKey, readTimestamp);
    }

    private CompletableFuture<ReplicaResult> processSingleEntryAction(ReadWriteSingleRowReplicaRequest request, Long leaseStartTime) {
        UUID txId = request.transactionId();
        BinaryRow searchRow = request.binaryRow();
        TablePartitionId commitPartitionId = request.commitPartitionId().asTablePartitionId();
        assert (commitPartitionId != null) : "Commit partition is null [type=" + String.valueOf(request.requestType()) + "]";
        switch (request.requestType()) {
            case RW_DELETE_EXACT: {
                return this.resolveRowByPk(this.extractPk(searchRow), txId, (rowId, row, lastCommitTime) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(new ReplicaResult((Object)false, null));
                    }
                    return this.takeLocksForDeleteExact(searchRow, (RowId)rowId, (BinaryRow)row, txId).thenCompose(validatedRowId -> {
                        if (validatedRowId == null) {
                            return CompletableFuture.completedFuture(new ReplicaResult((Object)false, null));
                        }
                        return ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup((RowId)validatedRowId, (Object)catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(request, validatedRowId.uuid(), null, (HybridTimestamp)lastCommitTime, (int)catalogVersion, leaseStartTime))).thenApply(res -> new ReplicaResult((Object)true, res));
                    });
                });
            }
            case RW_INSERT: {
                return this.resolveRowByPk(this.extractPk(searchRow), txId, (rowId, row, lastCommitTime) -> {
                    if (rowId != null) {
                        return CompletableFuture.completedFuture(new ReplicaResult((Object)false, null));
                    }
                    RowId rowId0 = new RowId(this.partId(), RowIdGenerator.next());
                    return ((CompletableFuture)this.takeLocksForInsert(searchRow, rowId0, txId).thenCompose(rowIdLock -> ((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.applyUpdateCommand(request, rowId0.uuid(), searchRow, (HybridTimestamp)lastCommitTime, (int)catalogVersion, leaseStartTime))).thenApply(res -> new IgniteBiTuple(res, rowIdLock)))).thenApply(tuple -> {
                        ((Collection)((IgniteBiTuple)tuple.get2()).get2()).forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        return new ReplicaResult((Object)true, (CommandApplicationResult)tuple.get1());
                    });
                });
            }
            case RW_UPSERT: {
                return this.resolveRowByPk(this.extractPk(searchRow), txId, (rowId, row, lastCommitTime) -> {
                    boolean insert = rowId == null;
                    RowId rowId0 = insert ? new RowId(this.partId(), RowIdGenerator.next()) : rowId;
                    CompletableFuture<IgniteBiTuple<RowId, Collection<Lock>>> lockFut = insert ? this.takeLocksForInsert(searchRow, rowId0, txId) : this.takeLocksForUpdate(searchRow, rowId0, txId);
                    return ((CompletableFuture)lockFut.thenCompose(rowIdLock -> ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup((RowId)rowId, (Object)catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(request, rowId0.uuid(), searchRow, (HybridTimestamp)lastCommitTime, (int)catalogVersion, leaseStartTime))).thenApply(res -> new IgniteBiTuple(res, rowIdLock)))).thenApply(tuple -> {
                        ((Collection)((IgniteBiTuple)tuple.get2()).get2()).forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        return new ReplicaResult(null, (CommandApplicationResult)tuple.get1());
                    });
                });
            }
            case RW_GET_AND_UPSERT: {
                return this.resolveRowByPk(this.extractPk(searchRow), txId, (rowId, row, lastCommitTime) -> {
                    boolean insert = rowId == null;
                    RowId rowId0 = insert ? new RowId(this.partId(), RowIdGenerator.next()) : rowId;
                    CompletableFuture<IgniteBiTuple<RowId, Collection<Lock>>> lockFut = insert ? this.takeLocksForInsert(searchRow, rowId0, txId) : this.takeLocksForUpdate(searchRow, rowId0, txId);
                    return ((CompletableFuture)lockFut.thenCompose(rowIdLock -> ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup((RowId)rowId, (Object)catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(request, rowId0.uuid(), searchRow, (HybridTimestamp)lastCommitTime, (int)catalogVersion, leaseStartTime))).thenApply(res -> new IgniteBiTuple(res, rowIdLock)))).thenApply(tuple -> {
                        ((Collection)((IgniteBiTuple)tuple.get2()).get2()).forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        return new ReplicaResult(row, (CommandApplicationResult)tuple.get1());
                    });
                });
            }
            case RW_GET_AND_REPLACE: {
                return this.resolveRowByPk(this.extractPk(searchRow), txId, (rowId, row, lastCommitTime) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(new ReplicaResult(null, null));
                    }
                    return ((CompletableFuture)this.takeLocksForUpdate(searchRow, (RowId)rowId, txId).thenCompose(rowIdLock -> ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup((RowId)rowId, (Object)catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(request, rowId.uuid(), searchRow, (HybridTimestamp)lastCommitTime, (int)catalogVersion, leaseStartTime))).thenApply(res -> new IgniteBiTuple(res, rowIdLock)))).thenApply(tuple -> {
                        ((Collection)((IgniteBiTuple)tuple.get2()).get2()).forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        return new ReplicaResult(row, (CommandApplicationResult)tuple.get1());
                    });
                });
            }
            case RW_REPLACE_IF_EXIST: {
                return this.resolveRowByPk(this.extractPk(searchRow), txId, (rowId, row, lastCommitTime) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(new ReplicaResult((Object)false, null));
                    }
                    return ((CompletableFuture)this.takeLocksForUpdate(searchRow, (RowId)rowId, txId).thenCompose(rowIdLock -> ((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()).thenCompose(catalogVersion -> this.awaitCleanup((RowId)rowId, (Object)catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(request, rowId.uuid(), searchRow, (HybridTimestamp)lastCommitTime, (int)catalogVersion, leaseStartTime))).thenApply(res -> new IgniteBiTuple(res, rowIdLock)))).thenApply(tuple -> {
                        ((Collection)((IgniteBiTuple)tuple.get2()).get2()).forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        return new ReplicaResult((Object)true, (CommandApplicationResult)tuple.get1());
                    });
                });
            }
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private CompletableFuture<ReplicaResult> processSingleEntryAction(ReadWriteSingleRowPkReplicaRequest request, Long leaseStartTime) {
        UUID txId = request.transactionId();
        BinaryTuple primaryKey = this.resolvePk(request.primaryKey());
        TablePartitionId commitPartitionId = request.commitPartitionId().asTablePartitionId();
        assert (commitPartitionId != null || request.requestType() == RequestType.RW_GET) : "Commit partition is null [type=" + String.valueOf(request.requestType()) + "]";
        switch (request.requestType()) {
            case RW_GET: {
                return this.resolveRowByPk(primaryKey, txId, (rowId, row, lastCommitTime) -> {
                    if (rowId == null) {
                        return CompletableFutures.nullCompletedFuture();
                    }
                    return ((CompletableFuture)this.takeLocksForGet((RowId)rowId, txId).thenCompose(ignored -> this.validateRwReadAgainstSchemaAfterTakingLocks(txId))).thenApply(ignored -> new ReplicaResult(row, null));
                });
            }
            case RW_DELETE: {
                return this.resolveRowByPk(primaryKey, txId, (rowId, row, lastCommitTime) -> {
                    if (rowId == null) {
                        return CompletableFuture.completedFuture(new ReplicaResult((Object)false, null));
                    }
                    return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.takeLocksForDelete((BinaryRow)row, (RowId)rowId, txId).thenCompose(rowLock -> this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()))).thenCompose(catalogVersion -> this.awaitCleanup((RowId)rowId, (Object)catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(request.commitPartitionId().asTablePartitionId(), rowId.uuid(), null, (HybridTimestamp)lastCommitTime, request.transactionId(), request.full(), request.coordinatorId(), (int)catalogVersion, leaseStartTime))).thenApply(res -> new ReplicaResult((Object)true, res));
                });
            }
            case RW_GET_AND_DELETE: {
                return this.resolveRowByPk(primaryKey, txId, (rowId, row, lastCommitTime) -> {
                    if (rowId == null) {
                        return CompletableFutures.nullCompletedFuture();
                    }
                    return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.takeLocksForDelete((BinaryRow)row, (RowId)rowId, txId).thenCompose(ignored -> this.validateWriteAgainstSchemaAfterTakingLocks(request.transactionId()))).thenCompose(catalogVersion -> this.awaitCleanup((RowId)rowId, (Object)catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(request.commitPartitionId().asTablePartitionId(), rowId.uuid(), null, (HybridTimestamp)lastCommitTime, request.transactionId(), request.full(), request.coordinatorId(), (int)catalogVersion, leaseStartTime))).thenApply(res -> new ReplicaResult(row, res));
                });
            }
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown single request [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private <T> CompletableFuture<T> awaitCleanup(@Nullable RowId rowId, T result) {
        return (rowId == null ? CompletableFutures.nullCompletedFuture() : this.rowCleanupMap.getOrDefault(rowId, CompletableFutures.nullCompletedFuture())).thenApply(ignored -> result);
    }

    private <T> CompletableFuture<T> awaitCleanup(Collection<RowId> rowIds, T result) {
        if (this.rowCleanupMap.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        ArrayList list = new ArrayList(rowIds.size());
        for (RowId rowId : rowIds) {
            CompletableFuture<?> completableFuture = this.rowCleanupMap.get(rowId);
            if (completableFuture == null) continue;
            list.add(completableFuture);
        }
        if (list.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).thenApply(unused -> result);
    }

    private BinaryTuple extractPk(BinaryRow row) {
        return ((TableSchemaAwareIndexStorage)this.pkIndexStorage.get()).indexRowResolver().extractColumns(row);
    }

    private BinaryTuple resolvePk(ByteBuffer bytes) {
        return ((TableSchemaAwareIndexStorage)this.pkIndexStorage.get()).resolve(bytes);
    }

    private List<BinaryTuple> resolvePks(List<ByteBuffer> bytesList) {
        ArrayList<BinaryTuple> pks = new ArrayList<BinaryTuple>(bytesList.size());
        for (ByteBuffer bytes : bytesList) {
            pks.add(this.resolvePk(bytes));
        }
        return pks;
    }

    private Cursor<RowId> getFromPkIndex(BinaryTuple key) {
        return ((TableSchemaAwareIndexStorage)this.pkIndexStorage.get()).storage().get(key);
    }

    private CompletableFuture<IgniteBiTuple<RowId, Collection<Lock>>> takeLocksForUpdate(BinaryRow binaryRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.X))).thenCompose(ignored -> this.takePutLockOnIndexes(binaryRow, rowId, txId))).thenApply(shortTermLocks -> new IgniteBiTuple((Object)rowId, shortTermLocks));
    }

    private CompletableFuture<IgniteBiTuple<RowId, Collection<Lock>>> takeLocksForInsert(BinaryRow binaryRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId), LockMode.IX).thenCompose(ignored -> this.takePutLockOnIndexes(binaryRow, rowId, txId))).thenApply(shortTermLocks -> new IgniteBiTuple((Object)rowId, shortTermLocks));
    }

    private CompletableFuture<Collection<Lock>> takePutLockOnIndexes(BinaryRow binaryRow, RowId rowId, UUID txId) {
        Collection<IndexLocker> indexes = this.indexesLockers.get().values();
        if (CollectionUtils.nullOrEmpty(indexes)) {
            return CompletableFutures.emptyCollectionCompletedFuture();
        }
        CompletableFuture[] locks = new CompletableFuture[indexes.size()];
        int idx = 0;
        for (IndexLocker locker : indexes) {
            locks[idx++] = locker.locksForInsert(txId, binaryRow, rowId);
        }
        return CompletableFuture.allOf(locks).thenApply(unused -> {
            ArrayList<Lock> shortTermLocks = new ArrayList<Lock>();
            for (CompletableFuture lockFut : locks) {
                Lock shortTermLock = (Lock)lockFut.join();
                if (shortTermLock == null) continue;
                shortTermLocks.add(shortTermLock);
            }
            return shortTermLocks;
        });
    }

    private CompletableFuture<?> takeRemoveLockOnIndexes(BinaryRow binaryRow, RowId rowId, UUID txId) {
        Collection<IndexLocker> indexes = this.indexesLockers.get().values();
        if (CollectionUtils.nullOrEmpty(indexes)) {
            return CompletableFutures.nullCompletedFuture();
        }
        CompletableFuture[] locks = new CompletableFuture[indexes.size()];
        int idx = 0;
        for (IndexLocker locker : indexes) {
            locks[idx++] = locker.locksForRemove(txId, binaryRow, rowId);
        }
        return CompletableFuture.allOf(locks);
    }

    private CompletableFuture<RowId> takeLocksForDeleteExact(BinaryRow expectedRow, RowId rowId, BinaryRow actualRow, UUID txId) {
        return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.S))).thenCompose(ignored -> {
            if (PartitionReplicaListener.equalValues(actualRow, expectedRow)) {
                return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.X).thenCompose(ignored0 -> this.takeRemoveLockOnIndexes(actualRow, rowId, txId))).thenApply(exclusiveRowLock -> rowId);
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private CompletableFuture<RowId> takeLocksForDelete(BinaryRow binaryRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.X))).thenCompose(ignored -> this.takeRemoveLockOnIndexes(binaryRow, rowId, txId))).thenApply(ignored -> rowId);
    }

    private CompletableFuture<RowId> takeLocksForGet(RowId rowId, UUID txId) {
        return this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.S).thenApply(ignored -> rowId);
    }

    private CompletableFuture<ReplicaResult> processTwoEntriesAction(ReadWriteSwapRowReplicaRequest request, Long leaseStartTime) {
        BinaryRow newRow = request.newBinaryRow();
        BinaryRow expectedRow = request.oldBinaryRow();
        TablePartitionIdMessage commitPartitionId = request.commitPartitionId();
        assert (commitPartitionId != null) : "Commit partition is null [type=" + String.valueOf(request.requestType()) + "]";
        UUID txId = request.transactionId();
        if (request.requestType() == RequestType.RW_REPLACE) {
            return this.resolveRowByPk(this.extractPk(newRow), txId, (rowId, row, lastCommitTime) -> {
                if (rowId == null) {
                    return CompletableFuture.completedFuture(new ReplicaResult((Object)false, null));
                }
                return this.takeLocksForReplace(expectedRow, (BinaryRow)row, newRow, (RowId)rowId, txId).thenCompose(rowIdLock -> {
                    if (rowIdLock == null) {
                        return CompletableFuture.completedFuture(new ReplicaResult((Object)false, null));
                    }
                    return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateWriteAgainstSchemaAfterTakingLocks(txId).thenCompose(catalogVersion -> this.awaitCleanup((RowId)rowIdLock.get1(), catalogVersion))).thenCompose(catalogVersion -> this.applyUpdateCommand(commitPartitionId.asTablePartitionId(), ((RowId)rowIdLock.get1()).uuid(), newRow, (HybridTimestamp)lastCommitTime, txId, request.full(), request.coordinatorId(), (int)catalogVersion, leaseStartTime))).thenApply(res -> new IgniteBiTuple(res, rowIdLock))).thenApply(tuple -> {
                        ((Collection)((IgniteBiTuple)tuple.get2()).get2()).forEach(lock -> this.lockManager.release(lock.txId(), lock.lockKey(), lock.lockMode()));
                        return new ReplicaResult((Object)true, (CommandApplicationResult)tuple.get1());
                    });
                });
            });
        }
        throw new IgniteInternalException(ErrorGroups.Replicator.REPLICA_COMMON_ERR, IgniteStringFormatter.format((String)"Unknown two actions operation [actionType={}]", (Object[])new Object[]{request.requestType()}));
    }

    private CompletableFuture<IgniteBiTuple<RowId, Collection<Lock>>> takeLocksForReplace(BinaryRow expectedRow, @Nullable BinaryRow oldRow, BinaryRow newRow, RowId rowId, UUID txId) {
        return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId), LockMode.IX).thenCompose(ignored -> this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.S))).thenCompose(ignored -> {
            if (oldRow != null && PartitionReplicaListener.equalValues(oldRow, expectedRow)) {
                return ((CompletableFuture)this.lockManager.acquire(txId, new LockKey((Object)this.replicationGroupId, (Object)rowId), LockMode.X).thenCompose(ignored1 -> this.takePutLockOnIndexes(newRow, rowId, txId))).thenApply(shortTermLocks -> new IgniteBiTuple((Object)rowId, shortTermLocks));
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private CompletableFuture<IgniteBiTuple<Boolean, Long>> ensureReplicaIsPrimary(ReplicaRequest request) {
        HybridTimestamp current = this.clockService.current();
        if (request instanceof PrimaryReplicaRequest) {
            Long enlistmentConsistencyToken = ((PrimaryReplicaRequest)request).enlistmentConsistencyToken();
            Function<ReplicaMeta, IgniteBiTuple> validateClo = primaryReplicaMeta -> {
                if (primaryReplicaMeta == null) {
                    throw new PrimaryReplicaMissException(this.localNode.name(), null, this.localNode.id(), null, enlistmentConsistencyToken, null, null);
                }
                long currentEnlistmentConsistencyToken = primaryReplicaMeta.getStartTime().longValue();
                if (enlistmentConsistencyToken != currentEnlistmentConsistencyToken || this.clockService.before(primaryReplicaMeta.getExpirationTime(), current) || !this.isLocalPeer(primaryReplicaMeta.getLeaseholderId())) {
                    throw new PrimaryReplicaMissException(this.localNode.name(), primaryReplicaMeta.getLeaseholder(), this.localNode.id(), primaryReplicaMeta.getLeaseholderId(), enlistmentConsistencyToken, Long.valueOf(currentEnlistmentConsistencyToken), null);
                }
                return new IgniteBiTuple(null, (Object)primaryReplicaMeta.getStartTime().longValue());
            };
            ReplicaMeta meta = this.placementDriver.getCurrentPrimaryReplica((ReplicationGroupId)this.replicationGroupId, current);
            if (meta != null) {
                try {
                    return CompletableFuture.completedFuture(validateClo.apply(meta));
                }
                catch (Exception e) {
                    return CompletableFuture.failedFuture(e);
                }
            }
            return this.placementDriver.getPrimaryReplica((ReplicationGroupId)this.replicationGroupId, current).thenApply(validateClo);
        }
        if (request instanceof ReadOnlyReplicaRequest) {
            return this.isLocalNodePrimaryReplicaAt(current);
        }
        if (request instanceof ReplicaSafeTimeSyncRequest) {
            return this.isLocalNodePrimaryReplicaAt(current);
        }
        return CompletableFuture.completedFuture(new IgniteBiTuple(null, null));
    }

    private CompletableFuture<IgniteBiTuple<Boolean, Long>> isLocalNodePrimaryReplicaAt(HybridTimestamp timestamp) {
        return this.placementDriver.getPrimaryReplica((ReplicationGroupId)this.replicationGroupId, timestamp).thenApply(primaryReplica -> new IgniteBiTuple((Object)(primaryReplica != null && this.isLocalPeer(primaryReplica.getLeaseholderId()) ? 1 : 0), null));
    }

    private CompletableFuture<@Nullable TimedBinaryRow> resolveReadResult(ReadResult readResult, @Nullable UUID txId, @Nullable HybridTimestamp timestamp, Supplier<@Nullable TimedBinaryRow> lastCommitted) {
        UUID retrievedResultTxId;
        if (readResult == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (!readResult.isWriteIntent()) {
            return CompletableFuture.completedFuture(new TimedBinaryRow(readResult.binaryRow(), readResult.commitTimestamp()));
        }
        if (timestamp == null && txId.equals(retrievedResultTxId = readResult.transactionId())) {
            return CompletableFuture.completedFuture(new TimedBinaryRow(readResult.binaryRow()));
        }
        return this.resolveWriteIntentAsync(readResult, timestamp, lastCommitted);
    }

    private CompletableFuture<@Nullable TimedBinaryRow> resolveWriteIntentAsync(ReadResult readResult, @Nullable HybridTimestamp timestamp, Supplier<@Nullable TimedBinaryRow> lastCommitted) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.resolveWriteIntentReadability(readResult, timestamp).thenApply(arg_0 -> this.lambda$resolveWriteIntentAsync$205(readResult, (Supplier)lastCommitted, arg_0)));
    }

    private void scheduleAsyncWriteIntentSwitch(UUID txId, RowId rowId, TransactionMeta meta) {
        TxState txState = meta.txState();
        assert (TxState.isFinalState((TxState)txState)) : "Unexpected state [txId=" + String.valueOf(txId) + ", txState=" + String.valueOf(txState) + "]";
        HybridTimestamp commitTimestamp = meta.commitTimestamp();
        this.storageUpdateHandler.handleWriteIntentRead(txId, rowId);
        CompletableFuture future = this.rowCleanupMap.computeIfAbsent(rowId, k -> this.txManager.executeWriteIntentSwitchAsync(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.storageUpdateHandler.switchWriteIntents(txId, txState == TxState.COMMITTED, commitTimestamp, this.indexIdsAtRwTxBeginTs(txId)))).whenComplete((unused, e) -> {
            if (e != null) {
                LOG.warn("Failed to complete transaction cleanup command [txId=" + String.valueOf(txId) + "]", e);
            }
        }));
        future.handle((v, e) -> this.rowCleanupMap.remove(rowId, future));
    }

    private CompletableFuture<Boolean> resolveWriteIntentReadability(ReadResult writeIntent, @Nullable HybridTimestamp timestamp) {
        UUID txId = writeIntent.transactionId();
        return this.transactionStateResolver.resolveTxState(txId, new TablePartitionId(writeIntent.commitTableId().intValue(), writeIntent.commitPartitionId()), timestamp).thenApply(transactionMeta -> {
            if (TxState.isFinalState((TxState)transactionMeta.txState())) {
                this.scheduleAsyncWriteIntentSwitch(txId, writeIntent.rowId(), (TransactionMeta)transactionMeta);
            }
            return PartitionReplicaListener.canReadFromWriteIntent(txId, transactionMeta, timestamp);
        });
    }

    private static Boolean canReadFromWriteIntent(UUID txId, TransactionMeta txMeta, @Nullable HybridTimestamp timestamp) {
        assert (TxState.isFinalState((TxState)txMeta.txState()) || txMeta.txState() == TxState.PENDING) : IgniteStringFormatter.format((String)"Unexpected state defined by write intent resolution [txId={}, txMeta={}].", (Object[])new Object[]{txId, txMeta});
        if (txMeta.txState() == TxState.COMMITTED) {
            boolean readLatest = timestamp == null;
            return readLatest || txMeta.commitTimestamp().compareTo(timestamp) <= 0;
        }
        return false;
    }

    private CompletableFuture<Void> validateRwReadAgainstSchemaAfterTakingLocks(UUID txId) {
        HybridTimestamp operationTimestamp = this.clockService.now();
        return this.schemaSyncService.waitForMetadataCompleteness(operationTimestamp).thenRun(() -> this.failIfSchemaChangedSinceTxStart(txId, operationTimestamp));
    }

    private CompletableFuture<Integer> validateWriteAgainstSchemaAfterTakingLocks(UUID txId) {
        HybridTimestamp operationTimestamp = this.clockService.current();
        return this.reliableCatalogVersionFor(operationTimestamp).thenApply(catalogVersion -> {
            this.failIfSchemaChangedSinceTxStart(txId, operationTimestamp);
            return catalogVersion;
        });
    }

    private static UpdateCommand updateCommand(TablePartitionId tablePartId, UUID rowUuid, @Nullable BinaryRow row, @Nullable HybridTimestamp lastCommitTimestamp, UUID txId, boolean full, UUID txCoordinatorId, @Nullable HybridTimestamp initiatorTime, int catalogVersion, @Nullable Long leaseStartTime) {
        UpdateCommandBuilder bldr = PARTITION_REPLICATION_MESSAGES_FACTORY.updateCommand().tablePartitionId(PartitionReplicaListener.tablePartitionId(tablePartId)).rowUuid(rowUuid).txId(txId).full(full).initiatorTime(initiatorTime).txCoordinatorId(txCoordinatorId).requiredCatalogVersion(catalogVersion).leaseStartTime(leaseStartTime);
        if (lastCommitTimestamp != null || row != null) {
            TimedBinaryRowMessageBuilder rowMsgBldr = PARTITION_REPLICATION_MESSAGES_FACTORY.timedBinaryRowMessage();
            if (lastCommitTimestamp != null) {
                rowMsgBldr.timestamp(lastCommitTimestamp);
            }
            if (row != null) {
                rowMsgBldr.binaryRowMessage(PartitionReplicaListener.binaryRowMessage(row));
            }
            bldr.messageRowToUpdate(rowMsgBldr.build());
        }
        return bldr.build();
    }

    private static BinaryRowMessage binaryRowMessage(BinaryRow row) {
        return PARTITION_REPLICATION_MESSAGES_FACTORY.binaryRowMessage().binaryTuple(row.tupleSlice()).schemaVersion(row.schemaVersion()).build();
    }

    private UpdateAllCommand updateAllCommand(Map<UUID, TimedBinaryRowMessage> rowsToUpdate, TablePartitionIdMessage commitPartitionId, UUID transactionId, HybridTimestamp initiatorTime, boolean full, UUID txCoordinatorId, int catalogVersion, @Nullable Long leaseStartTime) {
        return PARTITION_REPLICATION_MESSAGES_FACTORY.updateAllCommand().tablePartitionId(commitPartitionId).messageRowsToUpdate(rowsToUpdate).txId(transactionId).initiatorTime(initiatorTime).full(full).txCoordinatorId(txCoordinatorId).requiredCatalogVersion(catalogVersion).leaseStartTime(leaseStartTime).build();
    }

    private void failIfSchemaChangedSinceTxStart(UUID txId, HybridTimestamp operationTimestamp) {
        this.schemaCompatValidator.failIfSchemaChangedAfterTxStart(txId, operationTimestamp, this.tableId());
    }

    private CompletableFuture<Integer> reliableCatalogVersionFor(HybridTimestamp ts) {
        return this.schemaSyncService.waitForMetadataCompleteness(ts).thenApply(unused -> this.catalogService.activeCatalogVersion(ts.longValue()));
    }

    public static TablePartitionIdMessage tablePartitionId(TablePartitionId tablePartId) {
        return ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (TablePartitionId)tablePartId);
    }

    public void onShutdown() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.catalogService.removeListener((Event)CatalogEvent.INDEX_BUILDING, this.indexBuildingCatalogEventListener);
        this.txRwOperationTracker.close();
    }

    private int partId() {
        return this.replicationGroupId.partitionId();
    }

    private int tableId() {
        return this.replicationGroupId.tableId();
    }

    private boolean isLocalPeer(UUID nodeId) {
        return this.localNode.id().equals(nodeId);
    }

    private void markFinished(UUID txId, TxState txState, @Nullable HybridTimestamp commitTimestamp) {
        assert (TxState.isFinalState((TxState)txState)) : "Unexpected state [txId=" + String.valueOf(txId) + ", txState=" + String.valueOf(txState) + "]";
        this.txManager.updateTxMeta(txId, old -> new TxStateMeta(txState, old == null ? null : old.txCoordinatorId(), old == null ? null : old.commitPartitionId(), (HybridTimestamp)(txState == TxState.COMMITTED ? commitTimestamp : null), old == null ? null : old.initialVacuumObservationTimestamp(), old == null ? null : old.cleanupCompletionTimestamp()));
    }

    private static BuildIndexCommand toBuildIndexCommand(BuildIndexReplicaRequest request, MetaIndexStatusChange buildingChangeInfo) {
        return PARTITION_REPLICATION_MESSAGES_FACTORY.buildIndexCommand().indexId(request.indexId()).rowIds(request.rowIds()).finish(request.finish()).requiredCatalogVersion(buildingChangeInfo.catalogVersion()).build();
    }

    private CompletableFuture<?> processOperationRequestWithTxOperationManagementLogic(UUID senderId, ReplicaRequest request, @Nullable Boolean isPrimary, @Nullable HybridTimestamp opStartTsIfDirectRo, @Nullable Long leaseStartTime) {
        this.incrementRwOperationCountIfNeeded(request);
        UUID txIdLockingLwm = this.tryToLockLwmIfNeeded(request, opStartTsIfDirectRo);
        try {
            return this.processOperationRequest(senderId, request, isPrimary, opStartTsIfDirectRo, leaseStartTime).whenComplete((unused, throwable) -> {
                this.unlockLwmIfNeeded(txIdLockingLwm, request);
                this.decrementRwOperationCountIfNeeded(request);
            });
        }
        catch (Throwable e) {
            try {
                this.unlockLwmIfNeeded(txIdLockingLwm, request);
            }
            catch (Throwable unlockProblem) {
                e.addSuppressed(unlockProblem);
            }
            try {
                this.decrementRwOperationCountIfNeeded(request);
            }
            catch (Throwable decrementProblem) {
                e.addSuppressed(decrementProblem);
            }
            throw e;
        }
    }

    private void incrementRwOperationCountIfNeeded(ReplicaRequest request) {
        int rwTxActiveCatalogVersion;
        if (request instanceof ReadWriteReplicaRequest && !this.txRwOperationTracker.incrementOperationCount(rwTxActiveCatalogVersion = ReplicatorUtils.rwTxActiveCatalogVersion(this.catalogService, (ReadWriteReplicaRequest)request))) {
            throw new StaleTransactionOperationException(((ReadWriteReplicaRequest)request).transactionId());
        }
    }

    private void decrementRwOperationCountIfNeeded(ReplicaRequest request) {
        if (request instanceof ReadWriteReplicaRequest) {
            this.txRwOperationTracker.decrementOperationCount(ReplicatorUtils.rwTxActiveCatalogVersion(this.catalogService, (ReadWriteReplicaRequest)request));
        }
    }

    private static UUID newFakeTxId() {
        return UUID.randomUUID();
    }

    @Nullable
    private UUID tryToLockLwmIfNeeded(ReplicaRequest request, @Nullable HybridTimestamp opStartTsIfDirectRo) {
        UUID txIdToLockLwm;
        HybridTimestamp tsToLockLwm = null;
        if (request instanceof ReadOnlyDirectMultiRowReplicaRequest && ((ReadOnlyDirectMultiRowReplicaRequest)request).primaryKeys().size() > 1) {
            assert (opStartTsIfDirectRo != null);
            txIdToLockLwm = PartitionReplicaListener.newFakeTxId();
            tsToLockLwm = opStartTsIfDirectRo;
        } else if (request instanceof ReadOnlyReplicaRequest) {
            ReadOnlyReplicaRequest readOnlyRequest = (ReadOnlyReplicaRequest)request;
            txIdToLockLwm = readOnlyRequest.transactionId();
            tsToLockLwm = readOnlyRequest.readTimestamp();
        } else {
            txIdToLockLwm = null;
        }
        if (txIdToLockLwm != null) {
            if (!this.lowWatermark.tryLock(txIdToLockLwm, tsToLockLwm)) {
                throw new TransactionException(ErrorGroups.Transactions.TX_STALE_READ_ONLY_OPERATION_ERR, "Read timestamp is not available anymore.");
            }
            this.registerAutoLwmUnlockOnCoordinatorLeaveIfNeeded(request, txIdToLockLwm);
        }
        return txIdToLockLwm;
    }

    private void registerAutoLwmUnlockOnCoordinatorLeaveIfNeeded(ReplicaRequest request, UUID txIdToLockLwm) {
        ReadOnlyReplicaRequest readOnlyReplicaRequest;
        UUID coordinatorId;
        if (request instanceof ReadOnlyReplicaRequest && (coordinatorId = (readOnlyReplicaRequest = (ReadOnlyReplicaRequest)request).coordinatorId()) != null) {
            FullyQualifiedResourceId resourceId = new FullyQualifiedResourceId(txIdToLockLwm, txIdToLockLwm);
            this.remotelyTriggeredResourceRegistry.register(resourceId, coordinatorId, () -> () -> this.lowWatermark.unlock(txIdToLockLwm));
        }
    }

    private void unlockLwmIfNeeded(@Nullable UUID txIdToUnlockLwm, ReplicaRequest request) {
        if (txIdToUnlockLwm != null && request instanceof ReadOnlyDirectReplicaRequest) {
            this.lowWatermark.unlock(txIdToUnlockLwm);
        }
    }

    private void prepareIndexBuilderTxRwOperationTracker() {
        CatalogIndexDescriptor indexDescriptor = ReplicatorUtils.latestIndexDescriptorInBuildingStatus(this.catalogService, this.tableId());
        if (indexDescriptor != null) {
            IndexMeta indexMeta = this.indexMetaStorage.indexMeta(indexDescriptor.id());
            assert (indexMeta != null) : indexDescriptor.id();
            this.txRwOperationTracker.updateMinAllowedCatalogVersionForStartOperation(indexMeta.statusChange(MetaIndexStatus.REGISTERED).catalogVersion());
        }
        this.catalogService.listen((Event)CatalogEvent.INDEX_BUILDING, this.indexBuildingCatalogEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> onIndexBuilding(CatalogEventParameters parameters) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.trueCompletedFuture();
        }
        try {
            int indexId = ((StartBuildingIndexEventParameters)parameters).indexId();
            IndexMeta indexMeta = this.indexMetaStorage.indexMeta(indexId);
            assert (indexMeta != null) : "indexId=" + indexId + ", catalogVersion=" + parameters.catalogVersion();
            MetaIndexStatusChange registeredStatusChange = indexMeta.statusChange(MetaIndexStatus.REGISTERED);
            if (indexMeta.tableId() == this.tableId()) {
                this.txRwOperationTracker.updateMinAllowedCatalogVersionForStartOperation(registeredStatusChange.catalogVersion());
            }
            CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<?> processBuildIndexReplicaRequest(BuildIndexReplicaRequest request) {
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(request.indexId());
        if (indexMeta == null || indexMeta.isDropped()) {
            return CompletableFutures.nullCompletedFuture();
        }
        MetaIndexStatusChange registeredChangeInfo = indexMeta.statusChange(MetaIndexStatus.REGISTERED);
        MetaIndexStatusChange buildingChangeInfo = indexMeta.statusChange(MetaIndexStatus.BUILDING);
        return ((CompletableFuture)this.txRwOperationTracker.awaitCompleteTxRwOperations(registeredChangeInfo.catalogVersion()).thenCompose(unused -> this.safeTime.waitFor((Comparable)HybridTimestamp.hybridTimestamp((long)buildingChangeInfo.activationTimestamp())))).thenCompose(unused -> this.raftCommandRunner.run((Command)PartitionReplicaListener.toBuildIndexCommand(request, buildingChangeInfo)));
    }

    private List<Integer> indexIdsAtRwTxBeginTs(UUID txId) {
        return TableUtils.indexIdsAtRwTxBeginTs(this.catalogService, txId, this.tableId());
    }

    private int tableVersionByTs(HybridTimestamp ts) {
        int activeCatalogVersion = this.catalogService.activeCatalogVersion(ts.longValue());
        CatalogTableDescriptor table = this.catalogService.table(this.tableId(), activeCatalogVersion);
        assert (table != null) : "tableId=" + this.tableId() + ", catalogVersion=" + activeCatalogVersion;
        return table.tableVersion();
    }

    @Nullable
    private static BinaryRow binaryRow(@Nullable TimedBinaryRow timedBinaryRow) {
        return timedBinaryRow == null ? null : timedBinaryRow.binaryRow();
    }

    @Nullable
    private BinaryRow upgrade(@Nullable BinaryRow source, int targetSchemaVersion) {
        return source == null ? null : new BinaryRowUpgrader(this.schemaRegistry, targetSchemaVersion).upgrade(source);
    }

    private CompletableFuture<?> processVacuumTxStateReplicaRequest(VacuumTxStateReplicaRequest request) {
        VacuumTxStatesCommand cmd = TX_MESSAGES_FACTORY.vacuumTxStatesCommand().txIds(request.transactionIds()).build();
        return this.raftCommandRunner.run((Command)cmd);
    }

    private CompletableFuture<?> processMinimumActiveTxTimeReplicaRequest(UpdateMinimumActiveTxBeginTimeReplicaRequest request) {
        UpdateMinimumActiveTxBeginTimeCommand cmd = PARTITION_REPLICATION_MESSAGES_FACTORY.updateMinimumActiveTxBeginTimeCommand().timestamp(request.timestamp()).initiatorTime(this.clockService.now()).build();
        return this.applyCmdWithExceptionHandling((Command)cmd);
    }

    private static Map<TablePartitionId, String> asTablePartitionIdStringMap(Map<TablePartitionIdMessage, String> messages) {
        HashMap<TablePartitionId, String> result = new HashMap<TablePartitionId, String>(messages.size());
        for (Map.Entry<TablePartitionIdMessage, String> e : messages.entrySet()) {
            result.put(e.getKey().asTablePartitionId(), e.getValue());
        }
        return result;
    }

    private /* synthetic */ TimedBinaryRow lambda$resolveWriteIntentAsync$205(ReadResult readResult, Supplier lastCommitted, Boolean writeIntentReadable) {
        return (TimedBinaryRow)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.lambda$resolveWriteIntentAsync$204(writeIntentReadable, readResult, (Supplier)lastCommitted));
    }

    private /* synthetic */ TimedBinaryRow lambda$resolveWriteIntentAsync$204(Boolean writeIntentReadable, ReadResult readResult, Supplier lastCommitted) {
        if (writeIntentReadable.booleanValue()) {
            HybridTimestamp commitTimestamp = this.txManager.stateMeta(readResult.transactionId()).commitTimestamp();
            return new TimedBinaryRow(readResult.binaryRow(), commitTimestamp);
        }
        return (TimedBinaryRow)lastCommitted.get();
    }

    private static class OperationId {
        private UUID initiatorId;
        private long ts;

        public OperationId(UUID initiatorId, long ts) {
            this.initiatorId = initiatorId;
            this.ts = ts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationId that = (OperationId)o;
            if (this.ts != that.ts) {
                return false;
            }
            return this.initiatorId.equals(that.initiatorId);
        }

        public int hashCode() {
            int result = this.initiatorId.hashCode();
            result = 31 * result + (int)(this.ts ^ this.ts >>> 32);
            return result;
        }
    }

    private static class ResultWrapper<T> {
        private final Command command;
        private final T result;

        ResultWrapper(Command command, T result) {
            this.command = command;
            this.result = result;
        }

        Command getCommand() {
            return this.command;
        }

        T getResult() {
            return this.result;
        }
    }

    private static class TxCleanupReadyFutureList {
        final Map<RequestType, Map<OperationId, CompletableFuture<?>>> futures = new EnumMap(RequestType.class);

        private TxCleanupReadyFutureList() {
        }
    }

    private static class FuturesCleanupResult {
        private final boolean hadReadFutures;
        private final boolean hadUpdateFutures;
        private final boolean forceCleanup;

        public FuturesCleanupResult(boolean hadReadFutures, boolean hadUpdateFutures, boolean forceCleanup) {
            this.hadReadFutures = hadReadFutures;
            this.hadUpdateFutures = hadUpdateFutures;
            this.forceCleanup = forceCleanup;
        }

        public boolean hadReadFutures() {
            return this.hadReadFutures;
        }

        public boolean hadUpdateFutures() {
            return this.hadUpdateFutures;
        }

        public boolean forceCleanup() {
            return this.forceCleanup;
        }
    }
}

