/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.sql.SqlAccessEnum;

public class SqlAccessType {
    public static final SqlAccessType ALL = new SqlAccessType(EnumSet.allOf(SqlAccessEnum.class));
    public static final SqlAccessType READ_ONLY = new SqlAccessType(EnumSet.of(SqlAccessEnum.SELECT));
    public static final SqlAccessType WRITE_ONLY = new SqlAccessType(EnumSet.of(SqlAccessEnum.INSERT));
    private final EnumSet<SqlAccessEnum> accessEnums;

    public SqlAccessType(EnumSet<SqlAccessEnum> accessEnums) {
        this.accessEnums = accessEnums;
    }

    public boolean allowsAccess(SqlAccessEnum access) {
        return this.accessEnums.contains((Object)access);
    }

    public String toString() {
        return this.accessEnums.toString();
    }

    public static SqlAccessType create(String[] accessNames) {
        EnumSet<SqlAccessEnum> enumSet = EnumSet.noneOf(SqlAccessEnum.class);
        for (String accessName : Objects.requireNonNull(accessNames, "accessNames")) {
            enumSet.add(SqlAccessEnum.valueOf(accessName.trim().toUpperCase(Locale.ROOT)));
        }
        return new SqlAccessType(enumSet);
    }

    public static SqlAccessType create(String accessString) {
        return SqlAccessType.create(Objects.requireNonNull(accessString, "accessString").replace('[', ' ').replace(']', ' ').split(","));
    }
}

