/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot.local;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.storage.FileService;
import org.apache.ignite.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotMetaTable;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotStorage;
import org.apache.ignite.raft.jraft.storage.snapshot.local.SnapshotFileReader;
import org.apache.ignite.raft.jraft.util.OnlyForTest;
import org.apache.ignite.raft.jraft.util.Utils;

public class LocalSnapshotReader
extends SnapshotReader {
    private static final IgniteLogger LOG = Loggers.forClass(LocalSnapshotReader.class);
    private long readerId;
    private final PeerId peerId;
    private final LocalSnapshotMetaTable metaTable;
    private final String path;
    private final LocalSnapshotStorage snapshotStorage;
    private final SnapshotThrottle snapshotThrottle;

    @Override
    public void close() throws IOException {
        this.snapshotStorage.unref(this.getSnapshotIndex());
        this.destroyReaderInFileService();
    }

    public LocalSnapshotReader(LocalSnapshotStorage snapshotStorage, SnapshotThrottle snapshotThrottle, PeerId peerId, RaftOptions raftOptions, String path) {
        this.snapshotStorage = snapshotStorage;
        this.snapshotThrottle = snapshotThrottle;
        this.peerId = peerId;
        this.path = path;
        this.readerId = 0L;
        this.metaTable = new LocalSnapshotMetaTable(raftOptions);
    }

    @OnlyForTest
    long getReaderId() {
        return this.readerId;
    }

    @Override
    public boolean init(Void v) {
        File dir = new File(this.path);
        if (!dir.exists()) {
            LOG.error("No such path {} for snapshot reader.", new Object[]{this.path});
            this.setError(RaftError.ENOENT, "No such path %s for snapshot reader", this.path);
            return false;
        }
        String metaPath = this.path + File.separator + "__raft_snapshot_meta";
        try {
            return this.metaTable.loadFromFile(metaPath);
        }
        catch (IOException e) {
            LOG.error("Fail to load snapshot meta {}.", new Object[]{metaPath, e});
            this.setError(RaftError.EIO, "Fail to load snapshot meta from path %s", metaPath);
            return false;
        }
    }

    private long getSnapshotIndex() {
        File file = new File(this.path);
        String name = file.getName();
        if (!name.startsWith("snapshot_")) {
            throw new IllegalStateException("Invalid snapshot path name:" + name);
        }
        return Long.parseLong(name.substring("snapshot_".length()));
    }

    @Override
    public void shutdown() {
        Utils.closeQuietly(this);
    }

    @Override
    public RaftOutter.SnapshotMeta load() {
        if (this.metaTable.hasMeta()) {
            return this.metaTable.getMeta();
        }
        return null;
    }

    @Override
    public String generateURIForCopy() {
        if (this.peerId == null || this.peerId.isEmpty()) {
            LOG.error("Peer ID is not specified", new Object[0]);
            return null;
        }
        if (this.readerId == 0L) {
            SnapshotFileReader reader = new SnapshotFileReader(this.path, this.snapshotThrottle);
            reader.setMetaTable(this.metaTable);
            if (!reader.open()) {
                LOG.error("Open snapshot {} failed.", new Object[]{this.path});
                return null;
            }
            this.readerId = FileService.getInstance().addReader(reader);
            if (this.readerId < 0L) {
                LOG.error("Fail to add reader to file_service.", new Object[0]);
                return null;
            }
        }
        return String.format("remote://%s/%d", this.peerId, this.readerId);
    }

    private void destroyReaderInFileService() {
        if (this.readerId > 0L) {
            FileService.getInstance().removeReader(this.readerId);
            this.readerId = 0L;
        } else if (this.readerId != 0L) {
            LOG.warn("Ignore destroy invalid readerId: {}", new Object[]{this.readerId});
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Set<String> listFiles() {
        return this.metaTable.listFiles();
    }

    @Override
    public Message getFileMeta(String fileName) {
        return this.metaTable.getFileMeta(fileName);
    }
}

