/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.Objects;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class ColumnParams {
    public static final String ERR_COL_PARAM_NOT_APPLICABLE = "{} is not applicable for column '{}' of type '{}'";
    public static final String ERR_COL_PARAM_VALIDATION = "{} for column '{}' of type '{}' must be non-negative";
    public static final String ERR_COL_PARAM_DEFINITION = "{} definition is necessary for column '{}' of type '{}'";
    public static final String ERR_COL_POSITIVE_PARAM_VALIDATION = "{} for column '{}' of type '{}' must be at least 1";
    private String name;
    private ColumnType type;
    private boolean nullable;
    @Nullable
    private Integer length;
    @Nullable
    private Integer precision;
    @Nullable
    private Integer scale;
    private DefaultValue defaultValueDefinition = DefaultValue.constant(null);

    public static Builder builder() {
        return new Builder();
    }

    private ColumnParams() {
    }

    public String name() {
        return this.name;
    }

    public ColumnType type() {
        return this.type;
    }

    public <T extends DefaultValue> T defaultValueDefinition() {
        return (T)this.defaultValueDefinition;
    }

    public boolean nullable() {
        return this.nullable;
    }

    @Nullable
    public Integer precision() {
        return this.precision;
    }

    @Nullable
    public Integer scale() {
        return this.scale;
    }

    @Nullable
    public Integer length() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnParams that = (ColumnParams)o;
        return this.nullable == that.nullable && Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.length, that.length) && Objects.equals(this.precision, that.precision) && Objects.equals(this.scale, that.scale) && Objects.equals(this.defaultValueDefinition, that.defaultValueDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.nullable, this.length, this.precision, this.scale, this.defaultValueDefinition);
    }

    public static class Builder {
        private ColumnParams params = new ColumnParams();

        private Builder() {
        }

        public Builder name(String name) {
            this.params.name = name;
            return this;
        }

        public Builder type(ColumnType type) {
            this.params.type = type;
            return this;
        }

        public Builder nullable(boolean nullable) {
            this.params.nullable = nullable;
            return this;
        }

        public Builder defaultValue(DefaultValue defaultValue) {
            this.params.defaultValueDefinition = defaultValue;
            return this;
        }

        public Builder precision(@Nullable Integer precision) {
            this.params.precision = precision;
            return this;
        }

        public Builder scale(@Nullable Integer scale) {
            this.params.scale = scale;
            return this;
        }

        public Builder length(@Nullable Integer length) {
            this.params.length = length;
            return this;
        }

        public ColumnParams build() {
            this.validate();
            ColumnParams params0 = this.params;
            this.params = null;
            return params0;
        }

        private void validate() {
            CatalogParamsValidationUtils.validateIdentifier(this.params.name(), "Column name");
            if (this.params.type == null) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Type is not specified for column '{}'", (Object[])new Object[]{this.params.name()}));
            }
            if (this.params.type == ColumnType.NULL) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Type NULL is not applicable for column '{}'", (Object[])new Object[]{this.params.name()}));
            }
            boolean validatePrecision = this.params.type.precisionAllowed();
            boolean validateScale = this.params.type.scaleAllowed();
            boolean validateLength = this.params.type.lengthAllowed();
            Integer length = this.params.length();
            if (validateLength) {
                if (length == null) {
                    throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_DEFINITION, (Object[])new Object[]{"Length", this.params.name(), this.params.type()}));
                }
                if (length < 1) {
                    throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_POSITIVE_PARAM_VALIDATION, (Object[])new Object[]{"Length", this.params.name(), this.params.type()}));
                }
            } else if (this.params.length() != null) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, (Object[])new Object[]{"Length", this.params.name(), this.params.type()}));
            }
            if (validatePrecision) {
                Builder.validatePrecision(this.params);
                if (this.params.scale() != null && !validateScale) {
                    throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, (Object[])new Object[]{"Scale", this.params.name(), this.params.type()}));
                }
            }
            if (validateScale) {
                Builder.validateScale(this.params);
            }
            if (!validatePrecision && !validateScale) {
                if (this.params.precision() != null) {
                    throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, (Object[])new Object[]{"Precision", this.params.name(), this.params.type()}));
                }
                if (this.params.scale() != null) {
                    throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_NOT_APPLICABLE, (Object[])new Object[]{"Scale", this.params.name(), this.params.type()}));
                }
            }
        }

        private static void validatePrecision(ColumnParams params) {
            Integer precision = params.precision();
            if (precision == null) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_DEFINITION, (Object[])new Object[]{"Precision", params.name(), params.type()}));
            }
            if (precision < 0) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_VALIDATION, (Object[])new Object[]{"Precision", params.name(), params.type()}));
            }
        }

        private static void validateScale(ColumnParams params) {
            Integer scale = params.scale();
            if (scale == null) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_DEFINITION, (Object[])new Object[]{"Scale", params.name(), params.type()}));
            }
            if (scale < 0) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)ColumnParams.ERR_COL_PARAM_VALIDATION, (Object[])new Object[]{"Scale", params.name(), params.type()}));
            }
        }
    }
}

