/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorageManager;
import org.apache.ignite.internal.cluster.management.raft.ValidationResult;
import org.apache.ignite.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.properties.IgniteProductVersion;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class ValidationManager {
    protected final ClusterStateStorageManager storageManager;
    protected final LogicalTopology logicalTopology;

    public ValidationManager(ClusterStateStorageManager storageManager, LogicalTopology logicalTopology) {
        this.storageManager = storageManager;
        this.logicalTopology = logicalTopology;
    }

    static ValidationResult validateState(ClusterState state, ClusterNode node, ClusterState nodeState) {
        if (!state.cmgNodes().equals(nodeState.cmgNodes())) {
            return ValidationResult.errorResult(String.format("CMG node names do not match. CMG nodes: %s, nodes stored in CMG: %s", nodeState.cmgNodes(), state.cmgNodes()));
        }
        if (!state.metaStorageNodes().equals(nodeState.metaStorageNodes())) {
            return ValidationResult.errorResult(String.format("MetaStorage node names do not match. MetaStorage nodes: %s, nodes stored in CMG: %s", nodeState.metaStorageNodes(), state.metaStorageNodes()));
        }
        if (!state.igniteVersion().equals((Object)nodeState.igniteVersion())) {
            return ValidationResult.errorResult(String.format("Ignite versions do not match. Version: %s, version stored in CMG: %s", nodeState.igniteVersion(), state.igniteVersion()));
        }
        if (!state.clusterTag().clusterName().equals(nodeState.clusterTag().clusterName())) {
            return ValidationResult.errorResult(String.format("Cluster names do not match. Cluster name: %s, cluster name stored in CMG: %s", nodeState.clusterTag().clusterName(), state.clusterTag().clusterName()));
        }
        return ValidationResult.successfulResult();
    }

    protected ValidationResult validateNode(@Nullable ClusterState state, LogicalNode node, IgniteProductVersion version, ClusterTag clusterTag) {
        if (this.isNodeValidated(node)) {
            return ValidationResult.successfulResult();
        }
        if (state == null) {
            return ValidationResult.errorResult("Cluster has not been initialized yet");
        }
        if (!state.igniteVersion().equals((Object)version)) {
            return ValidationResult.errorResult(String.format("Ignite versions do not match. Version: %s, version stored in CMG: %s", version, state.igniteVersion()));
        }
        if (!state.clusterTag().equals(clusterTag)) {
            return ValidationResult.errorResult(String.format("Cluster tags do not match. Cluster tag: %s, cluster tag stored in CMG: %s", clusterTag, state.clusterTag()));
        }
        this.putValidatedNode(node);
        return ValidationResult.successfulResult();
    }

    boolean isNodeValidated(LogicalNode node) {
        return this.storageManager.isNodeValidated(node) || this.logicalTopology.isNodeInLogicalTopology(node);
    }

    void putValidatedNode(LogicalNode node) {
        this.storageManager.putValidatedNode(node);
        this.logicalTopology.onNodeValidated(node);
    }

    void removeValidatedNodes(Collection<LogicalNode> nodes) {
        Set validatedNodeIds = this.storageManager.getValidatedNodes().stream().map(ClusterNode::id).collect(Collectors.toSet());
        nodes.stream().filter(node -> validatedNodeIds.contains(node.id())).sorted(Comparator.comparing(ClusterNode::id)).forEach(node -> {
            this.storageManager.removeValidatedNode((LogicalNode)((Object)node));
            this.logicalTopology.onNodeInvalidated((LogicalNode)((Object)node));
        });
    }

    protected ValidationResult completeValidation(LogicalNode node) {
        this.storageManager.getValidatedNodes().stream().filter(n -> n.name().equals(node.name()) && !n.id().equals(node.id())).sorted(Comparator.comparing(ClusterNode::id)).forEach(nodeVersion -> {
            this.storageManager.removeValidatedNode((LogicalNode)((Object)nodeVersion));
            this.logicalTopology.onNodeInvalidated((LogicalNode)((Object)nodeVersion));
        });
        this.storageManager.removeValidatedNode(node);
        return ValidationResult.successfulResult();
    }
}

