/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMetaBuilder;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMetaSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class PartitionSnapshotMetaImpl
implements PartitionSnapshotMeta,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 27;
    @IgniteToStringInclude
    private final long lastIncludedIndex;
    @IgniteToStringInclude
    private final long lastIncludedTerm;
    @IgniteToStringInclude
    private final Collection<String> learnersList;
    @IgniteToStringInclude
    private final long leaseStartTime;
    @IgniteToStringInclude
    private final Map<Integer, UUID> nextRowIdToBuildByIndexId;
    @IgniteToStringInclude
    private final Collection<String> oldLearnersList;
    @IgniteToStringInclude
    private final Collection<String> oldPeersList;
    @IgniteToStringInclude
    private final Collection<String> peersList;
    @IgniteToStringInclude
    private final UUID primaryReplicaNodeId;
    @IgniteToStringInclude
    private final String primaryReplicaNodeName;
    @IgniteToStringInclude
    private final int requiredCatalogVersion;

    private PartitionSnapshotMetaImpl(long lastIncludedIndex, long lastIncludedTerm, Collection<String> learnersList, long leaseStartTime, Map<Integer, UUID> nextRowIdToBuildByIndexId, Collection<String> oldLearnersList, Collection<String> oldPeersList, Collection<String> peersList, UUID primaryReplicaNodeId, String primaryReplicaNodeName, int requiredCatalogVersion) {
        this.lastIncludedIndex = lastIncludedIndex;
        this.lastIncludedTerm = lastIncludedTerm;
        this.learnersList = learnersList;
        this.leaseStartTime = leaseStartTime;
        this.nextRowIdToBuildByIndexId = nextRowIdToBuildByIndexId;
        this.oldLearnersList = oldLearnersList;
        this.oldPeersList = oldPeersList;
        this.peersList = peersList;
        this.primaryReplicaNodeId = primaryReplicaNodeId;
        this.primaryReplicaNodeName = primaryReplicaNodeName;
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    public long lastIncludedIndex() {
        return this.lastIncludedIndex;
    }

    public long lastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    public Collection<String> learnersList() {
        return this.learnersList;
    }

    @Override
    public long leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    public Map<Integer, UUID> nextRowIdToBuildByIndexId() {
        return this.nextRowIdToBuildByIndexId;
    }

    public Collection<String> oldLearnersList() {
        return this.oldLearnersList;
    }

    public Collection<String> oldPeersList() {
        return this.oldPeersList;
    }

    public Collection<String> peersList() {
        return this.peersList;
    }

    @Override
    public UUID primaryReplicaNodeId() {
        return this.primaryReplicaNodeId;
    }

    @Override
    public String primaryReplicaNodeName() {
        return this.primaryReplicaNodeName;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    public MessageSerializer serializer() {
        return PartitionSnapshotMetaSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(PartitionSnapshotMetaImpl.class, (Object)this);
    }

    public short messageType() {
        return 27;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PartitionSnapshotMetaImpl otherMessage = (PartitionSnapshotMetaImpl)other;
        return Objects.equals(this.learnersList, otherMessage.learnersList) && Objects.equals(this.nextRowIdToBuildByIndexId, otherMessage.nextRowIdToBuildByIndexId) && Objects.equals(this.oldLearnersList, otherMessage.oldLearnersList) && Objects.equals(this.oldPeersList, otherMessage.oldPeersList) && Objects.equals(this.peersList, otherMessage.peersList) && Objects.equals(this.primaryReplicaNodeId, otherMessage.primaryReplicaNodeId) && Objects.equals(this.primaryReplicaNodeName, otherMessage.primaryReplicaNodeName) && this.lastIncludedIndex == otherMessage.lastIncludedIndex && this.lastIncludedTerm == otherMessage.lastIncludedTerm && this.leaseStartTime == otherMessage.leaseStartTime && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.lastIncludedIndex, this.lastIncludedTerm, this.leaseStartTime, this.requiredCatalogVersion, this.learnersList, this.nextRowIdToBuildByIndexId, this.oldLearnersList, this.oldPeersList, this.peersList, this.primaryReplicaNodeId, this.primaryReplicaNodeName);
        return result;
    }

    public PartitionSnapshotMetaImpl clone() {
        try {
            return (PartitionSnapshotMetaImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PartitionSnapshotMetaBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements PartitionSnapshotMetaBuilder {
        private long lastIncludedIndex;
        private long lastIncludedTerm;
        private Collection<String> learnersList;
        private long leaseStartTime;
        private Map<Integer, UUID> nextRowIdToBuildByIndexId;
        private Collection<String> oldLearnersList;
        private Collection<String> oldPeersList;
        private Collection<String> peersList;
        private UUID primaryReplicaNodeId;
        private String primaryReplicaNodeName;
        private int requiredCatalogVersion;

        private Builder() {
        }

        @Override
        public PartitionSnapshotMetaBuilder lastIncludedIndex(long lastIncludedIndex) {
            this.lastIncludedIndex = lastIncludedIndex;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder lastIncludedTerm(long lastIncludedTerm) {
            this.lastIncludedTerm = lastIncludedTerm;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder learnersList(Collection<String> learnersList) {
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder leaseStartTime(long leaseStartTime) {
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder nextRowIdToBuildByIndexId(Map<Integer, UUID> nextRowIdToBuildByIndexId) {
            this.nextRowIdToBuildByIndexId = nextRowIdToBuildByIndexId;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder oldLearnersList(Collection<String> oldLearnersList) {
            this.oldLearnersList = oldLearnersList;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder oldPeersList(Collection<String> oldPeersList) {
            this.oldPeersList = oldPeersList;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder peersList(Collection<String> peersList) {
            this.peersList = peersList;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder primaryReplicaNodeId(UUID primaryReplicaNodeId) {
            this.primaryReplicaNodeId = primaryReplicaNodeId;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder primaryReplicaNodeName(String primaryReplicaNodeName) {
            this.primaryReplicaNodeName = primaryReplicaNodeName;
            return this;
        }

        @Override
        public PartitionSnapshotMetaBuilder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public long lastIncludedIndex() {
            return this.lastIncludedIndex;
        }

        @Override
        public long lastIncludedTerm() {
            return this.lastIncludedTerm;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public long leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public Map<Integer, UUID> nextRowIdToBuildByIndexId() {
            return this.nextRowIdToBuildByIndexId;
        }

        @Override
        public Collection<String> oldLearnersList() {
            return this.oldLearnersList;
        }

        @Override
        public Collection<String> oldPeersList() {
            return this.oldPeersList;
        }

        @Override
        public Collection<String> peersList() {
            return this.peersList;
        }

        @Override
        public UUID primaryReplicaNodeId() {
            return this.primaryReplicaNodeId;
        }

        @Override
        public String primaryReplicaNodeName() {
            return this.primaryReplicaNodeName;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public PartitionSnapshotMeta build() {
            return new PartitionSnapshotMetaImpl(this.lastIncludedIndex, this.lastIncludedTerm, this.learnersList, this.leaseStartTime, this.nextRowIdToBuildByIndexId, this.oldLearnersList, this.oldPeersList, this.peersList, this.primaryReplicaNodeId, this.primaryReplicaNodeName, this.requiredCatalogVersion);
        }
    }
}

