/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binarytuple;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class BinaryTupleReader
extends BinaryTupleParser
implements BinaryTupleParser.Sink {
    private int begin = 0;
    private int end = 0;

    public BinaryTupleReader(int numElements, byte[] bytes) {
        this(numElements, ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
    }

    public BinaryTupleReader(int numElements, ByteBuffer buffer) {
        super(numElements, buffer);
    }

    @Override
    public final void nextElement(int index, int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public boolean hasNullValue(int index) {
        this.seek(index);
        return this.begin == this.end;
    }

    public boolean booleanValue(int index) {
        this.seek(index);
        return this.booleanValue(this.begin, this.end);
    }

    @Nullable
    public Boolean booleanValueBoxed(int index) {
        this.seek(index);
        if (this.begin == this.end) {
            return null;
        }
        return this.booleanValue(this.begin, this.end);
    }

    public byte byteValue(int index) {
        this.seek(index);
        return this.byteValue(this.begin, this.end);
    }

    @Nullable
    public Byte byteValueBoxed(int index) {
        this.seek(index);
        return this.begin == this.end ? null : Byte.valueOf(this.byteValue(this.begin, this.end));
    }

    public short shortValue(int index) {
        this.seek(index);
        return this.shortValue(this.begin, this.end);
    }

    @Nullable
    public Short shortValueBoxed(int index) {
        this.seek(index);
        return this.begin == this.end ? null : Short.valueOf(this.shortValue(this.begin, this.end));
    }

    public int intValue(int index) {
        this.seek(index);
        return this.intValue(this.begin, this.end);
    }

    @Nullable
    public Integer intValueBoxed(int index) {
        this.seek(index);
        return this.begin == this.end ? null : Integer.valueOf(this.intValue(this.begin, this.end));
    }

    public long longValue(int index) {
        this.seek(index);
        return this.longValue(this.begin, this.end);
    }

    @Nullable
    public Long longValueBoxed(int index) {
        this.seek(index);
        return this.begin == this.end ? null : Long.valueOf(this.longValue(this.begin, this.end));
    }

    public float floatValue(int index) {
        this.seek(index);
        return this.floatValue(this.begin, this.end);
    }

    @Nullable
    public Float floatValueBoxed(int index) {
        this.seek(index);
        return this.begin == this.end ? null : Float.valueOf(this.floatValue(this.begin, this.end));
    }

    public double doubleValue(int index) {
        this.seek(index);
        return this.doubleValue(this.begin, this.end);
    }

    @Nullable
    public Double doubleValueBoxed(int index) {
        this.seek(index);
        return this.begin == this.end ? null : Double.valueOf(this.doubleValue(this.begin, this.end));
    }

    @Nullable
    public BigDecimal decimalValue(int index, int scale) {
        this.seek(index);
        if (this.begin == this.end) {
            return null;
        }
        short valScale = this.shortValue(this.begin, this.begin + 2);
        BigDecimal decimalValue = new BigDecimal(this.numberValue(this.begin + 2, this.end), valScale);
        return scale < 0 ? decimalValue : decimalValue.setScale(scale, RoundingMode.UNNECESSARY);
    }

    @Nullable
    public String stringValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.stringValue(this.begin, this.end);
    }

    public byte @Nullable [] bytesValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.bytesValue(this.begin, this.end);
    }

    @Nullable
    public ByteBuffer bytesValueAsBuffer(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.bytesValueAsBuffer(this.begin, this.end);
    }

    @Nullable
    public UUID uuidValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.uuidValue(this.begin, this.end);
    }

    @Nullable
    public LocalDate dateValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.dateValue(this.begin, this.end);
    }

    @Nullable
    public LocalTime timeValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.timeValue(this.begin, this.end);
    }

    @Nullable
    public LocalDateTime dateTimeValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.dateTimeValue(this.begin, this.end);
    }

    @Nullable
    public Instant timestampValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.timestampValue(this.begin, this.end);
    }

    @Nullable
    public Duration durationValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.durationValue(this.begin, this.end);
    }

    @Nullable
    public Period periodValue(int index) {
        this.seek(index);
        return this.begin == this.end ? null : this.periodValue(this.begin, this.end);
    }

    public int begin() {
        return this.begin;
    }

    public int end() {
        return this.end;
    }

    public void seek(int index) {
        this.fetch(index, this);
    }
}

