/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class IgniteAbbrevationsRule
extends AbstractCheck {
    public static final String ABBREVS_FILE = "/abbrevations.csv";
    public static final String ABBREVS_EXCL_FILE = "/abbrevations-exclude.txt";
    public static final char DELIM = ',';
    private static final int[] TOKENS = new int[]{10, 198};
    private static final Map<String, String> ABBREVS = new HashMap<String, String>();
    private static final Set<String> EXCL = new HashSet<String>();

    public void visitToken(DetailAST ast) {
        DetailAST parent = ast.getParent();
        if (parent.getType() == 6) {
            return;
        }
        DetailAST token = ast.findFirstToken(58);
        String varName = token.getText();
        if (EXCL.contains(varName)) {
            return;
        }
        List<String> words = IgniteAbbrevationsRule.words(varName);
        for (String word : words) {
            if (!ABBREVS.containsKey(word.toLowerCase())) continue;
            this.log(token.getLineNo(), "Abbrevation should be used for {0}! Please, use {1}, instead of {2}", new Object[]{varName, ABBREVS.get(word.toLowerCase()), word});
        }
    }

    public static List<String> words(String varName) {
        if (varName.indexOf(95) != -1) {
            return Arrays.asList(varName.split("_"));
        }
        ArrayList<String> words = new ArrayList<String>();
        int start = 0;
        boolean allUpper = Character.isUpperCase(varName.charAt(0));
        for (int i = 1; i < varName.length(); ++i) {
            if (Character.isUpperCase(varName.charAt(i))) {
                if (allUpper) continue;
                words.add(varName.substring(start, i));
                start = i;
                allUpper = true;
                continue;
            }
            allUpper = false;
        }
        words.add(varName.substring(start));
        return words;
    }

    public int[] getDefaultTokens() {
        return (int[])TOKENS.clone();
    }

    public int[] getAcceptableTokens() {
        return (int[])TOKENS.clone();
    }

    public int[] getRequiredTokens() {
        return (int[])TOKENS.clone();
    }

    private static void forEachLine(String file, Consumer<String> lineProc) {
        InputStream stream = IgniteAbbrevationsRule.class.getResourceAsStream(file);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                lineProc.accept(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        IgniteAbbrevationsRule.forEachLine(ABBREVS_FILE, line -> {
            line = line.toLowerCase();
            int firstDelim = line.indexOf(44);
            assert (firstDelim > 0);
            String term = line.substring(0, firstDelim);
            CharSequence[] substitutions = line.substring(firstDelim + 1).split(",");
            assert (substitutions.length > 0);
            ABBREVS.put(term, String.join((CharSequence)", ", substitutions));
        });
        IgniteAbbrevationsRule.forEachLine(ABBREVS_EXCL_FILE, EXCL::add);
    }
}

