/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.tx;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.odbc.ClientTxSupport;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientIntResponse;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class ClientTxStartRequest
extends ClientRequest
implements ClientTxSupport {
    private final TransactionConcurrency concurrency;
    private final TransactionIsolation isolation;
    private final long timeout;
    private final String lb;

    public ClientTxStartRequest(BinaryRawReader reader) {
        super(reader);
        this.concurrency = TransactionConcurrency.fromOrdinal(reader.readByte());
        this.isolation = TransactionIsolation.fromOrdinal(reader.readByte());
        this.timeout = reader.readLong();
        this.lb = reader.readString();
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        return new ClientIntResponse(this.requestId(), this.startClientTransaction(ctx, this.concurrency, this.isolation, this.timeout, this.lb));
    }

    @Override
    public RuntimeException startTxException(Exception e) {
        return e instanceof IgniteClientException ? (IgniteClientException)e : new IgniteClientException(1, e.getMessage(), e);
    }
}

