/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.task;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupEmptyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.client.message.GridClientTaskResultBean;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.handlers.task.GridTaskResultRequest;
import org.apache.ignite.internal.processors.rest.handlers.task.GridTaskResultResponse;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTaskRequest;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.util.VisorClusterGroupEmptyException;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridTaskCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.EXE, GridRestCommand.RESULT, GridRestCommand.NOOP);
    public static final int DFLT_MAX_TASK_RESULTS = 10240;
    private final int maxTaskResults = IgniteSystemProperties.getInteger("IGNITE_REST_MAX_TASK_RESULTS", 10240);
    private final Map<IgniteUuid, TaskDescriptor> taskDescs = new GridBoundedConcurrentLinkedHashMap<IgniteUuid, TaskDescriptor>(this.maxTaskResults, 16, 0.75f, 4, ConcurrentLinkedHashMap.QueuePolicy.PER_SEGMENT_Q);
    private final AtomicLong topicIdGen = new AtomicLong();

    public GridTaskCommandHandler(final GridKernalContext ctx) {
        super(ctx);
        ctx.io().addMessageListener(GridTopic.TOPIC_REST, new GridMessageListener(){

            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (!(msg instanceof GridTaskResultRequest)) {
                    U.warn(GridTaskCommandHandler.this.log, "Received unexpected message instead of task result request: " + msg);
                    return;
                }
                try {
                    GridTaskResultRequest req = (GridTaskResultRequest)msg;
                    GridTaskResultResponse res = new GridTaskResultResponse();
                    IgniteUuid taskId = req.taskId();
                    TaskDescriptor desc = GridTaskCommandHandler.this.taskDescs.get(taskId);
                    if (desc != null) {
                        res.found(true);
                        res.finished(desc.finished());
                        Throwable err = desc.error();
                        if (err != null) {
                            res.error(err.getMessage());
                        } else {
                            res.result(desc.result());
                            res.resultBytes(U.marshal(ctx, desc.result()));
                        }
                    } else {
                        res.found(false);
                    }
                    Object topic = U.unmarshal(ctx, req.topicBytes(), U.resolveClassLoader(ctx.config()));
                    ctx.io().sendToCustomTopic(nodeId, topic, (Message)res, (byte)2);
                }
                catch (IgniteCheckedException e) {
                    U.error(GridTaskCommandHandler.this.log, "Failed to send job task result response.", e);
                }
            }
        });
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        try {
            IgniteInternalFuture<GridRestResponse> igniteInternalFuture = this.handleAsyncUnsafe(req);
            return igniteInternalFuture;
        }
        catch (IgniteCheckedException e) {
            if (!X.hasCause((Throwable)e, VisorClusterGroupEmptyException.class)) {
                U.error(this.log, "Failed to execute task command: " + req, e);
            }
            GridFinishedFuture<GridRestResponse> gridFinishedFuture = new GridFinishedFuture<GridRestResponse>(e);
            return gridFinishedFuture;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Handled task REST request: " + req);
            }
        }
    }

    private IgniteInternalFuture<GridRestResponse> handleAsyncUnsafe(final GridRestRequest req) throws IgniteCheckedException {
        assert (req instanceof GridRestTaskRequest) : "Invalid command for topology handler: " + req;
        assert (SUPPORTED_COMMANDS.contains((Object)req.command()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling task REST request: " + req);
        }
        GridRestTaskRequest req0 = (GridRestTaskRequest)req;
        final GridFutureAdapter<GridRestResponse> fut = new GridFutureAdapter<GridRestResponse>();
        final GridRestResponse res = new GridRestResponse();
        final GridClientTaskResultBean taskRestRes = new GridClientTaskResultBean();
        taskRestRes.setId("~" + this.ctx.localNodeId().toString());
        final boolean locExec = req0.destinationId() == null || req0.destinationId().equals(this.ctx.localNodeId()) || this.ctx.discovery().node(req0.destinationId()) == null;
        switch (req.command()) {
            case EXE: {
                IgniteInternalFuture<Object> taskFut;
                final boolean async = req0.async();
                final String name = req0.taskName();
                if (F.isEmpty(name)) {
                    throw new IgniteCheckedException(GridTaskCommandHandler.missingParameter("name"));
                }
                List<Object> params = req0.params();
                long timeout = req0.timeout();
                if (locExec) {
                    Object[] arg = !F.isEmpty(params) ? (params.size() == 1 ? params.get(0) : params.toArray()) : null;
                    taskFut = this.ctx.task().execute(name, arg, TaskExecutionOptions.options().asPublicRequest().withTimeout(timeout));
                } else {
                    ClusterGroup prj = this.ctx.grid().cluster().forPredicate(F.nodeForNodeId(req.destinationId()));
                    taskFut = this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, new ExeCallable(name, params, timeout), TaskExecutionOptions.options(prj.nodes()).withFailoverDisabled());
                }
                if (async) {
                    if (locExec) {
                        IgniteUuid tid = taskFut.getTaskSession().getId();
                        this.taskDescs.put(tid, new TaskDescriptor(false, null, null));
                        taskRestRes.setId(tid.toString() + "~" + this.ctx.localNodeId().toString());
                        res.setResponse(taskRestRes);
                    } else {
                        res.setError("Asynchronous task execution is not supported for routing request.");
                    }
                    fut.onDone(res);
                }
                taskFut.listen(new IgniteInClosure<IgniteInternalFuture<Object>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void apply(IgniteInternalFuture<Object> taskFut) {
                        try {
                            TaskDescriptor desc;
                            try {
                                desc = new TaskDescriptor(true, taskFut.get(), null);
                            }
                            catch (IgniteCheckedException e) {
                                if (e.hasCause(ClusterTopologyCheckedException.class, ClusterGroupEmptyCheckedException.class)) {
                                    U.warn(GridTaskCommandHandler.this.log, "Failed to execute task due to topology issues (are all mapped nodes alive?) [name=" + name + ", clientId=" + req.clientId() + ", err=" + e + "]");
                                } else if (!X.hasCause((Throwable)e, VisorClusterGroupEmptyException.class)) {
                                    U.error(GridTaskCommandHandler.this.log, "Failed to execute task [name=" + name + ", clientId=" + req.clientId() + "]", e);
                                }
                                desc = new TaskDescriptor(true, null, e);
                            }
                            if (async && locExec) {
                                assert (taskFut instanceof ComputeTaskInternalFuture);
                                IgniteUuid tid = ((ComputeTaskInternalFuture)taskFut).getTaskSession().getId();
                                GridTaskCommandHandler.this.taskDescs.put(tid, desc);
                            }
                            if (!async) {
                                if (desc.error() == null) {
                                    try {
                                        taskRestRes.setFinished(true);
                                        taskRestRes.setResult(desc.result());
                                        res.setResponse(taskRestRes);
                                        fut.onDone(res);
                                    }
                                    catch (IgniteException e) {
                                        fut.onDone(new IgniteCheckedException("Failed to marshal task result: " + desc.result(), e));
                                    }
                                } else {
                                    fut.onDone(desc.error());
                                }
                            }
                        }
                        finally {
                            if (!async && !fut.isDone()) {
                                fut.onDone(new IgniteCheckedException("Failed to execute task (see server logs for details)."));
                            }
                        }
                    }
                });
                break;
            }
            case RESULT: {
                String id = req0.taskId();
                if (F.isEmpty(id)) {
                    throw new IgniteCheckedException(GridTaskCommandHandler.missingParameter("id"));
                }
                StringTokenizer st = new StringTokenizer(id, "~");
                if (st.countTokens() != 2) {
                    throw new IgniteCheckedException("Failed to parse id parameter: " + id);
                }
                String tidParam = st.nextToken();
                String resHolderIdParam = st.nextToken();
                taskRestRes.setId(id);
                try {
                    UUID resHolderId;
                    IgniteUuid tid = !F.isEmpty(tidParam) ? IgniteUuid.fromString(tidParam) : null;
                    UUID uUID = resHolderId = !F.isEmpty(resHolderIdParam) ? UUID.fromString(resHolderIdParam) : null;
                    if (tid == null || resHolderId == null) {
                        throw new IgniteCheckedException("Failed to parse id parameter: " + id);
                    }
                    if (this.ctx.localNodeId().equals(resHolderId)) {
                        TaskDescriptor desc = this.taskDescs.get(tid);
                        if (desc == null) {
                            throw new IgniteCheckedException("Task with provided id has never been started on provided node [taskId=" + tidParam + ", taskResHolderId=" + resHolderIdParam + "]");
                        }
                        taskRestRes.setFinished(desc.finished());
                        if (desc.error() != null) {
                            throw new IgniteCheckedException(desc.error().getMessage());
                        }
                        taskRestRes.setResult(desc.result());
                        res.setResponse(taskRestRes);
                    } else {
                        IgniteBiTuple<String, GridTaskResultResponse> t = this.requestTaskResult(resHolderId, tid);
                        if (t.get1() != null) {
                            throw new IgniteCheckedException(t.get1());
                        }
                        GridTaskResultResponse taskRes = t.get2();
                        assert (taskRes != null);
                        if (!taskRes.found()) {
                            throw new IgniteCheckedException("Task with provided id has never been started on provided node [taskId=" + tidParam + ", taskResHolderId=" + resHolderIdParam + "]");
                        }
                        taskRestRes.setFinished(taskRes.finished());
                        if (taskRes.error() != null) {
                            throw new IgniteCheckedException(taskRes.error());
                        }
                        taskRestRes.setResult(taskRes.result());
                        res.setResponse(taskRestRes);
                    }
                }
                catch (IllegalArgumentException e) {
                    String msg = "Failed to parse parameters [taskId=" + tidParam + ", taskResHolderId=" + resHolderIdParam + ", err=" + e.getMessage() + "]";
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(msg);
                    }
                    throw new IgniteCheckedException(msg, e);
                }
                fut.onDone(res);
                break;
            }
            case NOOP: {
                fut.onDone(new GridRestResponse());
                break;
            }
            default: {
                assert (false) : "Invalid command for task handler: " + req;
                break;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handled task REST request [res=" + res + ", req=" + req + "]");
        }
        return fut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private IgniteBiTuple<String, GridTaskResultResponse> requestTaskResult(final UUID resHolderId, IgniteUuid taskId) {
        ClusterNode taskNode = this.ctx.discovery().node(resHolderId);
        if (taskNode == null) {
            return F.t("Task result holder has left grid: " + resHolderId, null);
        }
        final IgniteBiTuple<String, GridTaskResultResponse> t = new IgniteBiTuple<String, GridTaskResultResponse>();
        final ReentrantLock lock = new ReentrantLock();
        final Condition cond = lock.newCondition();
        GridMessageListener msgLsnr = new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                String err = null;
                GridTaskResultResponse res = null;
                if (!(msg instanceof GridTaskResultResponse)) {
                    err = "Received unexpected message: " + msg;
                } else if (!nodeId.equals(resHolderId)) {
                    err = "Received task result response from unexpected node [resHolderId=" + resHolderId + ", nodeId=" + nodeId + "]";
                } else {
                    res = (GridTaskResultResponse)msg;
                }
                try {
                    res.result(U.unmarshal(GridTaskCommandHandler.this.ctx, res.resultBytes(), U.resolveClassLoader(GridTaskCommandHandler.this.ctx.config())));
                }
                catch (IgniteCheckedException e) {
                    U.error(GridTaskCommandHandler.this.log, "Failed to unmarshal task result: " + res, e);
                }
                lock.lock();
                try {
                    if (t.isEmpty()) {
                        t.set(err, res);
                        cond.signalAll();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        };
        GridLocalEventListener discoLsnr = new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof DiscoveryEvent && (evt.type() == 12 || evt.type() == 11)) : "Unexpected event: " + evt;
                DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                if (resHolderId.equals(discoEvt.eventNode().id())) {
                    lock.lock();
                    try {
                        if (t.isEmpty()) {
                            t.set("Node that originated task execution has left grid: " + resHolderId, null);
                            cond.signalAll();
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        };
        Object topic = GridTopic.TOPIC_REST.topic("task-result", this.topicIdGen.getAndIncrement());
        try {
            this.ctx.io().addMessageListener(topic, msgLsnr);
            try {
                byte[] topicBytes = U.marshal(this.ctx, topic);
                this.ctx.io().sendToGridTopic(taskNode, GridTopic.TOPIC_REST, (Message)new GridTaskResultRequest(taskId, topic, topicBytes), (byte)2);
            }
            catch (IgniteCheckedException e) {
                String errMsg = "Failed to send task result request [resHolderId=" + resHolderId + ", err=" + e.getMessage() + "]";
                if (this.log.isDebugEnabled()) {
                    this.log.debug(errMsg);
                }
                IgniteBiTuple<CallSite, Object> igniteBiTuple = F.t(errMsg, null);
                this.ctx.io().removeMessageListener(topic, msgLsnr);
                this.ctx.event().removeLocalEventListener(discoLsnr, new int[0]);
                return igniteBiTuple;
            }
            this.ctx.event().addLocalEventListener(discoLsnr, 12, 11);
            taskNode = this.ctx.discovery().node(resHolderId);
            if (taskNode == null) {
                IgniteBiTuple<CallSite, Object> e = F.t("Task result holder has left grid: " + resHolderId, null);
                return e;
            }
            lock.lock();
            try {
                long netTimeout = this.ctx.config().getNetworkTimeout();
                if (t.isEmpty()) {
                    cond.await(netTimeout, TimeUnit.MILLISECONDS);
                }
                if (t.isEmpty()) {
                    t.set1("Timed out waiting for task result (consider increasing 'networkTimeout' configuration property) [resHolderId=" + resHolderId + ", netTimeout=" + netTimeout + "]");
                }
                IgniteBiTuple<String, GridTaskResultResponse> igniteBiTuple = t;
                lock.unlock();
                return igniteBiTuple;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                IgniteBiTuple<String, Object> igniteBiTuple = F.t("Interrupted while waiting for task result.", null);
                lock.unlock();
                this.ctx.io().removeMessageListener(topic, msgLsnr);
                this.ctx.event().removeLocalEventListener(discoLsnr, new int[0]);
                return igniteBiTuple;
                {
                    catch (Throwable throwable) {
                        lock.unlock();
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.ctx.io().removeMessageListener(topic, msgLsnr);
            this.ctx.event().removeLocalEventListener(discoLsnr, new int[0]);
        }
    }

    public String toString() {
        return S.toString(GridTaskCommandHandler.class, this);
    }

    @GridInternal
    private static class ExeCallable
    implements Callable<Object>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String name;
        private List<Object> params;
        private long timeout;
        @IgniteInstanceResource
        private IgniteEx g;

        public ExeCallable() {
        }

        private ExeCallable(String name, List<Object> params, long timeout) {
            this.name = name;
            this.params = params;
            this.timeout = timeout;
        }

        @Override
        public Object call() throws Exception {
            return this.g.compute().execute(this.name, !this.params.isEmpty() ? (this.params.size() == 1 ? this.params.get(0) : this.params.toArray()) : null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.name);
            out.writeObject(this.params);
            out.writeLong(this.timeout);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = U.readString(in);
            this.params = (List)in.readObject();
            this.timeout = in.readLong();
        }
    }

    private static class TaskDescriptor {
        private final boolean finished;
        private final Object res;
        private final Throwable err;

        private TaskDescriptor(boolean finished, @Nullable Object res, @Nullable Throwable err) {
            this.finished = finished;
            this.res = res;
            this.err = err;
        }

        public boolean finished() {
            return this.finished;
        }

        @Nullable
        public Object result() {
            return this.res;
        }

        @Nullable
        public Throwable error() {
            return this.err;
        }
    }
}

