/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class StatisticsTarget {
    @GridToStringInclude
    private final StatisticsKey key;
    @GridToStringInclude
    private final String[] columns;

    public StatisticsTarget(String schema, String obj, String ... columns) {
        this(new StatisticsKey(schema, obj), columns);
    }

    public StatisticsTarget(StatisticsKey key, String ... columns) {
        this.key = key;
        this.columns = columns == null || columns.length == 0 ? null : columns;
    }

    public String schema() {
        return this.key.schema();
    }

    public String obj() {
        return this.key().obj();
    }

    public String[] columns() {
        return this.columns;
    }

    public StatisticsKey key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticsTarget that = (StatisticsTarget)o;
        return Objects.equals(this.key, that.key) && Arrays.equals(this.columns, that.columns);
    }

    public int hashCode() {
        int result = Objects.hash(this.key);
        result = 31 * result + Arrays.hashCode(this.columns);
        return result;
    }

    public String toString() {
        return S.toString(StatisticsTarget.class, this);
    }
}

