/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;

public abstract class ClientCacheQueryRequest
extends ClientCacheDataRequest {
    ClientCacheQueryRequest(BinaryRawReader reader) {
        super(reader);
    }

    protected void updateAffinityMetrics(ClientConnectionContext ctx, int part) {
        DynamicCacheDescriptor desc = this.cacheDescriptor(ctx);
        CacheConfiguration cfg = desc.cacheConfiguration();
        if (cfg.getCacheMode() == CacheMode.PARTITIONED && cfg.isStatisticsEnabled()) {
            String cacheName = desc.cacheName();
            try {
                GridKernalContext kctx = ctx.kernalContext();
                if (kctx.affinity().mapPartitionToNode(cacheName, part, null).isLocal()) {
                    kctx.clientListener().metrics().onAffinityQryHit();
                } else {
                    kctx.clientListener().metrics().onAffinityQryMiss();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

