/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.platform.PlatformAbstractPredicate;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryFilter;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.resources.IgniteInstanceResource;

public class PlatformCacheEntryFilterImpl
extends PlatformAbstractPredicate
implements PlatformCacheEntryFilter {
    private static final long serialVersionUID = 0L;
    private transient boolean platfromCacheEnabled;

    public PlatformCacheEntryFilterImpl() {
    }

    public PlatformCacheEntryFilterImpl(Object pred, long ptr, PlatformContext ctx) {
        super(pred, ptr, ctx);
        assert (pred != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean apply(Object k, Object v) {
        assert (this.ptr != 0L);
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeLong(this.ptr);
            writer.writeObject(k);
            try {
                boolean bl;
                if (this.platfromCacheEnabled) {
                    writer.writeBoolean(false);
                    this.ctx.kernalContext().platform().setThreadLocal(v);
                } else {
                    writer.writeBoolean(true);
                    writer.writeObject(v);
                }
                out.synchronize();
                boolean bl2 = bl = this.ctx.gateway().cacheEntryFilterApply(mem.pointer()) != 0;
                if (this.platfromCacheEnabled) {
                    this.ctx.kernalContext().platform().setThreadLocal(null);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (this.platfromCacheEnabled) {
                    this.ctx.kernalContext().platform().setThreadLocal(null);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void onClose() {
        if (this.ptr == 0L) {
            return;
        }
        assert (this.ctx != null);
        this.ctx.gateway().cacheEntryFilterDestroy(this.ptr);
        this.ptr = 0L;
    }

    @Override
    public void cacheContext(GridCacheContext cctx) {
        if (this.ptr != 0L) {
            return;
        }
        this.ctx = cctx.kernalContext().platform().context();
        this.platfromCacheEnabled = cctx.config().getPlatformCacheConfiguration() != null && this.ctx.isPlatformCacheSupported();
        this.init(this.platfromCacheEnabled ? Integer.valueOf(cctx.cacheId()) : null);
    }

    @IgniteInstanceResource
    public void setIgniteInstance(Ignite ignite) {
        if (this.ptr != 0L) {
            return;
        }
        this.ctx = PlatformUtils.platformContext(ignite);
        this.init(null);
    }

    private void init(Integer cacheId) {
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObject(this.pred);
            if (cacheId != null) {
                writer.writeBoolean(true);
                writer.writeInt(cacheId);
            } else {
                writer.writeBoolean(false);
            }
            out.synchronize();
            this.ptr = this.ctx.gateway().cacheEntryFilterCreate(mem.pointer());
        }
    }
}

