/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot.dump;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIODecorator;
import org.apache.ignite.internal.util.typedef.internal.A;

public class BufferedFileIO
extends FileIODecorator {
    private static final int DEFAULT_BLOCK_SIZE = 4096;
    private ByteBuffer buf;
    private long position;

    public BufferedFileIO(FileIO fileIO) {
        super(fileIO);
        A.ensure(fileIO != null, "fileIO must not be null");
        int blockSize = this.getFileSystemBlockSize();
        if (blockSize <= 0) {
            blockSize = 4096;
        }
        this.buf = ByteBuffer.allocateDirect(blockSize);
    }

    @Override
    public int writeFully(ByteBuffer srcBuf) throws IOException {
        if (this.buf == null) {
            throw new IOException("FileIO closed");
        }
        int len = srcBuf.remaining();
        this.writeBytes(srcBuf.array(), srcBuf.arrayOffset() + srcBuf.position(), len);
        srcBuf.position(srcBuf.position() + len);
        return len;
    }

    protected void writeBytes(byte[] srcBuf, int off, int len) throws IOException {
        int bytesCnt;
        if (this.buf == null) {
            throw new IOException("FileIO closed");
        }
        if ((len | off) < 0 || len > srcBuf.length - off) {
            throw new IndexOutOfBoundsException("Range [" + off + ", " + off + " + " + len + ") out of bounds for length " + srcBuf.length);
        }
        for (int p = off; p < off + len; p += bytesCnt) {
            bytesCnt = Math.min(this.buf.remaining(), off + len - p);
            this.buf.put(srcBuf, p, bytesCnt);
            if (this.buf.hasRemaining()) continue;
            this.flush();
        }
    }

    protected void writeByte(byte b) throws IOException {
        if (this.buf == null) {
            throw new IOException("FileIO closed");
        }
        this.buf.put(b);
        if (!this.buf.hasRemaining()) {
            this.flush();
        }
    }

    private void flush() throws IOException {
        this.buf.flip();
        int len = this.delegate.writeFully(this.buf, this.position);
        if (len < 0) {
            throw new IOException("Couldn't write data");
        }
        this.position += (long)len;
        this.buf.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.buf == null) {
            return;
        }
        this.flush();
        this.buf = null;
        super.close();
    }
}

