/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridDhtPreloaderAssignments
extends ConcurrentHashMap<ClusterNode, GridDhtPartitionDemandMessage> {
    private static final long serialVersionUID = 0L;
    private final GridDhtPartitionExchangeId exchangeId;
    private final AffinityTopologyVersion topVer;
    private boolean cancelled;
    private final boolean affinityReassign;

    public GridDhtPreloaderAssignments(GridDhtPartitionExchangeId exchangeId, AffinityTopologyVersion topVer, boolean affinityReassign) {
        assert (exchangeId != null);
        assert (topVer.topologyVersion() > 0L) : topVer;
        this.exchangeId = exchangeId;
        this.topVer = topVer;
        this.affinityReassign = affinityReassign;
    }

    public boolean affinityReassign() {
        return this.affinityReassign;
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public void cancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    GridDhtPartitionExchangeId exchangeId() {
        return this.exchangeId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPreloaderAssignments.class, this, "super", (Object)super.toString());
    }

    public void retainMoving(GridDhtPartitionTopology top) {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            IgniteDhtDemandedPartitionsMap newMap;
            Map.Entry mapping = it.next();
            GridDhtPartitionDemandMessage val = (GridDhtPartitionDemandMessage)mapping.getValue();
            IgniteDhtDemandedPartitionsMap cntrMap = val.partitions();
            CachePartitionPartialCountersMap curHistMap = cntrMap.historicalMap();
            CachePartitionPartialCountersMap newHistMap = null;
            if (!curHistMap.isEmpty()) {
                int partId;
                int i;
                int moving = 0;
                for (i = 0; i < curHistMap.size(); ++i) {
                    partId = curHistMap.partitionAt(i);
                    if (top.localPartition(partId).state() != GridDhtPartitionState.MOVING) continue;
                    ++moving;
                }
                if (moving != curHistMap.size()) {
                    newHistMap = new CachePartitionPartialCountersMap(moving);
                    for (i = 0; i < curHistMap.size(); ++i) {
                        partId = curHistMap.partitionAt(i);
                        long initUpdCntr = curHistMap.initialUpdateCounterAt(i);
                        long updCntr = curHistMap.updateCounterAt(i);
                        if (top.localPartition(partId).state() != GridDhtPartitionState.MOVING) continue;
                        newHistMap.add(partId, initUpdCntr, updCntr);
                    }
                }
            }
            Set<Integer> curFullSet = cntrMap.fullSet();
            Set<Integer> newFullSet = null;
            if (!curFullSet.isEmpty()) {
                int moving = 0;
                for (Integer partId : curFullSet) {
                    if (top.localPartition(partId).state() != GridDhtPartitionState.MOVING) continue;
                    ++moving;
                }
                if (moving != curFullSet.size()) {
                    newFullSet = U.newHashSet(moving);
                    for (Integer partId : curFullSet) {
                        if (top.localPartition(partId).state() != GridDhtPartitionState.MOVING) continue;
                        newFullSet.add(partId);
                    }
                }
            }
            if (newHistMap == null && newFullSet == null) continue;
            if (newHistMap == null) {
                newHistMap = curHistMap;
            }
            if (newFullSet == null) {
                newFullSet = curFullSet;
            }
            if ((newMap = new IgniteDhtDemandedPartitionsMap(newHistMap, newFullSet)).isEmpty()) {
                it.remove();
                continue;
            }
            mapping.setValue(val.withNewPartitionsMap(newMap));
        }
    }

    public ClusterNode supplier(int part) {
        for (Map.Entry entry : this.entrySet()) {
            IgniteDhtDemandedPartitionsMap parts = ((GridDhtPartitionDemandMessage)entry.getValue()).partitions();
            if (!parts.hasHistorical(part) && !parts.hasFull(part)) continue;
            return (ClusterNode)entry.getKey();
        }
        return null;
    }
}

