/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteNeedReconnectException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtAffinityAssignmentResponse;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridDhtAssignmentFetchFuture
extends GridFutureAdapter<GridDhtAffinityAssignmentResponse> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private static final AtomicLong idGen;
    private final GridCacheSharedContext ctx;
    @GridToStringInclude
    private Queue<ClusterNode> availableNodes;
    private ClusterNode pendingNode;
    private final long id;
    private final AffinityTopologyVersion topVer;
    private final int grpId;
    private boolean needPartState;

    public GridDhtAssignmentFetchFuture(GridCacheSharedContext ctx, int grpId, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        this.topVer = topVer;
        this.grpId = grpId;
        this.ctx = ctx;
        this.id = idGen.getAndIncrement();
        List<ClusterNode> availableNodes = discoCache.cacheGroupAffinityNodes(grpId);
        LinkedList<ClusterNode> tmp = new LinkedList<ClusterNode>();
        for (ClusterNode node : availableNodes) {
            if (node.isLocal() || !ctx.discovery().alive(node)) continue;
            tmp.add(node);
        }
        Collections.sort(tmp, NodeOrderComparator.getInstance());
        this.availableNodes = tmp;
        if (log == null) {
            log = U.logger(ctx.kernalContext(), logRef, GridDhtAssignmentFetchFuture.class);
        }
    }

    public int groupId() {
        return this.grpId;
    }

    public long id() {
        return this.id;
    }

    public void init(boolean needPartState) {
        this.needPartState = needPartState;
        this.ctx.affinity().addDhtAssignmentFetchFuture(this);
        this.requestFromNextNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(UUID nodeId, GridDhtAffinityAssignmentResponse res) {
        GridDhtAffinityAssignmentResponse res0 = null;
        GridDhtAssignmentFetchFuture gridDhtAssignmentFetchFuture = this;
        synchronized (gridDhtAssignmentFetchFuture) {
            if (this.pendingNode != null && this.pendingNode.id().equals(nodeId)) {
                res0 = res;
            }
        }
        if (res0 != null) {
            this.onDone(res, (Throwable)res0.affinityAssignmentsError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeft(UUID leftNodeId) {
        GridDhtAssignmentFetchFuture gridDhtAssignmentFetchFuture = this;
        synchronized (gridDhtAssignmentFetchFuture) {
            if (this.pendingNode != null && this.pendingNode.id().equals(leftNodeId)) {
                this.availableNodes.remove(this.pendingNode);
                this.pendingNode = null;
            }
        }
        this.requestFromNextNode();
    }

    @Override
    public boolean onDone(@Nullable GridDhtAffinityAssignmentResponse res, @Nullable Throwable err) {
        if (super.onDone(res, err)) {
            this.ctx.affinity().removeDhtAssignmentFetchFuture(this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFromNextNode() {
        boolean complete;
        IgniteLogger log0 = log;
        GridDhtAssignmentFetchFuture gridDhtAssignmentFetchFuture = this;
        synchronized (gridDhtAssignmentFetchFuture) {
            while (!this.availableNodes.isEmpty()) {
                ClusterNode node = this.availableNodes.poll();
                try {
                    if (log0.isDebugEnabled()) {
                        log0.debug("Sending affinity fetch request to remote node [locNodeId=" + this.ctx.localNodeId() + ", node=" + node + "]");
                    }
                    this.ctx.io().send(node, (GridCacheMessage)new GridDhtAffinityAssignmentRequest(this.id, this.grpId, this.topVer, this.needPartState), (byte)4);
                    if (this.ctx.discovery().node(node.id()) == null) {
                        U.warn(log0, "Failed to request affinity assignment from remote node (node left grid, will continue to another node): " + node);
                        continue;
                    }
                    this.pendingNode = node;
                    break;
                }
                catch (ClusterTopologyCheckedException ignored) {
                    U.warn(log0, "Failed to request affinity assignment from remote node (node left grid, will continue to another node): " + node);
                }
                catch (IgniteCheckedException e) {
                    if (this.ctx.discovery().reconnectSupported() && X.hasCause((Throwable)e, IOException.class)) {
                        this.onDone(new IgniteNeedReconnectException(this.ctx.localNode(), (Throwable)e));
                        return;
                    }
                    U.warn(log0, "Failed to request affinity assignment from remote node (will continue to another node): " + node);
                }
            }
            complete = this.pendingNode == null;
        }
        if (complete) {
            this.onDone((GridDhtAffinityAssignmentResponse)null);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAssignmentFetchFuture.class, this);
    }

    static {
        idGen = new AtomicLong();
    }
}

