/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query;

import org.apache.ignite.cache.query.IndexQueryCriterion;

public final class RangeIndexQueryCriterion
implements IndexQueryCriterion {
    private static final long serialVersionUID = 0L;
    private final String field;
    private final Object lower;
    private final Object upper;
    private boolean lowerIncl;
    private boolean upperIncl;
    private boolean lowerNull;
    private boolean upperNull;

    public RangeIndexQueryCriterion(String field, Object lower, Object upper) {
        this.field = field;
        this.lower = lower;
        this.upper = upper;
    }

    public RangeIndexQueryCriterion swap() {
        RangeIndexQueryCriterion c = new RangeIndexQueryCriterion(this.field, this.upper, this.lower);
        c.lowerIncl(this.upperIncl);
        c.upperIncl(this.lowerIncl);
        c.lowerNull(this.upperNull);
        c.upperNull(this.lowerNull);
        return c;
    }

    public Object lower() {
        return this.lower;
    }

    public Object upper() {
        return this.upper;
    }

    public void lowerIncl(boolean lowerIncl) {
        this.lowerIncl = lowerIncl;
    }

    public boolean lowerIncl() {
        return this.lowerIncl;
    }

    public void upperIncl(boolean upperIncl) {
        this.upperIncl = upperIncl;
    }

    public boolean upperIncl() {
        return this.upperIncl;
    }

    public void lowerNull(boolean lowerNull) {
        this.lowerNull = lowerNull;
    }

    public boolean lowerNull() {
        return this.lowerNull;
    }

    public void upperNull(boolean upperNull) {
        this.upperNull = upperNull;
    }

    public boolean upperNull() {
        return this.upperNull;
    }

    @Override
    public String field() {
        return this.field;
    }

    public String toString() {
        return this.field + (this.lowerIncl ? "[" : "(") + this.lower + "; " + this.upper + (this.upperIncl ? "]" : ")");
    }
}

