/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.sql.DatabaseMetaData;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.completer.StringsCompleter;
import sqlline.Dialect;
import sqlline.SqlLine;
import sqlline.SqlLineCommandCompleter;
import sqlline.SqlLineParser;

class SqlCompleter
extends StringsCompleter {
    private static final String ALLOWED_UPPER_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
    private static final String ALLOWED_LOWER_CHARACTERS = "abcdefghijklmnopqrstuvwxyz0123456789_";
    private final SqlLine sqlLine;
    private final boolean skipMeta;

    SqlCompleter(SqlLine sqlLine, boolean skipMeta) {
        super(SqlCompleter.getCompletions(sqlLine, skipMeta));
        this.sqlLine = sqlLine;
        this.skipMeta = skipMeta;
    }

    private static Candidate[] getCompletions(SqlLine sqlLine, boolean skipMeta) {
        String function;
        TreeSet<Candidate> completions = new TreeSet<Candidate>();
        DatabaseMetaData meta = sqlLine.getDatabaseConnection().meta;
        try {
            for (String sqlKeyWord : meta.getSQLKeywords().split(",")) {
                String keyWord = sqlKeyWord.trim();
                completions.add(new SqlLineCommandCompleter.SqlLineCandidate(sqlLine, keyWord, keyWord, null, sqlLine.loc("keyword", new Object[0]), null, null, true));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String numericFunction : meta.getNumericFunctions().split(",")) {
                function = numericFunction.trim();
                completions.add(new SqlLineCommandCompleter.SqlLineCandidate(sqlLine, function, function, null, sqlLine.loc("function", new Object[0]), null, null, false));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String stringFunction : meta.getStringFunctions().split(",")) {
                function = stringFunction.trim();
                completions.add(new SqlLineCommandCompleter.SqlLineCandidate(sqlLine, function, function, null, sqlLine.loc("function", new Object[0]), null, null, false));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String systemFunction : meta.getSystemFunctions().split(",")) {
                function = systemFunction.trim();
                completions.add(new SqlLineCommandCompleter.SqlLineCandidate(sqlLine, function, function, null, sqlLine.loc("function", new Object[0]), null, null, false));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (String timeDateFunction : meta.getTimeDateFunctions().split(",")) {
                function = timeDateFunction.trim();
                completions.add(new SqlLineCommandCompleter.SqlLineCandidate(sqlLine, function, function, null, sqlLine.loc("function", new Object[0]), null, null, false));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!skipMeta) {
            try {
                String value;
                Dialect dialect = sqlLine.getDialect();
                Map<String, Map<String, Set<String>>> schema2tables = sqlLine.getDatabaseConnection().getSchema(true).getSchema2tables();
                for (String schemaName : schema2tables.keySet()) {
                    if (schemaName == null) continue;
                    value = SqlCompleter.writeAsDialectSpecificValue(dialect, false, schemaName);
                    completions.add(SqlCompleter.generateCandidate(schemaName, value, sqlLine, "schema", false));
                }
                for (String tableName : schema2tables.values().stream().flatMap(t -> t.keySet().stream()).collect(Collectors.toSet())) {
                    value = SqlCompleter.writeAsDialectSpecificValue(dialect, false, tableName);
                    completions.add(SqlCompleter.generateCandidate(tableName, value, sqlLine, "table", false));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (String keyWord : Dialect.DEFAULT_KEYWORD_SET) {
            completions.add(SqlCompleter.generateCandidate(keyWord, keyWord, sqlLine, "keyword", true));
        }
        return completions.toArray(new Candidate[0]);
    }

    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        String sql = commandLine.line().substring(0, commandLine.cursor());
        SqlLineParser.SqlLineArgumentList argumentList = ((SqlLineParser)this.sqlLine.getLineReader().getParser()).parseState(sql, sql.length(), Parser.ParseContext.UNSPECIFIED);
        String supplierMsg = argumentList.getSupplier().get();
        char openQuote = this.sqlLine.getDialect().getOpenQuote();
        if (argumentList.getState() == SqlLineParser.SqlParserState.MULTILINE_COMMENT || argumentList.getState() == SqlLineParser.SqlParserState.QUOTED && (openQuote == '\"' && !supplierMsg.endsWith("dquote") || openQuote == '`' && !supplierMsg.endsWith("`"))) {
            return;
        }
        if (!this.skipMeta) {
            Deque<String> lastWords = this.getSchemaTableColumn(argumentList.word());
            candidates.addAll(this.getSchemaBasedCandidates(new ArrayDeque<String>(lastWords)));
            candidates.addAll(this.getTableBasedCandidates(new ArrayDeque<String>(lastWords)));
        }
        if (argumentList.getState() != SqlLineParser.SqlParserState.QUOTED && (argumentList.getState() != SqlLineParser.SqlParserState.SEMICOLON_REQUIRED && argumentList.getState() != SqlLineParser.SqlParserState.ROUND_BRACKET_BALANCE_FAILED || sql.isEmpty() || sql.charAt(sql.length() - 1) != '.')) {
            candidates.addAll(this.candidates);
        }
    }

    private Collection<Candidate> getSchemaBasedCandidates(Deque<String> schemaTableColumn) {
        if (schemaTableColumn.size() > 3) {
            return Collections.emptySet();
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        Map<String, Map<String, Set<String>>> schema2tables = this.sqlLine.getDatabaseConnection().getSchema().getSchema2tables();
        String originalSchemaName = schemaTableColumn.pollFirst();
        Dialect dialect = this.sqlLine.getDialect();
        String schemaName = this.readAsDialectSpecificName(dialect, originalSchemaName);
        boolean need2Quote = this.isOriginalNameStartedQuoted(dialect, originalSchemaName);
        if (schemaName == null || schema2tables.get(schemaName) == null) {
            for (String sName : schema2tables.keySet()) {
                if (sName == null || !need2Quote) continue;
                String value = SqlCompleter.writeAsDialectSpecificValue(dialect, true, sName);
                candidates.add(SqlCompleter.generateCandidate(sName, value, this.sqlLine, "schema", false));
            }
            return candidates;
        }
        String originalTableName = schemaTableColumn.pollFirst();
        String tableName = this.readAsDialectSpecificName(dialect, originalTableName);
        boolean need2QuoteTableName = this.isOriginalNameStartedQuoted(dialect, originalTableName);
        if (tableName == null || !schema2tables.get(schemaName).containsKey(tableName)) {
            for (String tName : schema2tables.get(schemaName).keySet()) {
                String value = SqlCompleter.writeAsDialectSpecificValue(dialect, need2Quote, schemaName) + "." + SqlCompleter.writeAsDialectSpecificValue(dialect, need2QuoteTableName, tName);
                candidates.add(SqlCompleter.generateCandidate(tName, value, this.sqlLine, "table", true));
            }
        } else {
            Set<String> columnNames = this.sqlLine.getDatabaseConnection().getSchema().getColumnNames(schemaName, tableName);
            String userWrittenColumnName = schemaTableColumn.pollFirst();
            boolean need2QuoteColumnName = this.isOriginalNameStartedQuoted(dialect, userWrittenColumnName);
            for (String columnName : columnNames) {
                String value = SqlCompleter.writeAsDialectSpecificValue(dialect, need2Quote, schemaName) + "." + SqlCompleter.writeAsDialectSpecificValue(dialect, need2QuoteTableName, tableName) + "." + SqlCompleter.writeAsDialectSpecificValue(dialect, need2QuoteColumnName, columnName);
                candidates.add(SqlCompleter.generateCandidate(columnName, value, this.sqlLine, "column", true));
            }
        }
        return candidates;
    }

    private Collection<Candidate> getTableBasedCandidates(Deque<String> tableColumn) {
        if (tableColumn.size() > 2) {
            return Collections.emptySet();
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        HashMap<String, Set<String>> tables2columns = new HashMap<String, Set<String>>();
        for (Map<String, Set<String>> map : this.sqlLine.getDatabaseConnection().getSchema().getSchema2tables().values()) {
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                tables2columns.put(entry.getKey(), entry.getValue());
            }
        }
        Dialect dialect = this.sqlLine.getDialect();
        String originalTableName = tableColumn.pollFirst();
        String tableName = this.readAsDialectSpecificName(dialect, originalTableName);
        boolean need2QuoteTableName = this.isOriginalNameStartedQuoted(dialect, originalTableName);
        if (!tables2columns.containsKey(tableName)) {
            for (String tName : tables2columns.keySet()) {
                if (!need2QuoteTableName) continue;
                String value = SqlCompleter.writeAsDialectSpecificValue(dialect, true, tName);
                candidates.add(SqlCompleter.generateCandidate(tName, value, this.sqlLine, "table", false));
            }
            return candidates;
        }
        Set<String> columnNames = this.sqlLine.getDatabaseConnection().getSchema().getColumnNames(null, tableName);
        String userWrittenColumnName = tableColumn.pollFirst();
        boolean need2QuoteColumnName = this.isOriginalNameStartedQuoted(dialect, userWrittenColumnName);
        for (String columnName : columnNames) {
            String value = SqlCompleter.writeAsDialectSpecificValue(dialect, need2QuoteTableName, tableName) + "." + SqlCompleter.writeAsDialectSpecificValue(dialect, need2QuoteColumnName, columnName);
            candidates.add(SqlCompleter.generateCandidate(columnName, value, this.sqlLine, "column", true));
        }
        return candidates;
    }

    static Candidate generateCandidate(String sName, String value, SqlLine sqlLine, String descr, boolean complete) {
        return new Candidate(value, sName, null, sqlLine.loc(descr, new Object[0]), "table".equalsIgnoreCase(descr) || "schema".equalsIgnoreCase(descr) ? "." : null, null, complete);
    }

    Deque<String> getSchemaTableColumn(String word) {
        if (word.length() == 0) {
            return new ArrayDeque<String>(Collections.emptyList());
        }
        ArrayDeque<String> wordList = new ArrayDeque<String>();
        Dialect dialect = this.sqlLine.getDialect();
        String wordToCheck = this.addClosingSqlIdentifierIfRequired(dialect, word) ? word + dialect.getCloseQuote() : word;
        String[][] splitted = this.sqlLine.splitCompound(wordToCheck, true);
        if (splitted.length > 0) {
            for (String wordItem : splitted[0]) {
                if (wordItem.length() > 0) {
                    wordList.addLast(wordItem);
                    continue;
                }
                if (wordToCheck.charAt(wordToCheck.length() - 1) != dialect.getOpenQuote()) continue;
                wordList.addLast(String.valueOf(dialect.getOpenQuote()));
            }
        }
        return wordList;
    }

    private boolean addClosingSqlIdentifierIfRequired(Dialect dialect, String word) {
        if (word == null || word.isEmpty()) {
            return false;
        }
        int sqlIdentifierQuoteCounter = 0;
        for (int i = 0; i < word.length(); ++i) {
            if (word.charAt(i) != dialect.getOpenQuote() && word.charAt(i) != dialect.getCloseQuote() || this.sqlLine.isCharEscaped(word, i)) continue;
            ++sqlIdentifierQuoteCounter;
        }
        return sqlIdentifierQuoteCounter % 2 == 1;
    }

    String readAsDialectSpecificName(Dialect dialect, String originalName) {
        boolean isQuoted;
        if (originalName == null) {
            return null;
        }
        boolean bl = isQuoted = !originalName.isEmpty() && originalName.charAt(0) == dialect.getOpenQuote();
        if (isQuoted) {
            if (originalName.charAt(originalName.length() - 1) == dialect.getCloseQuote()) {
                return originalName.length() == 1 ? "" : originalName.substring(1, originalName.length() - 1);
            }
            return originalName.substring(1);
        }
        return dialect.isUpper() ? originalName.toUpperCase(Locale.ROOT) : (dialect.isLower() ? originalName.toLowerCase(Locale.ROOT) : originalName);
    }

    static String writeAsDialectSpecificValue(Dialect dialect, boolean forceQuote, String name2Write) {
        if (name2Write == null) {
            return null;
        }
        boolean needToQuote = false;
        if (forceQuote) {
            needToQuote = true;
        } else {
            boolean isUpper = dialect.isUpper();
            boolean isLower = dialect.isLower();
            String extraChars = dialect.getExtraNameCharacters();
            for (int i = 0; i < name2Write.length(); ++i) {
                if (isLower && ALLOWED_LOWER_CHARACTERS.indexOf(name2Write.charAt(i)) == -1 && extraChars.indexOf(name2Write.charAt(i)) == -1) {
                    needToQuote = true;
                    break;
                }
                if (isUpper && ALLOWED_UPPER_CHARACTERS.indexOf(name2Write.charAt(i)) == -1 && extraChars.indexOf(name2Write.charAt(i)) == -1) {
                    needToQuote = true;
                    break;
                }
                if (isLower || isUpper || ALLOWED_LOWER_CHARACTERS.indexOf(name2Write.charAt(i)) != -1 || ALLOWED_UPPER_CHARACTERS.indexOf(name2Write.charAt(i)) != -1 || extraChars.indexOf(name2Write.charAt(i)) != -1) continue;
                needToQuote = true;
                break;
            }
        }
        if (needToQuote) {
            StringBuilder result = new StringBuilder();
            result.append(dialect.getOpenQuote());
            for (char c : name2Write.toCharArray()) {
                if (c == dialect.getOpenQuote() || c == dialect.getCloseQuote()) {
                    result.append(c);
                }
                result.append(c);
            }
            result.append(dialect.getCloseQuote());
            return result.toString();
        }
        return name2Write;
    }

    private boolean isOriginalNameStartedQuoted(Dialect dialect, String originalName) {
        return originalName != null && !originalName.isEmpty() && originalName.charAt(0) == dialect.getOpenQuote();
    }
}

