/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReducer;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public abstract class AbstractReduceIndexAdapter
extends BaseIndex {
    protected AbstractReduceIndexAdapter(GridKernalContext ctx, Table tbl, String name, IndexType type, IndexColumn[] cols) {
        this.initBaseIndex(tbl, 0, name, cols, type);
    }

    abstract AbstractReducer reducer();

    public long getRowCount(Session ses) {
        Cursor c = this.find(ses, null, null);
        long cnt = 0L;
        while (c.next()) {
            ++cnt;
        }
        return cnt;
    }

    public long getRowCountApproximation() {
        return 10000L;
    }

    public final Cursor find(Session ses, SearchRow first, SearchRow last) {
        return this.reducer().find(first, last);
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void close(Session ses) {
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException((String)"findFirstOrLast");
    }

    public boolean needRebuild() {
        return false;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }
}

