/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.zk.internal.ZkDiscoveryEventData;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;
import org.jetbrains.annotations.Nullable;

class ZkDiscoveryEventsData
implements Serializable {
    private static final long serialVersionUID = 0L;
    final UUID clusterId;
    long procCustEvt = -1L;
    long evtIdGen;
    long topVer;
    long maxInternalOrder;
    final long clusterStartTime;
    final TreeMap<Long, ZkDiscoveryEventData> evts;
    private UUID commErrFutId;

    static ZkDiscoveryEventsData createForNewCluster(long clusterStartTime) {
        return new ZkDiscoveryEventsData(UUID.randomUUID(), clusterStartTime, 1L, new TreeMap<Long, ZkDiscoveryEventData>());
    }

    private ZkDiscoveryEventsData(UUID clusterId, long clusterStartTime, long topVer, TreeMap<Long, ZkDiscoveryEventData> evts) {
        this.clusterId = clusterId;
        this.clusterStartTime = clusterStartTime;
        this.topVer = topVer;
        this.evts = evts;
    }

    void onNodeJoin(ZookeeperClusterNode node) {
        if (node.internalId() > this.maxInternalOrder) {
            this.maxInternalOrder = node.internalId();
        }
    }

    @Nullable
    UUID communicationErrorResolveFutureId() {
        return this.commErrFutId;
    }

    void communicationErrorResolveFutureId(@Nullable UUID id) {
        this.commErrFutId = id;
    }

    void addEvent(Collection<ZookeeperClusterNode> nodes, ZkDiscoveryEventData evt) {
        ZkDiscoveryEventData old = this.evts.put(evt.eventId(), evt);
        assert (old == null) : old;
        evt.initRemainingAcks(nodes);
    }

    public String toString() {
        return S.toString(ZkDiscoveryEventsData.class, (Object)this, (String)"topVer", (Object)this.topVer, (String)"evtIdGen", (Object)this.evtIdGen, (String)"procCustEvt", (Object)this.procCustEvt, (String)"evts", this.evts);
    }
}

