/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractSystemView;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;
import org.jetbrains.annotations.Nullable;

public class SystemViewLocal<R>
extends SqlAbstractLocalSystemView {
    private static final Map<Class<?>, Function<Object, ? extends Value>> CLS_TO_VAL = new HashMap();
    private static final Function<Object, ? extends Value> DFLT_FUNC = val -> ValueString.get((String)Objects.toString(val));
    private static final Map<Class<?>, Integer> CLS_TO_VAL_TYPE = new HashMap();
    protected final SystemView<R> sysView;

    protected SystemViewLocal(GridKernalContext ctx, SystemView<R> sysView, String[] indexes) {
        super(MetricUtils.toSqlName((String)sysView.name()), sysView.description(), ctx, indexes, SystemViewLocal.columnsList(sysView));
        this.sysView = sysView;
    }

    public SystemViewLocal(GridKernalContext ctx, SystemView<R> sysView) {
        this(ctx, sysView, null);
    }

    protected Iterator<R> viewIterator(SearchRow first, SearchRow last) {
        return this.sysView.iterator();
    }

    @Override
    public Iterator<Row> getRows(final Session ses, SearchRow first, SearchRow last) {
        final Iterator<R> rows = this.viewIterator(first, last);
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return rows.hasNext();
            }

            @Override
            public Row next() {
                Object row = rows.next();
                Object[] data = new Value[SystemViewLocal.this.sysView.walker().count()];
                SystemViewLocal.this.sysView.walker().visitAll(row, new SystemViewRowAttributeWalker.AttributeWithValueVisitor((Value[])data){
                    final /* synthetic */ Value[] val$data;
                    {
                        this.val$data = valueArray;
                    }

                    public <T> void accept(int idx, String name, Class<T> clazz, @Nullable T val) {
                        this.val$data[idx] = val == null ? ValueNull.INSTANCE : CLS_TO_VAL.getOrDefault(clazz, DFLT_FUNC).apply(val);
                    }

                    public void acceptBoolean(int idx, String name, boolean val) {
                        this.val$data[idx] = ValueBoolean.get((boolean)val);
                    }

                    public void acceptChar(int idx, String name, char val) {
                        this.val$data[idx] = ValueString.get((String)Character.toString(val));
                    }

                    public void acceptByte(int idx, String name, byte val) {
                        this.val$data[idx] = ValueByte.get((byte)val);
                    }

                    public void acceptShort(int idx, String name, short val) {
                        this.val$data[idx] = ValueShort.get((short)val);
                    }

                    public void acceptInt(int idx, String name, int val) {
                        this.val$data[idx] = ValueInt.get((int)val);
                    }

                    public void acceptLong(int idx, String name, long val) {
                        this.val$data[idx] = ValueLong.get((long)val);
                    }

                    public void acceptFloat(int idx, String name, float val) {
                        this.val$data[idx] = ValueFloat.get((float)val);
                    }

                    public void acceptDouble(int idx, String name, double val) {
                        this.val$data[idx] = ValueDouble.get((double)val);
                    }
                });
                return SystemViewLocal.this.createRow(ses, data);
            }
        };
    }

    private static <R> Column[] columnsList(SystemView<R> sysView) {
        final Column[] cols = new Column[sysView.walker().count()];
        sysView.walker().visitAll(new SystemViewRowAttributeWalker.AttributeVisitor(){

            public <T> void accept(int idx, String name, Class<T> clazz) {
                int type = CLS_TO_VAL_TYPE.getOrDefault(clazz, 13);
                cols[idx] = SqlAbstractSystemView.newColumn(MetricUtils.toSqlName((String)name), type);
            }
        });
        return cols;
    }

    @Override
    public long getRowCount() {
        return this.sysView.size();
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    static {
        CLS_TO_VAL_TYPE.put(String.class, 13);
        CLS_TO_VAL_TYPE.put(IgniteUuid.class, 13);
        CLS_TO_VAL_TYPE.put(UUID.class, 20);
        CLS_TO_VAL_TYPE.put(Class.class, 13);
        CLS_TO_VAL_TYPE.put(InetSocketAddress.class, 13);
        CLS_TO_VAL_TYPE.put(BigDecimal.class, 6);
        CLS_TO_VAL_TYPE.put(BigInteger.class, 6);
        CLS_TO_VAL_TYPE.put(Date.class, 11);
        CLS_TO_VAL_TYPE.put(Boolean.TYPE, 1);
        CLS_TO_VAL_TYPE.put(Boolean.class, 1);
        CLS_TO_VAL_TYPE.put(Byte.TYPE, 2);
        CLS_TO_VAL_TYPE.put(Byte.class, 2);
        CLS_TO_VAL_TYPE.put(Short.TYPE, 3);
        CLS_TO_VAL_TYPE.put(Short.class, 3);
        CLS_TO_VAL_TYPE.put(Integer.TYPE, 4);
        CLS_TO_VAL_TYPE.put(Integer.class, 4);
        CLS_TO_VAL_TYPE.put(Long.TYPE, 5);
        CLS_TO_VAL_TYPE.put(Long.class, 5);
        CLS_TO_VAL_TYPE.put(Character.TYPE, 13);
        CLS_TO_VAL_TYPE.put(Character.class, 13);
        CLS_TO_VAL_TYPE.put(Float.TYPE, 8);
        CLS_TO_VAL_TYPE.put(Float.class, 8);
        CLS_TO_VAL_TYPE.put(Double.TYPE, 7);
        CLS_TO_VAL_TYPE.put(Double.class, 7);
        CLS_TO_VAL.put(String.class, val -> ValueString.get((String)Objects.toString(val)));
        CLS_TO_VAL.put(IgniteUuid.class, val -> ValueString.get((String)Objects.toString(val)));
        CLS_TO_VAL.put(UUID.class, val -> ValueUuid.get((UUID)((UUID)val)));
        CLS_TO_VAL.put(Class.class, val -> ValueString.get((String)((Class)val).getName()));
        CLS_TO_VAL.put(InetSocketAddress.class, val -> ValueString.get((String)Objects.toString(val)));
        CLS_TO_VAL.put(BigDecimal.class, val -> ValueDecimal.get((BigDecimal)((BigDecimal)val)));
        CLS_TO_VAL.put(BigInteger.class, val -> ValueDecimal.get((BigDecimal)new BigDecimal((BigInteger)val)));
        CLS_TO_VAL.put(Date.class, val -> ValueTimestamp.fromMillis((long)((Date)val).getTime()));
        CLS_TO_VAL.put(Boolean.class, val -> ValueBoolean.get((boolean)((Boolean)val)));
        CLS_TO_VAL.put(Byte.class, val -> ValueByte.get((byte)((Byte)val)));
        CLS_TO_VAL.put(Short.class, val -> ValueShort.get((short)((Short)val)));
        CLS_TO_VAL.put(Integer.class, val -> ValueInt.get((int)((Integer)val)));
        CLS_TO_VAL.put(Long.class, val -> ValueLong.get((long)((Long)val)));
        CLS_TO_VAL.put(Character.class, val -> ValueString.get((String)Objects.toString(val)));
        CLS_TO_VAL.put(Float.class, val -> ValueFloat.get((float)((Float)val).floatValue()));
        CLS_TO_VAL.put(Double.class, val -> ValueDouble.get((double)((Double)val)));
    }
}

